from abc import ABC, abstractmethod
from pathlib import Path

from .dependency import Dependencies

__all__ = [
    'InstallError',
    'DependencyInstaller',
    'Dependencies',
]


class InstallError(RuntimeError):
    pass


class DependencyInstaller(ABC):
    @abstractmethod
    def install(self, dependency: Dependencies, dependencies_destination: Path):
        """Installs dependencies."""
