"""
Основной пакет API для взаимодействия с ГИС Аксиома.

Предоставляет доступ к Аксиоме.ГИС через набор модулей, подмодулей, классов и функций.
"""
from axipy._internal import _loader

from .settings import *  # no dependencies
from .concurrent import *  # no dependencies
from .core import *  # no dependencies
from .sql import *  # no dependencies
from .utl import *  # no dependencies
from .cs import *  # no dependencies
from .da import *  # depends on axipy.cs, axipy.utl
from .render import *  # depends on axipy.da, axipy.cs, axipy.utl
from .gui import *  # depends on axipy.da, axipy.cs, axipy.utl, axipy.render, [axipy.app]
from .initialization import *  # depends on axipy.da, axipy.gui
from .app import *  # depends on axipy.da, axipy.gui, axipy.render
from .mi import *  # depends on axipy.da, axipy.gui, axipy.cs, axipy.utl
from .interface import *  # depends on axipy.da, axipy.gui
from .menubar import *  # depends on axipy.da, axipy.gui
from .axioma_plugin import *  # depends on interface, axipy.da, axipy.gui, axipy.menubar
from .plugin import *  # depends on axipy.app, axipy.da, axipy.gui, axipy.menubar
from .utils import *  # depends on axioma_plugin, settings, axipy.app


def __getattr__(name: str):
    """
    Backwards compatibility.
    """
    old_names = {
        # da
        "attribute_schema": schema,
        "DataManagerWrapper": data_manager_,
        # gui
        "ActiveToolPanel": active_tool_panel,
        "DialogWrapper": dialog,
        "Notifications": notifications,
        "SelectionManagerWrapper": selection_manager_,
        "ToolWrapper": map_tool,
        "view_manager_wrapper": view_manager_,
        "ViewWrapper": view,
        "WidgetWrapper": widgets,
        "Workspace": workspace,
        # mi
        "MIGeometry": mi_geometry,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
