from .label import Label
from PySide2.QtCore import Signal
from PySide2.QtGui import QColor
from axipy.cs import CoordSystem
from axipy.da import DataObject, Style
from axipy.utl import Rect
from typing import Union

class Layer:
    def __init__(self) -> None: ...
    @classmethod
    def create(cls, dataObject: DataObject) -> Layer: ...
    @property
    def data_changed(self) -> Signal: ...
    @property
    def need_redraw(self) -> Signal: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, n: str): ...
    @property
    def coordsystem(self) -> CoordSystem: ...
    @property
    def bounds(self) -> Rect: ...
    def get_bounds(self) -> Rect: ...
    @property
    def data_object(self) -> DataObject: ...
    @property
    def opacity(self) -> int: ...
    @opacity.setter
    def opacity(self, n: int): ...
    @property
    def zoom_restrict(self) -> bool: ...
    @zoom_restrict.setter
    def zoom_restrict(self, v: bool): ...
    @property
    def min_zoom(self) -> float: ...
    @min_zoom.setter
    def min_zoom(self, v: float): ...
    @property
    def max_zoom(self) -> float: ...
    @max_zoom.setter
    def max_zoom(self, v: float): ...
    def __eq__(self, other) -> bool: ...
    @property
    def visible(self): ...
    @visible.setter
    def visible(self, v) -> None: ...
    @property
    def is_valid(self) -> bool: ...

class ThematicLayer(Layer): ...

class ListThematic:
    def __init__(self) -> None: ...
    def append(self, lay: ThematicLayer): ...
    def add(self, lay: ThematicLayer): ...
    def remove(self, idx: int): ...
    def move(self, fromIdx: int, toIdx: int): ...
    @property
    def count(self) -> int: ...
    def at(self, idx: int) -> ThematicLayer: ...
    def __getitem__(self, item: Union[int, str]): ...
    def __len__(self) -> int: ...
    def __iter__(self): ...

class VectorLayer(Layer):
    @property
    def showCentroid(self) -> bool: ...
    @showCentroid.setter
    def showCentroid(self, n: bool): ...
    @property
    def nodesVisible(self) -> bool: ...
    @nodesVisible.setter
    def nodesVisible(self, n: bool): ...
    @property
    def linesDirectionVisibile(self) -> bool: ...
    @linesDirectionVisibile.setter
    def linesDirectionVisibile(self, n: bool): ...
    @property
    def overrideStyle(self) -> Style: ...
    @overrideStyle.setter
    def overrideStyle(self, style: Style): ...
    @property
    def thematic(self) -> ListThematic: ...
    @property
    def label(self) -> Label: ...
    @property
    def hotlink(self) -> str: ...
    @hotlink.setter
    def hotlink(self, expr: str): ...

class CosmeticLayer(VectorLayer): ...

class RasterLayer(Layer):
    @property
    def transparentColor(self) -> QColor: ...
    @transparentColor.setter
    def transparentColor(self, cl: QColor): ...
    @property
    def brightness(self) -> int: ...
    @brightness.setter
    def brightness(self, v: int): ...
    @property
    def contrast(self) -> int: ...
    @contrast.setter
    def contrast(self, v: int): ...
    @property
    def grayscale(self) -> bool: ...
    @grayscale.setter
    def grayscale(self, v: bool): ...
