from PySide2.QtCore import Signal
from PySide2.QtGui import QPaintEvent, QResizeEvent
from PySide2.QtWidgets import QDialog, QPushButton, QWidget
from _typeshed import Incomplete
from axipy.cs import CoordSystem
from axipy.da import Style
from axipy.utl import Rect
from typing import Optional

class BoundingRectDialog(QDialog):
    def __init__(self) -> None: ...
    @property
    def rect(self) -> Rect: ...
    @rect.setter
    def rect(self, r) -> None: ...
    @property
    def unit(self) -> str: ...
    @unit.setter
    def unit(self, v) -> None: ...
    @property
    def is_square(self) -> bool: ...
    @is_square.setter
    def is_square(self, v) -> None: ...

class ChooseCoordSystemDialog(QDialog):
    def __init__(self, coordsystem: CoordSystem = ...) -> None: ...
    def chosenCoordSystem(self) -> CoordSystem: ...

class StyleButton(QPushButton):
    def __init__(self, style: Optional[Style] = ..., parent: Optional[QWidget] = ...) -> None: ...
    @property
    def style(self) -> Style: ...
    @style.setter
    def style(self, v: Style): ...
    @property
    def style_changed(self) -> Signal: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...

class StyledButton(QPushButton):
    styleChanged: Incomplete
    def __init__(self, style: Optional[Style] = ..., parent: Optional[QWidget] = ...) -> None: ...
    def style(self) -> Style: ...
    def paintEvent(self, event: QPaintEvent) -> None: ...
    def resizeEvent(self, event: QResizeEvent) -> None: ...

class PasswordDialog(QDialog):
    def __init__(self) -> None: ...
    @property
    def user_name(self) -> str: ...
    @user_name.setter
    def user_name(self, v) -> None: ...
    @property
    def password(self) -> str: ...
    @password.setter
    def password(self, v) -> None: ...
