from PySide2.QtCore import QRect, Signal
from PySide2.QtGui import QTransform
from PySide2.QtPrintSupport import QPrinter
from PySide2.QtWidgets import QTableView, QWidget
from axipy.cs import CoordSystem, LinearUnit
from axipy.da import DataObject
from axipy.render import Legend, Map, Report, VectorLayer
from axipy.utl import Pnt, Rect
from typing import Optional

class View:
    def __init__(self) -> None: ...
    @property
    def widget(self) -> QWidget: ...
    @property
    def title(self) -> str: ...
    @title.setter
    def title(self, v: str): ...
    @property
    def rect(self) -> QRect: ...
    @rect.setter
    def rect(self, v: QRect): ...
    @property
    def position(self) -> QRect: ...
    @position.setter
    def position(self, v: QRect): ...
    SHOW_NORMAL: int
    SHOW_MINIMIZED: int
    SHOW_MAXIMIZED: int
    def show(self, type: int = ...): ...
    def close(self) -> None: ...
    @property
    def show_type(self) -> int: ...

class TableView(View):
    @property
    def data_object(self) -> DataObject: ...
    @property
    def table_view(self) -> QTableView: ...

class DrawableView(View):
    def __init__(self) -> None: ...
    @property
    def snap_mode(self) -> bool: ...
    @snap_mode.setter
    def snap_mode(self, v) -> None: ...
    def scale_with_center(self, scale: float, center: Pnt): ...
    @property
    def scene_changed(self) -> Signal: ...
    @property
    def is_modified(self) -> bool: ...
    @property
    def can_undo(self) -> bool: ...
    def undo(self) -> None: ...
    @property
    def can_redo(self) -> bool: ...
    def redo(self) -> None: ...
    def offset(self, dx: float, dy: float): ...

class Guidelines:
    def __init__(self) -> None: ...

class XGuidelines(Guidelines):
    def append(self, v) -> None: ...
    def __getitem__(self, idx): ...
    def __setitem__(self, idx, v) -> None: ...
    def __len__(self) -> int: ...

class YGuidelines(Guidelines):
    def append(self, v) -> None: ...
    def __getitem__(self, idx): ...
    def __setitem__(self, idx, v) -> None: ...
    def __len__(self) -> int: ...

class ReportView(DrawableView):
    def __init__(self) -> None: ...
    @property
    def report(self) -> Report: ...
    @property
    def show_mesh(self) -> bool: ...
    @show_mesh.setter
    def show_mesh(self, v) -> None: ...
    @property
    def snap_to_mesh(self) -> bool: ...
    @snap_to_mesh.setter
    def snap_to_mesh(self, v) -> None: ...
    @property
    def snap_to_guidelines(self) -> bool: ...
    @snap_to_guidelines.setter
    def snap_to_guidelines(self, v) -> None: ...
    @property
    def x_guidelines(self): ...
    @property
    def y_guidelines(self): ...
    def clear_guidelines(self) -> None: ...
    def clear_selected_guidelines(self) -> None: ...
    def fill_on_pages(self) -> None: ...
    @property
    def view_scale(self) -> float: ...
    @view_scale.setter
    def view_scale(self, v) -> None: ...
    @property
    def show_borders(self) -> float: ...
    @show_borders.setter
    def show_borders(self, v) -> None: ...
    @property
    def show_ruler(self) -> float: ...
    @show_ruler.setter
    def show_ruler(self, v) -> None: ...
    @property
    def mesh_size(self) -> float: ...
    @mesh_size.setter
    def mesh_size(self, v) -> None: ...
    def mouse_moved(self, x: float, y: float) -> Signal: ...
    def get_printer(self) -> QPrinter: ...
    def set_printer(self, printer: QPrinter): ...

class MapView(DrawableView):
    @property
    def map(self) -> Map: ...
    @property
    def coordsystem(self) -> CoordSystem: ...
    @coordsystem.setter
    def coordsystem(self, new_coordsystem) -> None: ...
    @property
    def editable_layer(self) -> Optional[VectorLayer]: ...
    @editable_layer.setter
    def editable_layer(self, layer) -> None: ...
    @property
    def selected_layer(self) -> Optional[VectorLayer]: ...
    @property
    def unit(self) -> LinearUnit: ...
    @unit.setter
    def unit(self, unit: LinearUnit): ...
    @property
    def scene_rect(self) -> Rect: ...
    @scene_rect.setter
    def scene_rect(self, rect: Rect): ...
    @property
    def device_rect(self) -> Rect: ...
    @property
    def scene_to_device_transform(self) -> QTransform: ...
    @property
    def device_to_scene_transform(self) -> QTransform: ...
    @property
    def editable_layer_changed(self) -> Signal: ...
    def zoom(self, unit: LinearUnit = ...) -> float: ...
    def set_zoom(self, zoom: float, unit: LinearUnit = ...): ...
    def set_zoom_and_center(self, zoom: float, center: Pnt, unit: LinearUnit = ...): ...
    @property
    def center(self) -> Pnt: ...
    @center.setter
    def center(self, p: Pnt): ...
    @property
    def scale(self) -> float: ...
    @scale.setter
    def scale(self, v: float): ...
    def show_all(self) -> None: ...
    def show_selection(self) -> None: ...
    @property
    def coordsystem_changed(self) -> Signal: ...
    def mouse_moved(self, x: float, y: float) -> Signal: ...
    @property
    def coordsystem_visual(self) -> CoordSystem: ...

class ListLegend:
    def append(self, legend: Legend): ...
    def __getitem__(self, idx: int): ...
    def __len__(self) -> int: ...
    def remove(self, idx: int): ...
    def __iter__(self): ...

class LegendView(View):
    @property
    def legends(self) -> ListLegend: ...
    def arrange(self) -> None: ...
