from PySide2.QtCore import QObject, QUrl
from PySide2.QtGui import QIcon
from PySide2.QtWidgets import QDockWidget, QMainWindow, QMdiSubWindow
from _typeshed import Incomplete
from axipy.da import DataManager
from axipy.gui import MapView, View
from axipy.render import Layer
from enum import Enum
from typing import Optional

class DockWidgetArea(Enum):
    Left: Incomplete
    Right: Incomplete
    Top: Incomplete
    Bottom: Incomplete

class MainWindow(QObject):
    def __init__(self) -> None: ...
    @staticmethod
    def show() -> MainWindow: ...
    def service(self): ...
    @property
    def is_valid(self) -> bool: ...
    def qt_object(self) -> QMainWindow: ...
    @property
    def catalog(self) -> DataManager: ...
    def add(self, view: View) -> QMdiSubWindow: ...
    def load_workspace(self, fileName: str): ...
    def save_workspace(self, fileName: str): ...
    def add_layer_interactive(self, layer: Layer) -> MapView: ...
    def add_layer_current_map(self, layer: Layer) -> MapView: ...
    def add_layer_new_map(self, layer: Layer) -> MapView: ...
    def add_dock_widget(self, dock_widget: QDockWidget, area: DockWidgetArea, icon: QIcon = ...) -> bool: ...
    def remove_dock_widget(self, dock: QDockWidget): ...
    def show_html_url(self, url: QUrl, caption: Optional[str]): ...

mainwindow: Incomplete
