from typing import overload
import PySide2.QtCore
import PySide2.QtPositioning
import shiboken2
import typing
T = typing.TypeVar('T')

class QGeoCodeReply(PySide2.QtCore.QObject):
    class Error:
        CombinationError: typing.ClassVar[QGeoCodeReply.Error] = ...
        CommunicationError: typing.ClassVar[QGeoCodeReply.Error] = ...
        EngineNotSetError: typing.ClassVar[QGeoCodeReply.Error] = ...
        NoError: typing.ClassVar[QGeoCodeReply.Error] = ...
        ParseError: typing.ClassVar[QGeoCodeReply.Error] = ...
        UnknownError: typing.ClassVar[QGeoCodeReply.Error] = ...
        UnsupportedOptionError: typing.ClassVar[QGeoCodeReply.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoCodeReply.Error: ...
    CombinationError: typing.ClassVar[QGeoCodeReply.Error] = ...
    CommunicationError: typing.ClassVar[QGeoCodeReply.Error] = ...
    EngineNotSetError: typing.ClassVar[QGeoCodeReply.Error] = ...
    NoError: typing.ClassVar[QGeoCodeReply.Error] = ...
    ParseError: typing.ClassVar[QGeoCodeReply.Error] = ...
    UnknownError: typing.ClassVar[QGeoCodeReply.Error] = ...
    UnsupportedOptionError: typing.ClassVar[QGeoCodeReply.Error] = ...
    aborted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, error: QGeoCodeReply.Error, errorString: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., destroyed: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def addLocation(self, location: PySide2.QtPositioning.QGeoLocation) -> None: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def limit(self) -> int: ...
    def locations(self) -> typing.List[PySide2.QtPositioning.QGeoLocation]: ...
    def offset(self) -> int: ...
    def setError(self, error: QGeoCodeReply.Error, errorString: str) -> None: ...
    def setFinished(self, finished: bool) -> None: ...
    def setLimit(self, limit: int) -> None: ...
    def setLocations(self, locations: typing.Iterable[PySide2.QtPositioning.QGeoLocation]) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def setViewport(self, viewport: PySide2.QtPositioning.QGeoShape) -> None: ...
    def viewport(self) -> PySide2.QtPositioning.QGeoShape: ...

class QGeoCodingManager(PySide2.QtCore.QObject):
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @overload
    def geocode(self, searchString: str, limit: int = ..., offset: int = ..., bounds: PySide2.QtPositioning.QGeoShape = ...) -> QGeoCodeReply: ...
    @overload
    def geocode(self, address: PySide2.QtPositioning.QGeoAddress, bounds: PySide2.QtPositioning.QGeoShape = ...) -> QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate: PySide2.QtPositioning.QGeoCoordinate, bounds: PySide2.QtPositioning.QGeoShape = ...) -> QGeoCodeReply: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...

class QGeoCodingManagerEngine(PySide2.QtCore.QObject):
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def geocode(self, address: str, limit: int, offset: int, bounds: PySide2.QtPositioning.QGeoShape) -> QGeoCodeReply: ...
    @overload
    def geocode(self, address: PySide2.QtPositioning.QGeoAddress, bounds: PySide2.QtPositioning.QGeoShape) -> QGeoCodeReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def reverseGeocode(self, coordinate: PySide2.QtPositioning.QGeoCoordinate, bounds: PySide2.QtPositioning.QGeoShape) -> QGeoCodeReply: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...

class QGeoManeuver(shiboken2.Object):
    class InstructionDirection:
        DirectionBearLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionBearRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionForward: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionHardLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionHardRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionLightLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionLightRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionUTurnLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        DirectionUTurnRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        NoDirection: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoManeuver.InstructionDirection: ...
    DirectionBearLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionBearRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionForward: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionHardLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionHardRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionLightLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionLightRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionUTurnLeft: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    DirectionUTurnRight: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    NoDirection: typing.ClassVar[QGeoManeuver.InstructionDirection] = ...
    @overload
    def __init__(self, other: QGeoManeuver) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def direction(self) -> QGeoManeuver.InstructionDirection: ...
    def distanceToNextInstruction(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict[str,typing.Any]: ...
    def instructionText(self) -> str: ...
    def isValid(self) -> bool: ...
    def position(self) -> PySide2.QtPositioning.QGeoCoordinate: ...
    def setDirection(self, direction: QGeoManeuver.InstructionDirection) -> None: ...
    def setDistanceToNextInstruction(self, distance: float) -> None: ...
    def setExtendedAttributes(self, extendedAttributes: typing.Dict[str,typing.Any]) -> None: ...
    def setInstructionText(self, instructionText: str) -> None: ...
    def setPosition(self, position: PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    def setTimeToNextInstruction(self, secs: int) -> None: ...
    def setWaypoint(self, coordinate: PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    def timeToNextInstruction(self) -> int: ...
    def waypoint(self) -> PySide2.QtPositioning.QGeoCoordinate: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoRoute(shiboken2.Object):
    @overload
    def __init__(self, other: QGeoRoute) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bounds(self) -> PySide2.QtPositioning.QGeoRectangle: ...
    def distance(self) -> float: ...
    def extendedAttributes(self) -> typing.Dict[str,typing.Any]: ...
    def firstRouteSegment(self) -> QGeoRouteSegment: ...
    def path(self) -> typing.List[PySide2.QtPositioning.QGeoCoordinate]: ...
    def request(self) -> QGeoRouteRequest: ...
    def routeId(self) -> str: ...
    def setBounds(self, bounds: PySide2.QtPositioning.QGeoRectangle) -> None: ...
    def setDistance(self, distance: float) -> None: ...
    def setExtendedAttributes(self, extendedAttributes: typing.Dict[str,typing.Any]) -> None: ...
    def setFirstRouteSegment(self, routeSegment: QGeoRouteSegment) -> None: ...
    def setPath(self, path: typing.Iterable[PySide2.QtPositioning.QGeoCoordinate]) -> None: ...
    def setRequest(self, request: QGeoRouteRequest) -> None: ...
    def setRouteId(self, id: str) -> None: ...
    def setTravelMode(self, mode: QGeoRouteRequest.TravelMode) -> None: ...
    def setTravelTime(self, secs: int) -> None: ...
    def travelMode(self) -> QGeoRouteRequest.TravelMode: ...
    def travelTime(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoRouteReply(PySide2.QtCore.QObject):
    class Error:
        CommunicationError: typing.ClassVar[QGeoRouteReply.Error] = ...
        EngineNotSetError: typing.ClassVar[QGeoRouteReply.Error] = ...
        NoError: typing.ClassVar[QGeoRouteReply.Error] = ...
        ParseError: typing.ClassVar[QGeoRouteReply.Error] = ...
        UnknownError: typing.ClassVar[QGeoRouteReply.Error] = ...
        UnsupportedOptionError: typing.ClassVar[QGeoRouteReply.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteReply.Error: ...
    CommunicationError: typing.ClassVar[QGeoRouteReply.Error] = ...
    EngineNotSetError: typing.ClassVar[QGeoRouteReply.Error] = ...
    NoError: typing.ClassVar[QGeoRouteReply.Error] = ...
    ParseError: typing.ClassVar[QGeoRouteReply.Error] = ...
    UnknownError: typing.ClassVar[QGeoRouteReply.Error] = ...
    UnsupportedOptionError: typing.ClassVar[QGeoRouteReply.Error] = ...
    aborted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, error: QGeoRouteReply.Error, errorString: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, request: QGeoRouteRequest, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def addRoutes(self, routes: typing.Iterable[QGeoRoute]) -> None: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def request(self) -> QGeoRouteRequest: ...
    def routes(self) -> typing.List[QGeoRoute]: ...
    def setError(self, error: QGeoRouteReply.Error, errorString: str) -> None: ...
    def setFinished(self, finished: bool) -> None: ...
    def setRoutes(self, routes: typing.Iterable[QGeoRoute]) -> None: ...

class QGeoRouteRequest(shiboken2.Object):
    class FeatureType:
        DirtRoadFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        FerryFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        HighwayFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        MotorPoolLaneFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        NoFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        ParksFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        PublicTransitFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        TollFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        TrafficFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        TunnelFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.FeatureTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...

    class FeatureTypes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.FeatureTypes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureTypes: ...

    class FeatureWeight:
        AvoidFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
        DisallowFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
        NeutralFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
        PreferFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
        RequireFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.FeatureWeights: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...

    class FeatureWeights:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.FeatureWeights: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.FeatureWeights: ...

    class ManeuverDetail:
        BasicManeuvers: typing.ClassVar[QGeoRouteRequest.ManeuverDetail] = ...
        NoManeuvers: typing.ClassVar[QGeoRouteRequest.ManeuverDetail] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.ManeuverDetails: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...

    class ManeuverDetails:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.ManeuverDetails: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.ManeuverDetails: ...

    class RouteOptimization:
        FastestRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
        MostEconomicRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
        MostScenicRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
        ShortestRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.RouteOptimizations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...

    class RouteOptimizations:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.RouteOptimizations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.RouteOptimizations: ...

    class SegmentDetail:
        BasicSegmentData: typing.ClassVar[QGeoRouteRequest.SegmentDetail] = ...
        NoSegmentData: typing.ClassVar[QGeoRouteRequest.SegmentDetail] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.SegmentDetails: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...

    class SegmentDetails:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.SegmentDetails: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.SegmentDetails: ...

    class TravelMode:
        BicycleTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
        CarTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
        PedestrianTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
        PublicTransitTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
        TruckTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.TravelModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...

    class TravelModes:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoRouteRequest.TravelModes: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoRouteRequest.TravelModes: ...
    AvoidFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
    BasicManeuvers: typing.ClassVar[QGeoRouteRequest.ManeuverDetail] = ...
    BasicSegmentData: typing.ClassVar[QGeoRouteRequest.SegmentDetail] = ...
    BicycleTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
    CarTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
    DirtRoadFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    DisallowFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
    FastestRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
    FerryFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    HighwayFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    MostEconomicRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
    MostScenicRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
    MotorPoolLaneFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    NeutralFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
    NoFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    NoManeuvers: typing.ClassVar[QGeoRouteRequest.ManeuverDetail] = ...
    NoSegmentData: typing.ClassVar[QGeoRouteRequest.SegmentDetail] = ...
    ParksFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    PedestrianTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
    PreferFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
    PublicTransitFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    PublicTransitTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
    RequireFeatureWeight: typing.ClassVar[QGeoRouteRequest.FeatureWeight] = ...
    ShortestRoute: typing.ClassVar[QGeoRouteRequest.RouteOptimization] = ...
    TollFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    TrafficFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    TruckTravel: typing.ClassVar[QGeoRouteRequest.TravelMode] = ...
    TunnelFeature: typing.ClassVar[QGeoRouteRequest.FeatureType] = ...
    @overload
    def __init__(self, origin: PySide2.QtPositioning.QGeoCoordinate, destination: PySide2.QtPositioning.QGeoCoordinate) -> None: ...
    @overload
    def __init__(self, other: QGeoRouteRequest) -> None: ...
    @overload
    def __init__(self, waypoints: typing.Iterable[PySide2.QtPositioning.QGeoCoordinate] = ...) -> None: ...
    def departureTime(self) -> PySide2.QtCore.QDateTime: ...
    def excludeAreas(self) -> typing.List[PySide2.QtPositioning.QGeoRectangle]: ...
    def extraParameters(self) -> typing.Dict[str,typing.Any]: ...
    def featureTypes(self) -> typing.List[QGeoRouteRequest.FeatureType]: ...
    def featureWeight(self, featureType: QGeoRouteRequest.FeatureType) -> QGeoRouteRequest.FeatureWeight: ...
    def maneuverDetail(self) -> QGeoRouteRequest.ManeuverDetail: ...
    def numberAlternativeRoutes(self) -> int: ...
    def routeOptimization(self) -> typing.Union[QGeoRouteRequest.RouteOptimizations,QGeoRouteRequest.RouteOptimization]: ...
    def segmentDetail(self) -> QGeoRouteRequest.SegmentDetail: ...
    def setDepartureTime(self, departureTime: PySide2.QtCore.QDateTime) -> None: ...
    def setExcludeAreas(self, areas: typing.Iterable[PySide2.QtPositioning.QGeoRectangle]) -> None: ...
    def setExtraParameters(self, extraParameters: typing.Dict[str,typing.Any]) -> None: ...
    def setFeatureWeight(self, featureType: QGeoRouteRequest.FeatureType, featureWeight: QGeoRouteRequest.FeatureWeight) -> None: ...
    def setManeuverDetail(self, maneuverDetail: QGeoRouteRequest.ManeuverDetail) -> None: ...
    def setNumberAlternativeRoutes(self, alternatives: int) -> None: ...
    def setRouteOptimization(self, optimization: typing.Union[QGeoRouteRequest.RouteOptimizations,QGeoRouteRequest.RouteOptimization]) -> None: ...
    def setSegmentDetail(self, segmentDetail: QGeoRouteRequest.SegmentDetail) -> None: ...
    def setTravelModes(self, travelModes: typing.Union[QGeoRouteRequest.TravelModes,QGeoRouteRequest.TravelMode]) -> None: ...
    def setWaypoints(self, waypoints: typing.Iterable[PySide2.QtPositioning.QGeoCoordinate]) -> None: ...
    def setWaypointsMetadata(self, waypointMetadata: typing.Iterable[typing.Dict[str,typing.Any]]) -> None: ...
    def travelModes(self) -> typing.Union[QGeoRouteRequest.TravelModes,QGeoRouteRequest.TravelMode]: ...
    def waypoints(self) -> typing.List[PySide2.QtPositioning.QGeoCoordinate]: ...
    def waypointsMetadata(self) -> typing.List[typing.Dict[str,typing.Any]]: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoRouteSegment(shiboken2.Object):
    @overload
    def __init__(self, other: QGeoRouteSegment) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def distance(self) -> float: ...
    def isLegLastSegment(self) -> bool: ...
    def isValid(self) -> bool: ...
    def maneuver(self) -> QGeoManeuver: ...
    def nextRouteSegment(self) -> QGeoRouteSegment: ...
    def path(self) -> typing.List[PySide2.QtPositioning.QGeoCoordinate]: ...
    def setDistance(self, distance: float) -> None: ...
    def setManeuver(self, maneuver: QGeoManeuver) -> None: ...
    def setNextRouteSegment(self, routeSegment: QGeoRouteSegment) -> None: ...
    def setPath(self, path: typing.Iterable[PySide2.QtPositioning.QGeoCoordinate]) -> None: ...
    def setTravelTime(self, secs: int) -> None: ...
    def travelTime(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGeoRoutingManager(PySide2.QtCore.QObject):
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def calculateRoute(self, request: QGeoRouteRequest) -> QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    def setMeasurementSystem(self, system: PySide2.QtCore.QLocale.MeasurementSystem) -> None: ...
    def supportedFeatureTypes(self) -> typing.Union[QGeoRouteRequest.FeatureTypes,QGeoRouteRequest.FeatureType]: ...
    def supportedFeatureWeights(self) -> typing.Union[QGeoRouteRequest.FeatureWeights,QGeoRouteRequest.FeatureWeight]: ...
    def supportedManeuverDetails(self) -> typing.Union[QGeoRouteRequest.ManeuverDetails,QGeoRouteRequest.ManeuverDetail]: ...
    def supportedRouteOptimizations(self) -> typing.Union[QGeoRouteRequest.RouteOptimizations,QGeoRouteRequest.RouteOptimization]: ...
    def supportedSegmentDetails(self) -> typing.Union[QGeoRouteRequest.SegmentDetails,QGeoRouteRequest.SegmentDetail]: ...
    def supportedTravelModes(self) -> typing.Union[QGeoRouteRequest.TravelModes,QGeoRouteRequest.TravelMode]: ...
    def updateRoute(self, route: QGeoRoute, position: PySide2.QtPositioning.QGeoCoordinate) -> QGeoRouteReply: ...

class QGeoRoutingManagerEngine(PySide2.QtCore.QObject):
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def calculateRoute(self, request: QGeoRouteRequest) -> QGeoRouteReply: ...
    def locale(self) -> PySide2.QtCore.QLocale: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def measurementSystem(self) -> PySide2.QtCore.QLocale.MeasurementSystem: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    def setMeasurementSystem(self, system: PySide2.QtCore.QLocale.MeasurementSystem) -> None: ...
    def setSupportedFeatureTypes(self, featureTypes: typing.Union[QGeoRouteRequest.FeatureTypes,QGeoRouteRequest.FeatureType]) -> None: ...
    def setSupportedFeatureWeights(self, featureWeights: typing.Union[QGeoRouteRequest.FeatureWeights,QGeoRouteRequest.FeatureWeight]) -> None: ...
    def setSupportedManeuverDetails(self, maneuverDetails: typing.Union[QGeoRouteRequest.ManeuverDetails,QGeoRouteRequest.ManeuverDetail]) -> None: ...
    def setSupportedRouteOptimizations(self, optimizations: typing.Union[QGeoRouteRequest.RouteOptimizations,QGeoRouteRequest.RouteOptimization]) -> None: ...
    def setSupportedSegmentDetails(self, segmentDetails: typing.Union[QGeoRouteRequest.SegmentDetails,QGeoRouteRequest.SegmentDetail]) -> None: ...
    def setSupportedTravelModes(self, travelModes: typing.Union[QGeoRouteRequest.TravelModes,QGeoRouteRequest.TravelMode]) -> None: ...
    def supportedFeatureTypes(self) -> typing.Union[QGeoRouteRequest.FeatureTypes,QGeoRouteRequest.FeatureType]: ...
    def supportedFeatureWeights(self) -> typing.Union[QGeoRouteRequest.FeatureWeights,QGeoRouteRequest.FeatureWeight]: ...
    def supportedManeuverDetails(self) -> typing.Union[QGeoRouteRequest.ManeuverDetails,QGeoRouteRequest.ManeuverDetail]: ...
    def supportedRouteOptimizations(self) -> typing.Union[QGeoRouteRequest.RouteOptimizations,QGeoRouteRequest.RouteOptimization]: ...
    def supportedSegmentDetails(self) -> typing.Union[QGeoRouteRequest.SegmentDetails,QGeoRouteRequest.SegmentDetail]: ...
    def supportedTravelModes(self) -> typing.Union[QGeoRouteRequest.TravelModes,QGeoRouteRequest.TravelMode]: ...
    def updateRoute(self, route: QGeoRoute, position: PySide2.QtPositioning.QGeoCoordinate) -> QGeoRouteReply: ...

class QGeoServiceProvider(PySide2.QtCore.QObject):
    class Error:
        ConnectionError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        LoaderError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        MissingRequiredParameterError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        NoError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        NotSupportedError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        UnknownParameterError: typing.ClassVar[QGeoServiceProvider.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.Error: ...

    class GeocodingFeature:
        AnyGeocodingFeatures: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        LocalizedGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        NoGeocodingFeatures: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        OfflineGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        OnlineGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        ReverseGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...

    class GeocodingFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.GeocodingFeatures: ...

    class MappingFeature:
        AnyMappingFeatures: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
        LocalizedMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
        NoMappingFeatures: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
        OfflineMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
        OnlineMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.MappingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...

    class MappingFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.MappingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.MappingFeatures: ...

    class NavigationFeature:
        AnyNavigationFeatures: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
        NoNavigationFeatures: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
        OfflineNavigationFeature: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
        OnlineNavigationFeature: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.NavigationFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...

    class NavigationFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.NavigationFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.NavigationFeatures: ...

    class PlacesFeature:
        AnyPlacesFeatures: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        LocalizedPlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        NoPlacesFeatures: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        NotificationsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        OfflinePlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        OnlinePlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        PlaceMatchingFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        PlaceRecommendationsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        RemoveCategoryFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        RemovePlaceFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        SaveCategoryFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        SavePlaceFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        SearchSuggestionsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.PlacesFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...

    class PlacesFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.PlacesFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.PlacesFeatures: ...

    class RoutingFeature:
        AlternativeRoutesFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        AnyRoutingFeatures: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        ExcludeAreasRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        LocalizedRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        NoRoutingFeatures: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        OfflineRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        OnlineRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        RouteUpdatesFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.RoutingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...

    class RoutingFeatures:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QGeoServiceProvider.RoutingFeatures: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __rand__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __ror__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __rxor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
        def __xor__(self, other: typing.SupportsInt) -> QGeoServiceProvider.RoutingFeatures: ...
    AlternativeRoutesFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    AnyGeocodingFeatures: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    AnyMappingFeatures: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
    AnyNavigationFeatures: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
    AnyPlacesFeatures: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    AnyRoutingFeatures: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    ConnectionError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    ExcludeAreasRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    LoaderError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    LocalizedGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    LocalizedMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
    LocalizedPlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    LocalizedRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    MissingRequiredParameterError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    NoError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    NoGeocodingFeatures: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    NoMappingFeatures: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
    NoNavigationFeatures: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
    NoPlacesFeatures: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    NoRoutingFeatures: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    NotSupportedError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    NotificationsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    OfflineGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    OfflineMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
    OfflineNavigationFeature: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
    OfflinePlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    OfflineRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    OnlineGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    OnlineMappingFeature: typing.ClassVar[QGeoServiceProvider.MappingFeature] = ...
    OnlineNavigationFeature: typing.ClassVar[QGeoServiceProvider.NavigationFeature] = ...
    OnlinePlacesFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    OnlineRoutingFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    PlaceMatchingFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    PlaceRecommendationsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    RemoveCategoryFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    RemovePlaceFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    ReverseGeocodingFeature: typing.ClassVar[QGeoServiceProvider.GeocodingFeature] = ...
    RouteUpdatesFeature: typing.ClassVar[QGeoServiceProvider.RoutingFeature] = ...
    SaveCategoryFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    SavePlaceFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    SearchSuggestionsFeature: typing.ClassVar[QGeoServiceProvider.PlacesFeature] = ...
    UnknownParameterError: typing.ClassVar[QGeoServiceProvider.Error] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, providerName: str, parameters: typing.Dict[str,typing.Any] = ..., allowExperimental: bool = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def availableServiceProviders(cls) -> typing.List[str]: ...
    def error(self) -> QGeoServiceProvider.Error: ...
    def errorString(self) -> str: ...
    def geocodingError(self) -> QGeoServiceProvider.Error: ...
    def geocodingErrorString(self) -> str: ...
    def geocodingFeatures(self) -> typing.Union[QGeoServiceProvider.GeocodingFeatures,QGeoServiceProvider.GeocodingFeature]: ...
    def geocodingManager(self) -> QGeoCodingManager: ...
    def mappingError(self) -> QGeoServiceProvider.Error: ...
    def mappingErrorString(self) -> str: ...
    def mappingFeatures(self) -> typing.Union[QGeoServiceProvider.MappingFeatures,QGeoServiceProvider.MappingFeature]: ...
    def navigationError(self) -> QGeoServiceProvider.Error: ...
    def navigationErrorString(self) -> str: ...
    def navigationFeatures(self) -> typing.Union[QGeoServiceProvider.NavigationFeatures,QGeoServiceProvider.NavigationFeature]: ...
    def placeManager(self) -> QPlaceManager: ...
    def placesError(self) -> QGeoServiceProvider.Error: ...
    def placesErrorString(self) -> str: ...
    def placesFeatures(self) -> typing.Union[QGeoServiceProvider.PlacesFeatures,QGeoServiceProvider.PlacesFeature]: ...
    def routingError(self) -> QGeoServiceProvider.Error: ...
    def routingErrorString(self) -> str: ...
    def routingFeatures(self) -> typing.Union[QGeoServiceProvider.RoutingFeatures,QGeoServiceProvider.RoutingFeature]: ...
    def routingManager(self) -> QGeoRoutingManager: ...
    def setAllowExperimental(self, allow: bool) -> None: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    def setParameters(self, parameters: typing.Dict[str,typing.Any]) -> None: ...

class QGeoServiceProviderFactory(shiboken2.Object):
    def __init__(self) -> None: ...
    def createGeocodingManagerEngine(self, parameters: typing.Dict[str,typing.Any], error: QGeoServiceProvider.Error) -> typing.Tuple[QGeoCodingManagerEngine,str]: ...
    def createPlaceManagerEngine(self, parameters: typing.Dict[str,typing.Any], error: QGeoServiceProvider.Error) -> typing.Tuple[QPlaceManagerEngine,str]: ...
    def createRoutingManagerEngine(self, parameters: typing.Dict[str,typing.Any], error: QGeoServiceProvider.Error) -> typing.Tuple[QGeoRoutingManagerEngine,str]: ...

class QGeoServiceProviderFactoryV2(QGeoServiceProviderFactory):
    def __init__(self) -> None: ...

class QPlace(shiboken2.Object):
    @overload
    def __init__(self, other: QPlace) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def appendContactDetail(self, contactType: str, detail: QPlaceContactDetail) -> None: ...
    def attribution(self) -> str: ...
    def categories(self) -> typing.List[QPlaceCategory]: ...
    def contactDetails(self, contactType: str) -> typing.List[QPlaceContactDetail]: ...
    def contactTypes(self) -> typing.List[str]: ...
    def content(self, type: QPlaceContent.Type) -> typing.Dict[int,QPlaceContent]: ...
    def detailsFetched(self) -> bool: ...
    def extendedAttribute(self, attributeType: str) -> QPlaceAttribute: ...
    def extendedAttributeTypes(self) -> typing.List[str]: ...
    def icon(self) -> QPlaceIcon: ...
    def insertContent(self, type: QPlaceContent.Type, content: typing.Dict[int,QPlaceContent]) -> None: ...
    def isEmpty(self) -> bool: ...
    def location(self) -> PySide2.QtPositioning.QGeoLocation: ...
    def name(self) -> str: ...
    def placeId(self) -> str: ...
    def primaryEmail(self) -> str: ...
    def primaryFax(self) -> str: ...
    def primaryPhone(self) -> str: ...
    def primaryWebsite(self) -> PySide2.QtCore.QUrl: ...
    def ratings(self) -> QPlaceRatings: ...
    def removeContactDetails(self, contactType: str) -> None: ...
    def removeExtendedAttribute(self, attributeType: str) -> None: ...
    def setAttribution(self, attribution: str) -> None: ...
    def setCategories(self, categories: typing.Iterable[QPlaceCategory]) -> None: ...
    def setCategory(self, category: QPlaceCategory) -> None: ...
    def setContactDetails(self, contactType: str, details: typing.Iterable[QPlaceContactDetail]) -> None: ...
    def setContent(self, type: QPlaceContent.Type, content: typing.Dict[int,QPlaceContent]) -> None: ...
    def setDetailsFetched(self, fetched: bool) -> None: ...
    def setExtendedAttribute(self, attributeType: str, attribute: QPlaceAttribute) -> None: ...
    def setIcon(self, icon: QPlaceIcon) -> None: ...
    def setLocation(self, location: PySide2.QtPositioning.QGeoLocation) -> None: ...
    def setName(self, name: str) -> None: ...
    def setPlaceId(self, identifier: str) -> None: ...
    def setRatings(self, ratings: QPlaceRatings) -> None: ...
    def setSupplier(self, supplier: QPlaceSupplier) -> None: ...
    def setTotalContentCount(self, type: QPlaceContent.Type, total: int) -> None: ...
    def supplier(self) -> QPlaceSupplier: ...
    def totalContentCount(self, type: QPlaceContent.Type) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceAttribute(shiboken2.Object):
    OpeningHours: typing.ClassVar[str] = ...
    Payment: typing.ClassVar[str] = ...
    Provider: typing.ClassVar[str] = ...
    @overload
    def __init__(self, other: QPlaceAttribute) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def label(self) -> str: ...
    def setLabel(self, label: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceCategory(shiboken2.Object):
    @overload
    def __init__(self, other: QPlaceCategory) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def categoryId(self) -> str: ...
    def icon(self) -> QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setCategoryId(self, identifier: str) -> None: ...
    def setIcon(self, icon: QPlaceIcon) -> None: ...
    def setName(self, name: str) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceContactDetail(shiboken2.Object):
    Email: typing.ClassVar[str] = ...
    Fax: typing.ClassVar[str] = ...
    Phone: typing.ClassVar[str] = ...
    Website: typing.ClassVar[str] = ...
    @overload
    def __init__(self, other: QPlaceContactDetail) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def label(self) -> str: ...
    def setLabel(self, label: str) -> None: ...
    def setValue(self, value: str) -> None: ...
    def value(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceContent(shiboken2.Object):
    class Type:
        CustomType: typing.ClassVar[QPlaceContent.Type] = ...
        EditorialType: typing.ClassVar[QPlaceContent.Type] = ...
        ImageType: typing.ClassVar[QPlaceContent.Type] = ...
        NoType: typing.ClassVar[QPlaceContent.Type] = ...
        ReviewType: typing.ClassVar[QPlaceContent.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceContent.Type: ...
    CustomType: typing.ClassVar[QPlaceContent.Type] = ...
    EditorialType: typing.ClassVar[QPlaceContent.Type] = ...
    ImageType: typing.ClassVar[QPlaceContent.Type] = ...
    NoType: typing.ClassVar[QPlaceContent.Type] = ...
    ReviewType: typing.ClassVar[QPlaceContent.Type] = ...
    @overload
    def __init__(self, other: QPlaceContent) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def attribution(self) -> str: ...
    def setAttribution(self, attribution: str) -> None: ...
    def setSupplier(self, supplier: QPlaceSupplier) -> None: ...
    def setUser(self, user: QPlaceUser) -> None: ...
    def supplier(self) -> QPlaceSupplier: ...
    def type(self) -> QPlaceContent.Type: ...
    def user(self) -> QPlaceUser: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceContentReply(QPlaceReply):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def content(self) -> typing.Dict[int,QPlaceContent]: ...
    def nextPageRequest(self) -> QPlaceContentRequest: ...
    def previousPageRequest(self) -> QPlaceContentRequest: ...
    def request(self) -> QPlaceContentRequest: ...
    def setContent(self, content: typing.Dict[int,QPlaceContent]) -> None: ...
    def setNextPageRequest(self, next: QPlaceContentRequest) -> None: ...
    def setPreviousPageRequest(self, previous: QPlaceContentRequest) -> None: ...
    def setRequest(self, request: QPlaceContentRequest) -> None: ...
    def setTotalCount(self, total: int) -> None: ...
    def totalCount(self) -> int: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceContentRequest(shiboken2.Object):
    @overload
    def __init__(self, other: QPlaceContentRequest) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def contentContext(self) -> typing.Any: ...
    def contentType(self) -> QPlaceContent.Type: ...
    def limit(self) -> int: ...
    def placeId(self) -> str: ...
    def setContentContext(self, context: typing.Any) -> None: ...
    def setContentType(self, type: QPlaceContent.Type) -> None: ...
    def setLimit(self, limit: int) -> None: ...
    def setPlaceId(self, identifier: str) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceDetailsReply(QPlaceReply):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def place(self) -> QPlace: ...
    def setPlace(self, place: QPlace) -> None: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceEditorial(QPlaceContent):
    @overload
    def __init__(self, other: QPlaceContent) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def language(self) -> str: ...
    def setLanguage(self, data: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTitle(self, data: str) -> None: ...
    def text(self) -> str: ...
    def title(self) -> str: ...

class QPlaceIcon(shiboken2.Object):
    SingleUrl: typing.ClassVar[str] = ...
    @overload
    def __init__(self, other: QPlaceIcon) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def manager(self) -> QPlaceManager: ...
    def parameters(self) -> typing.Dict[str,typing.Any]: ...
    def setManager(self, manager: QPlaceManager) -> None: ...
    def setParameters(self, parameters: typing.Dict[str,typing.Any]) -> None: ...
    def url(self, size: PySide2.QtCore.QSize = ...) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceIdReply(QPlaceReply):
    class OperationType:
        RemoveCategory: typing.ClassVar[QPlaceIdReply.OperationType] = ...
        RemovePlace: typing.ClassVar[QPlaceIdReply.OperationType] = ...
        SaveCategory: typing.ClassVar[QPlaceIdReply.OperationType] = ...
        SavePlace: typing.ClassVar[QPlaceIdReply.OperationType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceIdReply.OperationType: ...
    RemoveCategory: typing.ClassVar[QPlaceIdReply.OperationType] = ...
    RemovePlace: typing.ClassVar[QPlaceIdReply.OperationType] = ...
    SaveCategory: typing.ClassVar[QPlaceIdReply.OperationType] = ...
    SavePlace: typing.ClassVar[QPlaceIdReply.OperationType] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, operationType: QPlaceIdReply.OperationType, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def id(self) -> str: ...
    def operationType(self) -> QPlaceIdReply.OperationType: ...
    def setId(self, identifier: str) -> None: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceImage(QPlaceContent):
    @overload
    def __init__(self, other: QPlaceContent) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def imageId(self) -> str: ...
    def mimeType(self) -> str: ...
    def setImageId(self, identifier: str) -> None: ...
    def setMimeType(self, data: str) -> None: ...
    def setUrl(self, url: PySide2.QtCore.QUrl) -> None: ...
    def url(self) -> PySide2.QtCore.QUrl: ...

class QPlaceManager(PySide2.QtCore.QObject):
    categoryAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    categoryRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    categoryUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def category(self, categoryId: str) -> QPlaceCategory: ...
    def childCategories(self, parentId: str = ...) -> typing.List[QPlaceCategory]: ...
    def childCategoryIds(self, parentId: str = ...) -> typing.List[str]: ...
    def compatiblePlace(self, place: QPlace) -> QPlace: ...
    def getPlaceContent(self, request: QPlaceContentRequest) -> QPlaceContentReply: ...
    def getPlaceDetails(self, placeId: str) -> QPlaceDetailsReply: ...
    def initializeCategories(self) -> QPlaceReply: ...
    def locales(self) -> typing.List[PySide2.QtCore.QLocale]: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request: QPlaceMatchRequest) -> QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId: str) -> str: ...
    def removeCategory(self, categoryId: str) -> QPlaceIdReply: ...
    def removePlace(self, placeId: str) -> QPlaceIdReply: ...
    def saveCategory(self, category: QPlaceCategory, parentId: str = ...) -> QPlaceIdReply: ...
    def savePlace(self, place: QPlace) -> QPlaceIdReply: ...
    def search(self, query: QPlaceSearchRequest) -> QPlaceSearchReply: ...
    def searchSuggestions(self, request: QPlaceSearchRequest) -> QPlaceSearchSuggestionReply: ...
    def setLocale(self, locale: PySide2.QtCore.QLocale) -> None: ...
    def setLocales(self, locale: typing.Iterable[PySide2.QtCore.QLocale]) -> None: ...

class QPlaceManagerEngine(PySide2.QtCore.QObject):
    categoryAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    categoryRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    categoryUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeAdded: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeRemoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    placeUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parameters: typing.Dict[str,typing.Any], parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def category(self, categoryId: str) -> QPlaceCategory: ...
    def childCategories(self, parentId: str) -> typing.List[QPlaceCategory]: ...
    def childCategoryIds(self, categoryId: str) -> typing.List[str]: ...
    def compatiblePlace(self, original: QPlace) -> QPlace: ...
    def constructIconUrl(self, icon: QPlaceIcon, size: PySide2.QtCore.QSize) -> PySide2.QtCore.QUrl: ...
    def getPlaceContent(self, request: QPlaceContentRequest) -> QPlaceContentReply: ...
    def getPlaceDetails(self, placeId: str) -> QPlaceDetailsReply: ...
    def initializeCategories(self) -> QPlaceReply: ...
    def locales(self) -> typing.List[PySide2.QtCore.QLocale]: ...
    def manager(self) -> QPlaceManager: ...
    def managerName(self) -> str: ...
    def managerVersion(self) -> int: ...
    def matchingPlaces(self, request: QPlaceMatchRequest) -> QPlaceMatchReply: ...
    def parentCategoryId(self, categoryId: str) -> str: ...
    def removeCategory(self, categoryId: str) -> QPlaceIdReply: ...
    def removePlace(self, placeId: str) -> QPlaceIdReply: ...
    def saveCategory(self, category: QPlaceCategory, parentId: str) -> QPlaceIdReply: ...
    def savePlace(self, place: QPlace) -> QPlaceIdReply: ...
    def search(self, request: QPlaceSearchRequest) -> QPlaceSearchReply: ...
    def searchSuggestions(self, request: QPlaceSearchRequest) -> QPlaceSearchSuggestionReply: ...
    def setLocales(self, locales: typing.Iterable[PySide2.QtCore.QLocale]) -> None: ...

class QPlaceMatchReply(QPlaceReply):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def places(self) -> typing.List[QPlace]: ...
    def request(self) -> QPlaceMatchRequest: ...
    def setPlaces(self, results: typing.Iterable[QPlace]) -> None: ...
    def setRequest(self, request: QPlaceMatchRequest) -> None: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceMatchRequest(shiboken2.Object):
    AlternativeId: typing.ClassVar[str] = ...
    @overload
    def __init__(self, other: QPlaceMatchRequest) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def parameters(self) -> typing.Dict[str,typing.Any]: ...
    def places(self) -> typing.List[QPlace]: ...
    def setParameters(self, parameters: typing.Dict[str,typing.Any]) -> None: ...
    def setPlaces(self, places: typing.Iterable[QPlace]) -> None: ...
    def setResults(self, results: typing.Iterable[QPlaceSearchResult]) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceProposedSearchResult(QPlaceSearchResult):
    @overload
    def __init__(self, other: QPlaceSearchResult) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def searchRequest(self) -> QPlaceSearchRequest: ...
    def setSearchRequest(self, request: QPlaceSearchRequest) -> None: ...

class QPlaceRatings(shiboken2.Object):
    @overload
    def __init__(self, other: QPlaceRatings) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def average(self) -> float: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximum(self) -> float: ...
    def setAverage(self, average: float) -> None: ...
    def setCount(self, count: int) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceReply(PySide2.QtCore.QObject):
    class Error:
        BadArgumentError: typing.ClassVar[QPlaceReply.Error] = ...
        CancelError: typing.ClassVar[QPlaceReply.Error] = ...
        CategoryDoesNotExistError: typing.ClassVar[QPlaceReply.Error] = ...
        CommunicationError: typing.ClassVar[QPlaceReply.Error] = ...
        NoError: typing.ClassVar[QPlaceReply.Error] = ...
        ParseError: typing.ClassVar[QPlaceReply.Error] = ...
        PermissionsError: typing.ClassVar[QPlaceReply.Error] = ...
        PlaceDoesNotExistError: typing.ClassVar[QPlaceReply.Error] = ...
        UnknownError: typing.ClassVar[QPlaceReply.Error] = ...
        UnsupportedError: typing.ClassVar[QPlaceReply.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceReply.Error: ...

    class Type:
        ContentReply: typing.ClassVar[QPlaceReply.Type] = ...
        DetailsReply: typing.ClassVar[QPlaceReply.Type] = ...
        IdReply: typing.ClassVar[QPlaceReply.Type] = ...
        MatchReply: typing.ClassVar[QPlaceReply.Type] = ...
        Reply: typing.ClassVar[QPlaceReply.Type] = ...
        SearchReply: typing.ClassVar[QPlaceReply.Type] = ...
        SearchSuggestionReply: typing.ClassVar[QPlaceReply.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceReply.Type: ...
    BadArgumentError: typing.ClassVar[QPlaceReply.Error] = ...
    CancelError: typing.ClassVar[QPlaceReply.Error] = ...
    CategoryDoesNotExistError: typing.ClassVar[QPlaceReply.Error] = ...
    CommunicationError: typing.ClassVar[QPlaceReply.Error] = ...
    ContentReply: typing.ClassVar[QPlaceReply.Type] = ...
    DetailsReply: typing.ClassVar[QPlaceReply.Type] = ...
    IdReply: typing.ClassVar[QPlaceReply.Type] = ...
    MatchReply: typing.ClassVar[QPlaceReply.Type] = ...
    NoError: typing.ClassVar[QPlaceReply.Error] = ...
    ParseError: typing.ClassVar[QPlaceReply.Error] = ...
    PermissionsError: typing.ClassVar[QPlaceReply.Error] = ...
    PlaceDoesNotExistError: typing.ClassVar[QPlaceReply.Error] = ...
    Reply: typing.ClassVar[QPlaceReply.Type] = ...
    SearchReply: typing.ClassVar[QPlaceReply.Type] = ...
    SearchSuggestionReply: typing.ClassVar[QPlaceReply.Type] = ...
    UnknownError: typing.ClassVar[QPlaceReply.Error] = ...
    UnsupportedError: typing.ClassVar[QPlaceReply.Error] = ...
    aborted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    contentUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    finished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def errorString(self) -> str: ...
    def isFinished(self) -> bool: ...
    def setError(self, error: QPlaceReply.Error, errorString: str) -> None: ...
    def setFinished(self, finished: bool) -> None: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceResult(QPlaceSearchResult):
    @overload
    def __init__(self, other: QPlaceSearchResult) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def distance(self) -> float: ...
    def isSponsored(self) -> bool: ...
    def place(self) -> QPlace: ...
    def setDistance(self, distance: float) -> None: ...
    def setPlace(self, place: QPlace) -> None: ...
    def setSponsored(self, sponsored: bool) -> None: ...

class QPlaceReview(QPlaceContent):
    @overload
    def __init__(self, other: QPlaceContent) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def dateTime(self) -> PySide2.QtCore.QDateTime: ...
    def language(self) -> str: ...
    def rating(self) -> float: ...
    def reviewId(self) -> str: ...
    def setDateTime(self, dt: PySide2.QtCore.QDateTime) -> None: ...
    def setLanguage(self, data: str) -> None: ...
    def setRating(self, data: float) -> None: ...
    def setReviewId(self, identifier: str) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTitle(self, data: str) -> None: ...
    def text(self) -> str: ...
    def title(self) -> str: ...

class QPlaceSearchReply(QPlaceReply):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def nextPageRequest(self) -> QPlaceSearchRequest: ...
    def previousPageRequest(self) -> QPlaceSearchRequest: ...
    def request(self) -> QPlaceSearchRequest: ...
    def results(self) -> typing.List[QPlaceSearchResult]: ...
    def setNextPageRequest(self, next: QPlaceSearchRequest) -> None: ...
    def setPreviousPageRequest(self, previous: QPlaceSearchRequest) -> None: ...
    def setRequest(self, request: QPlaceSearchRequest) -> None: ...
    def setResults(self, results: typing.Iterable[QPlaceSearchResult]) -> None: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceSearchRequest(shiboken2.Object):
    class RelevanceHint:
        DistanceHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
        LexicalPlaceNameHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
        UnspecifiedHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceSearchRequest.RelevanceHint: ...
    DistanceHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
    LexicalPlaceNameHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
    UnspecifiedHint: typing.ClassVar[QPlaceSearchRequest.RelevanceHint] = ...
    @overload
    def __init__(self, other: QPlaceSearchRequest) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def categories(self) -> typing.List[QPlaceCategory]: ...
    def clear(self) -> None: ...
    def limit(self) -> int: ...
    def recommendationId(self) -> str: ...
    def relevanceHint(self) -> QPlaceSearchRequest.RelevanceHint: ...
    def searchArea(self) -> PySide2.QtPositioning.QGeoShape: ...
    def searchContext(self) -> typing.Any: ...
    def searchTerm(self) -> str: ...
    def setCategories(self, categories: typing.Iterable[QPlaceCategory]) -> None: ...
    def setCategory(self, category: QPlaceCategory) -> None: ...
    def setLimit(self, limit: int) -> None: ...
    def setRecommendationId(self, recommendationId: str) -> None: ...
    def setRelevanceHint(self, hint: QPlaceSearchRequest.RelevanceHint) -> None: ...
    def setSearchArea(self, area: PySide2.QtPositioning.QGeoShape) -> None: ...
    def setSearchContext(self, context: typing.Any) -> None: ...
    def setSearchTerm(self, term: str) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceSearchResult(shiboken2.Object):
    class SearchResultType:
        PlaceResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
        ProposedSearchResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
        UnknownSearchResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __and__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __rand__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __ror__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __sub__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
        def __xor__(self, other: typing.SupportsInt) -> QPlaceSearchResult.SearchResultType: ...
    PlaceResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
    ProposedSearchResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
    UnknownSearchResult: typing.ClassVar[QPlaceSearchResult.SearchResultType] = ...
    @overload
    def __init__(self, other: QPlaceSearchResult) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def icon(self) -> QPlaceIcon: ...
    def setIcon(self, icon: QPlaceIcon) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def type(self) -> QPlaceSearchResult.SearchResultType: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceSearchSuggestionReply(QPlaceReply):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aborted: typing.Callable = ..., contentUpdated: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def setSuggestions(self, suggestions: typing.Iterable[str]) -> None: ...
    def suggestions(self) -> typing.List[str]: ...
    def type(self) -> QPlaceReply.Type: ...

class QPlaceSupplier(shiboken2.Object):
    @overload
    def __init__(self, other: QPlaceSupplier) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def icon(self) -> QPlaceIcon: ...
    def isEmpty(self) -> bool: ...
    def name(self) -> str: ...
    def setIcon(self, icon: QPlaceIcon) -> None: ...
    def setName(self, data: str) -> None: ...
    def setSupplierId(self, identifier: str) -> None: ...
    def setUrl(self, data: PySide2.QtCore.QUrl) -> None: ...
    def supplierId(self) -> str: ...
    def url(self) -> PySide2.QtCore.QUrl: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPlaceUser(shiboken2.Object):
    @overload
    def __init__(self, other: QPlaceUser) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def setUserId(self, identifier: str) -> None: ...
    def userId(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
