from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class GdalSource(Source):
    pass


class GdalDataProvider(DataProvider):
    """Провайдер для растров.
    
    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.da.provider_manager.gdal`.
    """
    _identifier = 'GdalDataProvider'

    def get_source(self, data: str, alias: str = None) -> Source:
        """Создает источник данных.

        Args:
          data: Имя файла или описание источника данных.
        """
        return GdalSource(
            Source._provider(self.id),
            Source._alias(alias),
            {
                'src': data
            }
        )

    def open(self, data: str, alias: str = None) -> Table:
        """Открывает объект данных.

        Args:
          data: Имя файла или описание источника данных.
          alias: Псевдоним для открываемого растра.
        """
        return self.get_source(data, alias).open()

    def get_destination(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
    
    def create_open(self):
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
