from PySide2.QtWidgets import QMessageBox
from axipy import AxiomaPlugin, Position


class Plugin(AxiomaPlugin):
    def load(self):
        self.__action = self.create_action('Пример действия',
                icon='://icons/share/32px/run3.png', on_click=self.show_message)
        position = Position('Основные', 'Команды')
        position.add(self.__action)
        self.__action.action.setToolTip('Всплывающая подсказка')

    def unload(self):
        self.__action.remove()

    def show_message(self):
        QMessageBox.information(None, 'Сообщение',
                'Пример выполнения действия по нажатию кнопки')
