from pathlib import Path
from typing import Optional
import logging


__all__ = [
    'Dependencies',
]


class Dependencies:
    def __init__(self, requirements_file: Path):
        self.__requirements_file = requirements_file

    @property
    def requirements(self) -> Path:
        '''File with requirements.'''
        return self.__requirements_file

    @staticmethod
    def find(plugin_dir: Path) -> Optional['Dependencies']:
        '''Finds dependencies in a plugin.'''
        requirements_file = plugin_dir / 'requirements.txt'
        logging.debug(f'Check file with deps: {requirements_file}')
        if not requirements_file.is_file():
            return None
        return Dependencies(requirements_file)
