from axipy.utl import Rect
from PySide2.QtGui import QPainter

from axipy.cpp_render import ShadowContext
from axipy.cs import CoordSystem


class Context:
    """Контекст рисования.

    Содержит информацию о том, куда производится рисование (QPainter),
    а так же о необходимых преобразованиях, которые необходимо применить
    к объекту непосредственно перед его отрисовкой.

    Args:
      painter: Объект QPainter для рисования.

    Пример создания контекста на базе растра. Далее его можно использовать для отрисовки карты :class:`Map`, отчета  :class:`Report` 
    или легенды  :class:`Legend`:

    .. literalinclude:: /../../tests/doc_examples/test_example_context.py
        :pyobject: test_run_example_context
        :lines: 2-
        :dedent: 4
    """

    def __init__(self, painter: QPainter):
        self.shadow = ShadowContext(painter)

    @property
    def rect(self) -> Rect:
        """Прямоугольник в координатах карты, который будет отрисован.
        """
        return Rect.from_qt(self.shadow.get_rect())

    @rect.setter
    def rect(self, r: Rect):
        self.shadow.set_rect(r.to_qt())

    @property
    def coordsystem(self) -> CoordSystem:
        """Координатная система.

        Если она не задана, берется наиболее подходящая исходя из текущего контента.
        """
        return CoordSystem._wrap(self.shadow.get_cs())

    @coordsystem.setter
    def coordsystem(self, cs: CoordSystem):
        return self.shadow.set_cs(cs.shadow)

    @property
    def dpi(self) -> float:
        """Количество точек на дюйм, с которым происходит рисование.

        Влияет на отрисовку в «реальных» единицах измерения (мм, см, пункты).
        """
        return self.shadow.get_dpi()

    @dpi.setter
    def dpi(self, v: float):
        return self.shadow.set_dpi(v)
