
from axioma.core import ProgressHandler, Range

from PyQt5.QtCore import QWriteLocker, QReadLocker, QReadWriteLock, pyqtSignal


class PythonProgressHandler(ProgressHandler):
    """
    Сущность с помощью которой пользователь может управлять прогрессом и 
    получать результат 
    """

    pythonError = pyqtSignal(tuple)

    def __init__(self):
        super(PythonProgressHandler, self).__init__()
        self.__lock = QReadWriteLock()
        self.__result = None
        self.wasResult = False

    def setProgressRange(self, min: int, max: int):
        range = Range(min, max)
        self.progressRangeChanged.emit(range)

    def setProgress(self, value: int):
        self.progressValueChanged.emit(value)

    def setMessage(self, message: str):
        self.messageChanged.emit(message)

    def setWindowTitle(self, title: str):
        self.windowTitleChanged.emit(title)

    def setResult(self, result):
        locker = QWriteLocker(self.__lock)
        self.wasResult = True
        self.__result = result

    def result(self): 
        locker = QReadLocker(self.__lock)
        return self.__result