"""
Вспмогательный модуль с функциями, используемыми во всем плагине.
"""
from typing import Union

from PySide2.QtWidgets import QHBoxLayout
from axipy import tr
from axipy.app import Notifications
from osgeo import ogr

chkbox_state_dict = {0: False, 2: True}


def create_hbox(*widgets) -> QHBoxLayout:
    """
    Создает горизонтальную разметку с входными виджетами.

    :param widgets: Список виджетов.
    :return: Горизонтальная разметка (QHBoxLayout).
    """
    hbox = QHBoxLayout()
    for widget in widgets:
        hbox.addWidget(widget)
    return hbox


def add_dot(str_: str):
    """
    Добавляет точку в конце строки, если ее нет.
    """
    if not str_:
        return ""

    if not str_.endswith("."):
        str_ += "."
    return str_


def notify(text: str, msg_type: int = 1) -> None:
    """
    Функция отправляет уведомления с одним и тем же заголовком.
    Warning по умолчанию.

    :param text:
    :param msg_type: 0 Info, 1 Warning
    """
    Notifications.push(
        title=tr("Модуль \"Конвертер\""),
        text=text,
        type_message=msg_type
    )


def geometry_type_to_name(g_type: int) -> str:
    """
    Получение имени геометрии слоя
    """
    geometry_name = ogr.GeometryTypeToName(g_type).upper().replace(" ", "")
    return geometry_name


def ensure_list(arg: Union[str, list]) -> list:
    """
    На входе строка или список.
    На выходе список со строкой или исходный список.
    """
    if isinstance(arg, str):
        return [arg]
    else:
        return arg


def get_key(d: dict, val) -> str:
    """
    Возвращает ключ по значению в словаре.
    """
    for k, v in d.items():
        if v == val:
            return k
