import os
from PySide2.QtWidgets import QDialog, QFileDialog, QDialogButtonBox
from PySide2.QtGui import QIcon 
from PySide2.QtUiTools import QUiLoader
from PySide2.QtCore import Qt, QFileInfo

from axipy import *


class SavePointsDialog(QDialog):

    def __init__(self, iface) -> None:
        super().__init__(iface.window())
        self.__tr = iface.tr
        uiFile = os.path.join(os.path.dirname(__file__), "SavePointsDialog.ui")
        self.__ui = QUiLoader().load(uiFile, self)
        self.fileName = None
        self.__load_ui()
        self.__ui.setParent(view_manager.global_parent)
        self.__ui.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)

    def __load_ui(self):
        for t in data_manager.tables:
            self.__ui.cbTables.addItem(t.name)

        self.__ui.buttonBox.button(QDialogButtonBox.Ok).setEnabled(self.__ui.cbTables.count())
        self.__ui.tbSelectFile.setIcon(QIcon('://icons/LightAx/32x32/open.png'))
        self.__ui.tbSelectFile.clicked.connect(self.__selectFile)

    def __selectFile(self):
        dlg = QFileDialog(self)
        dlg.setParent(view_manager.global_parent)
        dlg.setNameFilter(self.__tr("MapInfo TAB (*.tab);;Таблицы Excel (*.xlsx);;CSV файлы (*.csv);;"));
        dlg.setFileMode(QFileDialog.AnyFile)
        dlg.setAcceptMode(QFileDialog.AcceptSave)
        if dlg.exec() == QDialog.Accepted:
            if not len(dlg.selectedFiles()):
                return
            file_name = dlg.selectedFiles()[0]
            if len(QFileInfo(file_name).suffix()) == 0:
                file_name += ".tab"
            self.__ui.lineEdit.setText(file_name)

    def result_file_name(self):
        return self.__ui.lineEdit.text()

    def result_table(self):
        # Результирующая базовая таблица
        return data_manager.find(self.__ui.cbTables.currentText())

    def result_format_data_index(self):
        return self.__ui.cbFormatData.currentIndex()
    
    def result_type_coordinates_index(self):
        return self.__ui.cbTypeData.currentIndex()

    def exec(self):
        return self.__ui.exec()
