from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class WmtsSource(Source):
    pass


class WmtsDataProvider(DataProvider):
    """Провайдер для тайловых серверов.
    """
    _identifier = 'WmtsDataProvider'

    def get_source(self, capabilitiesUrl: str, dataObject: str) -> Source:
        """Создает источник данных

        Args:
          capabilitiesUrl: URL запроса метаданных.
          dataObject: Наименование слоя.
        """
        return WmtsSource(
            Source._provider(self.id),
            {
                'src': capabilitiesUrl,
                'dataobject' : dataObject
            }
        )
