# The PEP 484 type hints stub file for the _core_geometry module.
#
# Generated by SIP 4.19.3.dev1705052245


import typing
import sip

from axioma_dynload import _core_serializable
from axioma_dynload import _common
from axioma_dynload import _cs

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class GeometryInterface(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def transformed(self, cs: typing.Any) -> 'Geometry': ...
    @typing.overload
    def transformed(self, transform: 'Transform') -> 'Geometry': ...
    @typing.overload
    def transformed(self, transformation: QtGui.QTransform) -> 'Geometry': ...
    def rotated(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radians: float) -> 'Geometry': ...
    def translated(self, dX: float, dY: float) -> 'Geometry': ...
    def name(self) -> str: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def isHitByBoundingRect(self, rect: QtCore.QRectF) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def isCollection(self) -> bool: ...
    def clone(self) -> typing.Any: ...


class Geometry(GeometryInterface):

    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...


class WktWkb(sip.wrapper):

    def exportToWkbHex(self, srid: int = ...) -> QtCore.QByteArray: ...
    def exportToWkb(self, srid: int = ...) -> QtCore.QByteArray: ...
    def exportToEwkt(self, srid: int) -> str: ...
    def exportToWkt(self) -> str: ...
    def initCoordsFromWkb(self, wkb: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def initCoordsFromWkt(self, wkt: str) -> None: ...


class GeosSupport(WktWkb):

    def exportToWkbHex(self, srid: int = ...) -> QtCore.QByteArray: ...
    def exportToWkb(self, srid: int = ...) -> QtCore.QByteArray: ...
    def exportToEwkt(self, srid: int) -> str: ...
    def exportToWkt(self) -> str: ...
    def initCoordsFromWkb(self, wkb: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def initCoordsFromWkt(self, wkt: str) -> None: ...
    @staticmethod
    def convertFromWkb(wkb: typing.Union[QtCore.QByteArray, bytes, bytearray], cs: _cs.CoordSystem) -> Geometry: ...
    @staticmethod
    def convertFromWkt(wkt: str, cs: _cs.CoordSystem) -> Geometry: ...


class Point(Geometry, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem, x: float, y: float) -> None: ...
    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem, pos: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> None: ...

    def clone(self) -> PointImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def isHitByBoundingRect(self, rect: QtCore.QRectF) -> bool: ...
    def pos(self) -> QtCore.QPointF: ...
    def setPos(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def name(self) -> str: ...
    def boundingRect(self) -> QtCore.QRectF: ...


class PolygonMeasureCalculator(sip.wrapper):

    def isCartesian(self) -> bool: ...


class DistanceCalculator(PolygonMeasureCalculator):

    def __init__(self, cartesian: bool) -> None: ...


class CartesianDistanceCalculator(DistanceCalculator):

    def __init__(self) -> None: ...


class SphericalDistanceCalculator(DistanceCalculator):

    def __init__(self, cs: _cs.CoordSystem) -> None: ...


class PolygonAreaCalculator(PolygonMeasureCalculator):

    def __init__(self, cartesian: bool) -> None: ...


class CartesianAreaCalculator(PolygonAreaCalculator):

    def __init__(self) -> None: ...


class SphericalAreaCalculator(PolygonAreaCalculator):

    def __init__(self, cs: _cs.CoordSystem) -> None: ...


class Transform(sip.wrapper):

    def isSimpleTransform(self) -> bool: ...
    def sourceCoordSys(self) -> _cs.CoordSystem: ...
    def resultCoordSys(self) -> _cs.CoordSystem: ...
    @typing.overload
    def map(self, p_in: typing.Union[QtCore.QPointF, QtCore.QPoint], p_out: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def map(self, r_in: QtCore.QRectF, r_out: QtCore.QRectF) -> bool: ...
    @typing.overload
    def map(self, p_in: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]], p_out: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> typing.Tuple[bool, typing.List[QtCore.QPointF]]: ...


class TransformQt(Transform):

    def __init__(self, transform: QtGui.QTransform, coordSys: _cs.CoordSystem = ...) -> None: ...

    def isRevertOrdinate(self) -> bool: ...
    def isSimpleTransform(self) -> bool: ...
    def resultCoordSys(self) -> _cs.CoordSystem: ...
    @typing.overload
    def map(self, p_in: typing.Union[QtCore.QPointF, QtCore.QPoint], p_out: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def map(self, r_in: QtCore.QRectF, r_out: QtCore.QRectF) -> bool: ...
    @typing.overload
    def map(self, p_in: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]], p_out: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> typing.Tuple[bool, typing.List[QtCore.QPointF]]: ...


class TransformCoordSys(Transform):

    @typing.overload
    def __init__(self, cs_from: typing.Any, cs_to: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, coordTransform: _cs.CoordTransform) -> None: ...

    def isSimpleTransform(self) -> bool: ...
    def sourceCoordSys(self) -> typing.Any: ...
    def resultCoordSys(self) -> typing.Any: ...
    @typing.overload
    def map(self, p_in: typing.Union[QtCore.QPointF, QtCore.QPoint], p_out: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def map(self, r_in: QtCore.QRectF, r_out: QtCore.QRectF) -> bool: ...
    @typing.overload
    def map(self, p_in: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]], p_out: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> typing.Tuple[bool, typing.List[QtCore.QPointF]]: ...


class CombinedTransform(Transform):

    def __init__(self, transforms: list[Transform]) -> None: ...

    def isSimpleTransform(self) -> bool: ...
    def sourceCoordSys(self) -> _cs.CoordSystem: ...
    def resultCoordSys(self) -> _cs.CoordSystem: ...
    @typing.overload
    def map(self, p_in: typing.Union[QtCore.QPointF, QtCore.QPoint], p_out: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def map(self, r_in: QtCore.QRectF, r_out: QtCore.QRectF) -> bool: ...
    @typing.overload
    def map(self, p_in: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]], p_out: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> typing.Tuple[bool, typing.List[QtCore.QPointF]]: ...


class RoundTransform(Transform):

    @typing.overload
    def __init__(self, digitsX: int, digitsY: int, coordSys: _cs.CoordSystem = ...) -> None: ...
    @typing.overload
    def __init__(self, sizeScale: QtCore.QSizeF, coordSys: _cs.CoordSystem = ...) -> None: ...

    def isSimpleTransform(self) -> bool: ...
    def isCorrect(self) -> bool: ...
    def setDigits(self, digitsX: int, digitsY: int) -> 'RoundTransform': ...
    @typing.overload
    def setScale(self, sizeScale: QtCore.QSizeF) -> 'RoundTransform': ...
    @typing.overload
    def setScale(self, width: float, height: float) -> 'RoundTransform': ...
    def resultCoordSys(self) -> _cs.CoordSystem: ...
    @typing.overload
    def map(self, p_in: typing.Union[QtCore.QPointF, QtCore.QPoint], p_out: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    @typing.overload
    def map(self, r_in: QtCore.QRectF, r_out: QtCore.QRectF) -> bool: ...
    @typing.overload
    def map(self, p_in: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]], p_out: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> typing.Tuple[bool, typing.List[QtCore.QPointF]]: ...


class Surface(GeometryInterface):

    def perimeter(self, calc: DistanceCalculator) -> float: ...
    def area(self, calc: PolygonAreaCalculator) -> float: ...


class Polygon(Surface, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem, polygon: QtGui.QPolygonF = ...) -> None: ...
    @typing.overload
    def __init__(self, ring: 'LinearRing') -> None: ...
    @typing.overload
    def __init__(self, polygon: 'Polygon') -> None: ...

    def clone(self) -> PolygonImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def removeInteriorRing(self, index: int) -> None: ...
    def interiorsCount(self) -> int: ...
    def perimeter(self, calc: DistanceCalculator) -> float: ...
    def area(self, calc: PolygonAreaCalculator) -> float: ...
    def name(self) -> str: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def interiorAt(self, index: int) -> 'LinearRing': ...
    def exteriorRing(self) -> typing.Any: ...
    def setExteriorRing(self, exteriorRing: 'LinearRing') -> None: ...
    def addInterior(self, interiorRing: 'LinearRing') -> None: ...


class Curve(GeometryInterface):

    def length(self, calc: DistanceCalculator) -> float: ...


class LineStringInterface(Curve):

    def clearPoints(self) -> None: ...
    def removePoint(self, index: int) -> None: ...
    def insertPoint(self, before: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setPoint(self, index: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def points(self) -> QtGui.QPolygonF: ...
    def pointAt(self, index: int) -> QtCore.QPointF: ...
    def pointsCount(self) -> int: ...
    def appendPoints(self, points: QtGui.QPolygonF) -> None: ...
    def appendPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def endPoint(self) -> QtCore.QPointF: ...
    def beginPoint(self) -> QtCore.QPointF: ...


class LinearRing(LineStringInterface, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem, polygon: QtGui.QPolygonF = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'LinearRing') -> None: ...

    def clone(self) -> LinearRingImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def closeRing(self) -> None: ...
    def clearPoints(self) -> None: ...
    def removePoint(self, index: int) -> None: ...
    def insertPoint(self, before: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setPoint(self, index: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def points(self) -> QtGui.QPolygonF: ...
    def endPoint(self) -> QtCore.QPointF: ...
    def beginPoint(self) -> QtCore.QPointF: ...
    def pointAt(self, index: int) -> QtCore.QPointF: ...
    def pointsCount(self) -> int: ...
    def name(self) -> str: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def appendPoints(self, points: QtGui.QPolygonF) -> None: ...
    def appendPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def length(self, calc: DistanceCalculator) -> float: ...


class LineString(LineStringInterface, GeosSupport):

    def __init__(self, coordSystem: _cs.CoordSystem, polygon: QtGui.QPolygonF = ...) -> None: ...

    def clone(self) -> LineStringImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def clearPoints(self) -> None: ...
    def removePoint(self, index: int) -> None: ...
    def insertPoint(self, before: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setPoint(self, index: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def points(self) -> QtGui.QPolygonF: ...
    def endPoint(self) -> QtCore.QPointF: ...
    def beginPoint(self) -> QtCore.QPointF: ...
    def pointAt(self, index: int) -> QtCore.QPointF: ...
    def pointsCount(self) -> int: ...
    def name(self) -> str: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def appendPoints(self, points: QtGui.QPolygonF) -> None: ...
    def appendPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def length(self, calc: DistanceCalculator) -> float: ...


class Line(Curve, GeosSupport):

    def __init__(self, coordSystem: _cs.CoordSystem, line: QtCore.QLineF) -> None: ...

    def clone(self) -> LineImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def endPoint(self) -> QtCore.QPointF: ...
    def beginPoint(self) -> QtCore.QPointF: ...
    def setEndPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setBeginPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def name(self) -> str: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def length(self, calc: DistanceCalculator) -> float: ...


class GeometryCollection(GeometryInterface):

    def geometryAt(self, index: int) -> Geometry: ...
    def collectionSize(self) -> int: ...
    def isCollection(self) -> bool: ...


class MultiPoint(GeometryCollection, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem, points: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, multiPoint: 'MultiPoint') -> None: ...

    def clone(self) -> MultiPointImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def name(self) -> str: ...
    def collectionSize(self) -> int: ...
    def removePointAt(self, index: int) -> None: ...
    def addPoint(self, point: Point) -> None: ...


class MultiPolygon(GeometryCollection, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, multiPolygon: 'MultiPolygon') -> None: ...

    def addPolygon(self, point: Polygon) -> None: ...
    def clone(self) -> MultiPolygonImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def name(self) -> str: ...
    def collectionSize(self) -> int: ...
    def removePolygonAt(self, index: int) -> None: ...


class MultiLineString(GeometryCollection, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, multiLineString: 'MultiLineString') -> None: ...

    def clone(self) -> MultiLineStringImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def name(self) -> str: ...
    def collectionSize(self) -> int: ...
    def removeLineStringAt(self, index: int) -> None: ...
    def addLineString(self, lineString: LineStringInterface) -> None: ...


class MultiGeometry(GeometryCollection, GeosSupport):

    @typing.overload
    def __init__(self, coordSystem: _cs.CoordSystem = ...) -> None: ...
    @typing.overload
    def __init__(self, multiGeometry: 'MultiGeometry') -> None: ...

    def clone(self) -> MultiGeometryImpl: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCoordSystem(self, value: _cs.CoordSystem) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def name(self) -> str: ...
    def collectionSize(self) -> int: ...
    def removeGeometryAt(self, index: int) -> None: ...
    def addGeometry(self, geometry: GeometryInterface) -> None: ...


class GeometryTransform(sip.wrapper):

    def transformed(self, geom: Geometry) -> Geometry: ...
    @staticmethod
    def makeGeometryTransform(transforms: list[Transform]) -> 'GeometryTransform': ...


class CommonGeometryTransform(GeometryTransform):

    def __init__(self, transforms: list[Transform]) -> None: ...


class CropGeometryTransform(GeometryTransform):

    def __init__(self, transforms: list[Transform]) -> None: ...


def Combine(geometryList: list[Geometry]) -> Geometry: ...
def getNumPoints(geom: Geometry) -> int: ...
def snapGeometry(geom: Geometry, tolerance: float) -> Geometry: ...
def clearGeometryWithTolerance(geom: Geometry, tolerance: float) -> Geometry: ...
def intersectionFindAdd(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def isValid(geom: Geometry) -> bool: ...
def normalizedGeometry(geom: Geometry) -> Geometry: ...
def Distance(geom1: Geometry, geom2: Geometry) -> float: ...
def Length(geom: Geometry) -> float: ...
def Area(geom: Geometry) -> float: ...
def Buffer(geom: Geometry, width: float, quadsegs: int, endCapStyle: int = ..., joinStyle: int = ..., mitreLimit: float = ...) -> Geometry: ...
def Project(geom1: typing.Any, geom2: Geometry) -> float: ...
def PolylineSplit(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def Centroid(geom: Geometry) -> Point: ...
def UnaryUnion(geom: Geometry) -> Geometry: ...
def Union(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def Boundary(geom: Geometry) -> Geometry: ...
def SymDifference(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def Difference(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def ConvexHull(geom: Geometry) -> Geometry: ...
def Intersection(geom1: Geometry, geom2: Geometry) -> Geometry: ...
def Envelope(geom: Geometry) -> Geometry: ...
def CoveredBy(geom1: Geometry, geom2: Geometry) -> bool: ...
def Covers(geom1: Geometry, geom2: Geometry) -> bool: ...
def EqualsExact(geom1: Geometry, geom2: Geometry, tolerance: float) -> bool: ...
def Equals(geom1: Geometry, geom2: Geometry) -> bool: ...
def Overlaps(geom1: Geometry, geom2: Geometry) -> bool: ...
def ContainsCentroid(geom1: Geometry, geom2: Geometry) -> bool: ...
def Contains(geom1: Geometry, geom2: Geometry) -> bool: ...
def Within(geom1: Geometry, geom2: Geometry) -> bool: ...
def Crosses(geom1: Geometry, geom2: Geometry) -> bool: ...
@typing.overload
def Intersects(geom1: Geometry, geom2: Geometry) -> bool: ...
@typing.overload
def Intersects(geom1: Geometry, rect: QtCore.QRectF) -> bool: ...
def Touches(geom1: Geometry, geom2: Geometry) -> bool: ...
def Disjoint(geom1: Geometry, geom2: Geometry) -> bool: ...
def geometryFromJson(json: str, cs: _cs.CoordSystem = ...) -> Geometry: ...
def convertGeometryToJson(geom: GeometryInterface) -> str: ...
def fitGeometryByShift(geom: Geometry) -> Geometry: ...
def fitGeometry(geom: Geometry) -> Geometry: ...
def normalizedGeometryForCoordSystem(geom: Geometry, csPtr: _cs.CoordSystem) -> Geometry: ...
def makePolygonByRect(rect: QtCore.QRectF, cs: _cs.CoordSystem) -> Geometry: ...
def groupGeometries(geometries: list[Geometry]) -> GeometryCollection: ...
def uniteGeometries(collection: GeometryCollection) -> Geometry: ...
def convertFromLineStringsToPolygons(geom: Geometry) -> Geometry: ...
def convertCollectionToVector(geometry: GeometryInterface) -> list[Geometry]: ...
def convertToMultiLineString(geom: GeometryInterface) -> Geometry: ...
def linearRingToLineString(linearRing: LinearRing) -> LineString: ...
def reversePolygon(poly: QtGui.QPolygonF) -> QtGui.QPolygonF: ...
def flatPlots(angle: float, polyLine: QtGui.QPolygonF, len: float) -> list[QPolygonF]: ...
def flatPoint(angle: float, polyLine: QtGui.QPolygonF, len: float) -> int: ...
@typing.overload
def nearestPointOn(point: typing.Union[QtCore.QPointF, QtCore.QPoint], line: QtCore.QLineF) -> QtCore.QPointF: ...
@typing.overload
def nearestPointOn(point: typing.Union[QtCore.QPointF, QtCore.QPoint], poly: QtGui.QPolygonF) -> QtCore.QPointF: ...
def centroid(geom: Geometry) -> QtCore.QPointF: ...
def cartesianCurveLength(curve: Curve, unitName: str) -> float: ...
def sphericalCurveLength(curve: Curve, unitName: str) -> float: ...
def curveLength(curve: Curve, unitName: str) -> float: ...
def cartesianLength(geom: Geometry, unitName: str) -> float: ...
def sphericalLength(geom: Geometry, unitName: str) -> float: ...
def length(geom: Geometry, unitName: str) -> float: ...
def cartesianSurfacePerimeter(surface: Surface, unitName: str) -> float: ...
def sphericalSurfacePerimeter(surface: Surface, unitName: str) -> float: ...
def surfacePerimeter(surface: Surface, unitName: str) -> float: ...
def cartesianPolygonPerimeter(polygon: QtGui.QPolygonF) -> float: ...
def sphericalPolygonPerimeter(polygon: QtGui.QPolygonF) -> float: ...
def cartesianPerimeter(geom: Geometry, unitName: str) -> float: ...
def sphericalPerimeter(geom: Geometry, unitName: str) -> float: ...
def perimeter(geom: Geometry, unitName: str) -> float: ...
def cartesianSurfaceArea(surface: Surface, unitName: str) -> float: ...
def sphericalSurfaceArea(surface: Surface, unitName: str) -> float: ...
def surfaceArea(surface: Surface, unitName: str) -> float: ...
def cartesianArea(geom: Geometry, unitName: str) -> float: ...
def sphericalArea(geom: Geometry, unitName: str) -> float: ...
def area(geom: Geometry, unitName: str) -> float: ...
def sphericalPolygonArea(poly: QtGui.QPolygonF) -> float: ...
def cartesianPolygonArea(poly: QtGui.QPolygonF) -> float: ...
def pointOffset(point: typing.Union[QtCore.QPointF, QtCore.QPoint], angle: float, distance: float) -> QtCore.QPointF: ...
def directGeodesicProblem(point: typing.Union[QtCore.QPointF, QtCore.QPoint], azimuth: float, distance: float, semiMajor: float, flattening: float) -> QtCore.QPointF: ...
def sphericalDistance(a: typing.Union[QtCore.QPointF, QtCore.QPoint], b: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> float: ...
def cartesianDistance(a: typing.Union[QtCore.QPointF, QtCore.QPoint], b: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> float: ...
def isPointLike(g: GeometryInterface) -> bool: ...
def isCollection(g: GeometryInterface) -> bool: ...
def rectToWkt(rect: QtCore.QRectF) -> str: ...
def is_geometry(v: typing.Any) -> bool: ...
def geometry_cast(v: typing.Any) -> typing.Any: ...
