import os
from PySide2.QtWidgets import QDialog, QFileDialog, QDialogButtonBox
from PySide2.QtGui import QIcon 
from PySide2.QtUiTools import QUiLoader
from PySide2.QtCore import Qt, QFileInfo

from axipy import *


class SavePointsDialog(QDialog):

    def __init__(self, iface) -> None:
        super().__init__(iface.window())
        self.__tr = iface.tr
        uiFile = os.path.join(os.path.dirname(__file__), "SavePointsDialog.ui")
        self.__ui = QUiLoader().load(uiFile, self)
        self.fileName = None
        self.__load_ui()
        self.__ui.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)

    def __load_ui(self):
        for t in data_manager.tables:
            self.__ui.cbTables.addItem(t.name)

        self.__ui.buttonBox.button(QDialogButtonBox.Ok).setEnabled(self.__ui.cbTables.count())
        self.__ui.tbSelectFile.setIcon(QIcon('://icons/LightAx/32x32/open.png'))
        self.__ui.tbSelectFile.clicked.connect(self.__selectFile)

    def __selectFile(self):
        fn = QFileDialog.getSaveFileName(self, self.__tr('Имя выходного файла'), filter = "MapInfo TAB (*.tab);;")
        if fn is None or len(fn[0]) == 0:
            return
        file_name = fn[0]
        if len(QFileInfo(fn[0]).suffix()) == 0:
            file_name += ".tab"
        self.__ui.lineEdit.setText(file_name)

    def result_file_name(self):
        return self.__ui.lineEdit.text()

    def result_table(self):
        # Результирующая базовая таблица
        return data_manager.find(self.__ui.cbTables.currentText())
    
    def is_simple_coordinates(self):
        return self.__ui.cbTypeData.currentIndex() == 0

    def exec(self):
        return self.__ui.exec()
