from .data_provider import DataProvider, Table
from .source import Source, Destination, Schema
from typing import List, Optional


class WmsSource(Source):
    pass


class WmsDataProvider(DataProvider):
    """Провайдер для Web Map Service.
    """
    _identifier = 'WmsDataProvider'

    def get_source(self, url_capabilities: str, layers: List[str], image_format: str = 'image/png', prj: str = None, style: str = None) -> Source:
        """ Создает источник данных

        Args:
          url_capabilities: URL с метаданными capabilities.
          layers: Перечень слоев в виде списка.
          prj: Строка Системы Координат
          image_format: Формат выходного растра.
          style: Наименование стиля оформления.

        Пример::

            wms_raster = provider_manager.wms.open('http://www.mapinfo.com/miwms', ['World'], prj='EPSG:4326', style='AreaStyleGreen')
        """
        return WmsSource(
            Source._provider(self.id),
            {
                'src': url_capabilities,
                'layers' : layers,
                'prj': prj,
                'imageFormat': image_format,
                'style' : style
            }
        )
