"""Модуль пользовательского интерфейса.

В данном модуле содержатся классы связанные с пользовательским интерфейсом.

Attributes:
    view_manager (ViewManager): Экземпляр менеджера содержимого окон.
    selection_manager (SelectionManager): Экземпляр доступа к выделенным объектам.
"""


from axipy.cpp_gui import *
from .view_manager_wrapper import ViewManager
from .SelectionManagerWrapper import SelectionManager
from .ViewWrapper import View, TableView, MapView, ReportView, DrawableView, LegendView, ListLegend
from .ToolWrapper import MapTool, DeactivationReason, ViewPointsHelper
from .DialogWrapper import ChooseCoordSystemDialog, StyledButton
from .Workspace import Workspace
from .gui_class import gui_instance
from .ActiveToolPanel import ActiveToolPanel, AxipyActiveToolPanelHandlerBase, AxipyAcceptableActiveToolHandler, AxipyCustomActiveToolPanelHandler

view_manager = ViewManager()
selection_manager = SelectionManager()
active_tool_panel = ActiveToolPanel()


# fix sphinx inheritance and typehints
from axipy._util import fixup_module_metadata
fixup_module_metadata(__name__, globals())
del fixup_module_metadata
