from .data_provider import DataProvider
from typing import List
from .source import Source, Destination, Schema
from ..attribute_schema import Schema


class TabSource(Source):
    pass


class TabDestination(Destination):
    pass


class TabDataProvider(DataProvider):
    """Провайдер MapInfo."""
    _identifier = 'TabDataProvider'

    def get_source(self, filepath: str) -> Source:
        """Создает источник данных.

        Args:
            filepath: Путь к файлу.
        """
        return TabSource(
            Source._provider(self.id),
            Source._table_file(filepath),
        )

    def get_destination(self, filepath: str, schema: Schema) -> Destination:
        """Создает назначение объекта данных.

        Args:
            filepath: Путь к файлу.
            schema: Схема таблицы.
        """
        return TabDestination(schema,
                              Source._provider(self.id),
                              Source._table_file(filepath),
                              )
