import os
import site
import sys
import traceback
from pathlib import Path
from typing import Optional, List, Union

from ._get_app_data import _get_axioma_python_dependencies_location, _get_plugins_python_dependencies_location


def _is_running_from_venv() -> bool:
    prefix = sys.prefix
    return prefix != sys.base_prefix and os.environ.get("VIRTUAL_ENV", None) == prefix


def _get_venv_site_packages() -> Optional[str]:
    list_str = site.getsitepackages((sys.prefix,))
    if len(list_str) > 0:
        return list_str[0]
    else:
        return None


# noinspection PyBroadException
def _get_sys_path_formatted() -> List[Path]:
    sys_path_formatted: List[Path] = []
    for elem in sys.path:
        try:
            sys_path_formatted.append(Path(elem))
        except Exception:
            sys_path_formatted.append(Path())
    return sys_path_formatted


# noinspection PyBroadException
def _ensure_first_sys_path(path: Union[Path, str]) -> None:
    path = Path(path)
    sys_path_formatted = _get_sys_path_formatted()
    try:
        i = sys_path_formatted.index(path)
    except Exception:
        i = -1

    if i != 0:
        sys.path.insert(0, str(path))


# noinspection PyBroadException
def _ensure_deps_site_packages():
    deps_folder = _get_axioma_python_dependencies_location()
    _ensure_first_sys_path(deps_folder)
    try:
        site.addsitedir(str(deps_folder))
        site.addsitedir(str(_get_plugins_python_dependencies_location()))
    except Exception:
        traceback.print_exc()


# noinspection PyBroadException
def _ensure_venv_site_packages() -> None:
    if _is_running_from_venv():
        venv_site_packages = _get_venv_site_packages()
        _ensure_first_sys_path(venv_site_packages)
        try:
            site.addsitedir(str(venv_site_packages))
        except Exception:
            traceback.print_exc()
