import typing
from typing import ForwardRef
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtPrintSupport
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_common
import axipy.cpp_core_core
import axipy.cpp_core_dp
import axipy.cpp_core_geometry
import axipy.cpp_cs
import typing
QJsonValue = typing.Any

__all__ = ['FeatureLayerProperties', 'LabelPlacementPolicy', 'LayerProperties', 'Render', 'ShadowClicheReportItem', 'ShadowContext', 'ShadowCosmeticLayer', 'ShadowCosmeticTable', 'ShadowCustomLabels', 'ShadowGeometryReportItem', 'ShadowLabelLayout', 'ShadowLayer', 'ShadowLayers', 'ShadowLegend', 'ShadowLegendReportItem', 'ShadowLegendStyleItem', 'ShadowLegendStyleItemList', 'ShadowMap', 'ShadowMapReportItem', 'ShadowRasterLayer', 'ShadowRasterReportItem', 'ShadowRectangleItem', 'ShadowReport', 'ShadowReportItem', 'ShadowReportItemsBase', 'ShadowScaleBarReportItem', 'ShadowTableReportItem', 'ShadowThematic', 'ShadowThematicBar', 'ShadowThematicDensity', 'ShadowThematicIndividual', 'ShadowThematicList', 'ShadowThematicPie', 'ShadowThematicRange', 'ShadowThematicSymbol', 'ShadowVectorLayer', 'defaultFilePath', 'defaultInterfaceTheme', 'defaultPathLocation', 'defaultTypeInterface', 'detectDefaultPythonFont', 'isWaylandPlatform', 'isX11Platform', 'lengthUnitPrefix', 'loadCodecFromJson', 'loadPointFromJson', 'loadQRectFFromJson', 'loadQSizeFromJson', 'loadQTransformFromJson', 'pixelString', 'prefixCacheDir', 'saveCodecToJson', 'saveLineToJson', 'saveLineToJsonEmbedded', 'savePointToJson', 'savePolylineToJson', 'savePolylineToJsonEmbedded', 'saveQRectFToJson', 'saveQSizeToJson', 'saveQTransfomToJson', 'titanInterfaceStyle', 'underWayland']
class FeatureLayerProperties(LayerProperties):
    @staticmethod
    def __copy__() -> None:
        ...
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def iid_private() -> str:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def centroidsVisibility(self) -> bool:
        ...
    def class_id(self) -> str:
        ...
    def labelOpacity(self) -> float:
        ...
    def labelPlacementPolicy(self) -> LabelPlacementPolicy:
        ...
    def labelingAttributeIsExpression(self) -> bool:
        ...
    def labelingAttributeName(self) -> str:
        ...
    def linesDirectionVisibility(self) -> bool:
        ...
    def nodesVisibility(self) -> bool:
        ...
    def setCentroidsVisible(self, visible: bool = True) -> None:
        ...
    def setLabelOpacity(self, opacity: float) -> None:
        ...
    def setLabelPlacementPolicy(self, labelVisibilityConstraints: LabelPlacementPolicy) -> None:
        ...
    def setLabelingAttributeIsExpression(self, isExpression: bool) -> None:
        ...
    def setLabelingAttributeName(self, attributeName: str) -> None:
        ...
    def setLinesDirectionVisible(self, visible: bool = True) -> None:
        ...
    def setNodesVisible(self, visible: bool = True) -> None:
        ...
    def setShowLabels(self, value: bool) -> None:
        ...
    def setShowUniformly(self, value: bool) -> None:
        ...
    def showLabels(self) -> bool:
        ...
    def showUniformly(self) -> bool:
        ...
    def unmanaged_clone(self) -> FeatureLayerProperties:
        ...
class LabelPlacementPolicy(shiboken2.Shiboken.Object):
    class ClipPolicy(shiboken2.Shiboken.Enum):
        ClipCount: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipCount
        ClipDefault: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipDefault
        ClipLast: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipLast
        ClipSkip: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipSkip
        ClipUse: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipUse
        values: typing.ClassVar[dict]  # value = {'ClipUse': axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipUse, 'ClipSkip': axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipSkip, 'ClipCount': axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipCount, 'ClipDefault': axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipDefault, 'ClipLast': axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipLast}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    class ClipSection(shiboken2.Shiboken.Enum):
        ClipSectionArea: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionArea
        ClipSectionCollection: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCollection
        ClipSectionCount: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCount
        ClipSectionCurve: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCurve
        ClipSectionDefault: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionDefault
        ClipSectionLast: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionLast
        values: typing.ClassVar[dict]  # value = {'ClipSectionArea': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionArea, 'ClipSectionCurve': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCurve, 'ClipSectionCollection': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCollection, 'ClipSectionCount': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCount, 'ClipSectionLast': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionLast, 'ClipSectionDefault': axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionDefault}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    class Duplicates(shiboken2.Shiboken.Enum):
        DuplicatesAllow: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesAllow
        DuplicatesCount: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesCount
        DuplicatesDefault: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDefault
        DuplicatesDisable: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDisable
        DuplicatesInterLayer: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesInterLayer
        DuplicatesIntraLayer: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesIntraLayer
        DuplicatesLast: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesLast
        values: typing.ClassVar[dict]  # value = {'DuplicatesAllow': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesAllow, 'DuplicatesInterLayer': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesInterLayer, 'DuplicatesIntraLayer': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesIntraLayer, 'DuplicatesDisable': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDisable, 'DuplicatesCount': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesCount, 'DuplicatesLast': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesLast, 'DuplicatesDefault': axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDefault}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    class LabelingAlgorithmType(shiboken2.Shiboken.Enum):
        AllowOverlap: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.AllowOverlap
        DisallowOverlap: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.DisallowOverlap
        LabelingAlgorithmCount: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmCount
        LabelingAlgorithmDefault: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmDefault
        LabelingAlgorithmLast: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmLast
        TryOtherPosition: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.TryOtherPosition
        values: typing.ClassVar[dict]  # value = {'AllowOverlap': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.AllowOverlap, 'DisallowOverlap': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.DisallowOverlap, 'TryOtherPosition': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.TryOtherPosition, 'LabelingAlgorithmCount': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmCount, 'LabelingAlgorithmLast': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmLast, 'LabelingAlgorithmDefault': axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmDefault}
        @staticmethod
        def __new__(type, *args, **kwargs):
            """
            Create and return a new object.  See help(type) for accurate signature.
            """
        @staticmethod
        def __reduce__(*args, **kwargs):
            ...
        def __add__(self, value):
            """
            Return self+value.
            """
        def __and__(self, value):
            """
            Return self&value.
            """
        def __bool__(self):
            """
            self != 0
            """
        def __eq__(self, value):
            """
            Return self==value.
            """
        def __ge__(self, value):
            """
            Return self>=value.
            """
        def __gt__(self, value):
            """
            Return self>value.
            """
        def __hash__(self):
            """
            Return hash(self).
            """
        def __index__(self):
            """
            Return self converted to an integer, if self is suitable for use as an index into a list.
            """
        def __int__(self):
            """
            int(self)
            """
        def __le__(self, value):
            """
            Return self<=value.
            """
        def __lt__(self, value):
            """
            Return self<value.
            """
        def __mul__(self, value):
            """
            Return self*value.
            """
        def __ne__(self, value):
            """
            Return self!=value.
            """
        def __or__(self, value):
            """
            Return self|value.
            """
        def __pos__(self):
            """
            +self
            """
        def __radd__(self, value):
            """
            Return value+self.
            """
        def __rand__(self, value):
            """
            Return value&self.
            """
        def __repr__(self):
            """
            Return repr(self).
            """
        def __rmul__(self, value):
            """
            Return value*self.
            """
        def __ror__(self, value):
            """
            Return value|self.
            """
        def __rsub__(self, value):
            """
            Return value-self.
            """
        def __rxor__(self, value):
            """
            Return value^self.
            """
        def __str__(self):
            """
            Return str(self).
            """
        def __sub__(self, value):
            """
            Return self-value.
            """
        def __xor__(self, value):
            """
            Return self^value.
            """
    AllowOverlap: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.AllowOverlap
    ClipCount: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipCount
    ClipDefault: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipDefault
    ClipLast: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipLast
    ClipSectionArea: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionArea
    ClipSectionCollection: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCollection
    ClipSectionCount: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCount
    ClipSectionCurve: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionCurve
    ClipSectionDefault: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionDefault
    ClipSectionLast: typing.ClassVar[LabelPlacementPolicy.ClipSection]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipSection.ClipSectionLast
    ClipSkip: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipSkip
    ClipUse: typing.ClassVar[LabelPlacementPolicy.ClipPolicy]  # value = axipy.cpp_render.LabelPlacementPolicy.ClipPolicy.ClipUse
    DisallowOverlap: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.DisallowOverlap
    DuplicatesAllow: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesAllow
    DuplicatesCount: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesCount
    DuplicatesDefault: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDefault
    DuplicatesDisable: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesDisable
    DuplicatesInterLayer: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesInterLayer
    DuplicatesIntraLayer: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesIntraLayer
    DuplicatesLast: typing.ClassVar[LabelPlacementPolicy.Duplicates]  # value = axipy.cpp_render.LabelPlacementPolicy.Duplicates.DuplicatesLast
    LabelingAlgorithmCount: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmCount
    LabelingAlgorithmDefault: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmDefault
    LabelingAlgorithmLast: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.LabelingAlgorithmLast
    TryOtherPosition: typing.ClassVar[LabelPlacementPolicy.LabelingAlgorithmType]  # value = axipy.cpp_render.LabelPlacementPolicy.LabelingAlgorithmType.TryOtherPosition
    @staticmethod
    def __copy__() -> None:
        ...
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def convertToLabelingType(allowOverlap: bool, adjustPosition: bool) -> LabelPlacementPolicy.LabelingAlgorithmType:
        ...
    @staticmethod
    def setClipPolicy(*args, **kwargs):
        ...
    def clipPolicy(self, clipSection: LabelPlacementPolicy.ClipSection) -> LabelPlacementPolicy.ClipPolicy:
        ...
    def fillVisible(self, value: bool = True) -> None:
        ...
    def getDuplicates(self) -> LabelPlacementPolicy.Duplicates:
        ...
    def isAnyClipSkip(self) -> bool:
        ...
    def isAnyClipUsed(self) -> bool:
        ...
    def isEqual(self, o: LabelPlacementPolicy) -> bool:
        ...
    def isEveryClipSkip(self) -> bool:
        ...
    def isEveryClipUsed(self) -> bool:
        ...
    def isVisible(self, zoom: float) -> bool:
        ...
    def labelEverySection(self) -> bool:
        ...
    def overhang(self) -> int:
        ...
    def overlap(self) -> LabelPlacementPolicy.LabelingAlgorithmType:
        ...
    def setDuplicates(self, value: LabelPlacementPolicy.Duplicates) -> None:
        ...
    def setLabelEverySection(self, labelEverySection: bool = True) -> None:
        ...
    def setOverhang(self, overhangPercent: int) -> None:
        ...
    def setOverlap(self, type: LabelPlacementPolicy.LabelingAlgorithmType) -> None:
        ...
class LayerProperties(axipy.cpp_common.Serializable):
    @staticmethod
    def __copy__() -> None:
        ...
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def iid_private() -> str:
        ...
    @staticmethod
    def kMaxOpacityReal() -> float:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def class_id(self) -> str:
        ...
    def extendedAttributes(self) -> typing.Dict[str, QJsonValue]:
        ...
    def hasTransparency(self) -> bool:
        ...
    def opacity(self) -> int:
        ...
    def setExtendedAttributes(self, arg__1: typing.Dict[str, QJsonValue]) -> None:
        ...
    def setOpacity(self, value: int) -> None:
        ...
    def unmanaged_clone(self) -> LayerProperties:
        ...
class Render(axipy.cpp_core_core.Core):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def initialize(self) -> None:
        ...
class ShadowClicheReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def init_impl(self) -> None:
        ...
class ShadowContext(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_clip_geometry(mapview: ShadowContext) -> axipy.cpp_core_geometry.ShadowGeometry:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_clip_geometry_buffer(self) -> int:
        ...
    def get_clip_geometry_status(self) -> bool:
        ...
    def get_cs(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def get_dpi(self) -> float:
        ...
    def get_pseudo_zoom(self) -> bool:
        ...
    def get_rect(self) -> PySide2.QtCore.QRectF:
        ...
    def set_clip_geometry(self, geometry: typing.Union[axipy.cpp_core_geometry.ShadowGeometry, None] = None) -> None:
        ...
    def set_clip_geometry_buffer(self, v: int) -> None:
        ...
    def set_clip_geometry_status(self, v: bool) -> None:
        ...
    def set_cs(self, cs: axipy.cpp_cs.ShadowCoordSystem) -> None:
        ...
    def set_dpi(self, v: float) -> None:
        ...
    def set_pseudo_zoom(self, v: bool) -> None:
        ...
    def set_rect(self, r: PySide2.QtCore.QRectF) -> None:
        ...
class ShadowCosmeticLayer(ShadowVectorLayer):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowCosmeticTable(axipy.cpp_core_dp.ShadowTable):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowCustomLabels(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    destroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    objectNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def getParams(self, shadowLayer: ShadowLayer, id: int) -> typing.Dict[str, QJsonValue]:
        ...
    def ids(self, shadowLayer: ShadowLayer) -> typing.List[typing.Any]:
        ...
    def setDefaultArrowStyle(self, shadowLayer: ShadowVectorLayer, shadowStyle: axipy.cpp_core_geometry.ShadowLineStyle) -> None:
        ...
    def setDefaultEndType(self, shadowLayer: ShadowVectorLayer, endType: int) -> None:
        ...
    def setParams(self, shadowLayer: ShadowLayer, id: int, v: typing.Dict[str, QJsonValue]) -> None:
        ...
class ShadowGeometryReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_geometry(self) -> axipy.cpp_core_geometry.ShadowGeometry:
        ...
    def get_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def init_impl(self) -> None:
        ...
    def set_geometry(self, g: axipy.cpp_core_geometry.ShadowGeometry) -> None:
        ...
    def set_style(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowLabelLayout(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def get_offset(self) -> PySide2.QtCore.QSize:
        ...
    def get_pos(self) -> int:
        ...
    def get_visible(self) -> bool:
        ...
    def set_offset(self, v: PySide2.QtCore.QSize) -> None:
        ...
    def set_pos(self, p: int) -> None:
        ...
    def set_visible(self, v: bool) -> None:
        ...
class ShadowLayer(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    internalDeleted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def isEquals(lay: ShadowLayer, other: ShadowLayer) -> bool:
        ...
    needRedraw: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def bounds(self) -> PySide2.QtCore.QRectF:
        ...
    def cs(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def data_object(self) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def draw(self, context: ShadowContext) -> None:
        ...
    def extendedProperties(self) -> typing.Dict[str, QJsonValue]:
        ...
    def get_name(self) -> str:
        ...
    def get_opacity(self) -> int:
        ...
    def isValid(self) -> bool:
        ...
    def is_hidden(self) -> bool:
        ...
    def is_selectable(self) -> bool:
        ...
    def is_visible(self) -> bool:
        ...
    def setExtendedProperties(self, v: typing.Dict[str, QJsonValue]) -> None:
        ...
    def setZoomMax(self, v: float) -> None:
        ...
    def setZoomMin(self, v: float) -> None:
        ...
    def setZoomRestrict(self, v: bool) -> None:
        ...
    def set_hidden(self, v: bool) -> None:
        ...
    def set_name(self, n: str) -> None:
        ...
    def set_opacity(self, v: int) -> None:
        ...
    def set_selectable(self, v: bool) -> None:
        ...
    def set_visible(self, v: bool) -> None:
        ...
    def slCloseAndDestroySelf(self) -> None:
        ...
    def zoomMax(self) -> float:
        ...
    def zoomMin(self) -> float:
        ...
    def zoomRestrict(self) -> bool:
        ...
class ShadowLayers(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def at(layers: ShadowLayers, idx: int) -> PySide2.QtCore.QObject:
        ...
    @staticmethod
    def by_name(layers: ShadowLayers, name: str) -> PySide2.QtCore.QObject:
        ...
    destroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    objectNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def add(self, shadowLayer: ShadowLayer) -> None:
        ...
    def add_group(self, name: str) -> None:
        ...
    def count(self) -> int:
        ...
    def get_name(self) -> str:
        ...
    def group(self, indexes: typing.List[int], name: str) -> None:
        ...
    def insert(self, shadowLayer: ShadowLayer) -> None:
        ...
    def is_visible(self) -> bool:
        ...
    def move(self, from_: int, to: int) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set_name(self, n: str) -> None:
        ...
    def set_visible(self, v: bool) -> None:
        ...
    def ungroup(self, idx: int) -> None:
        ...
class ShadowLegend(ShadowRectangleItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_styleCaption(legend: ShadowLegend) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    @staticmethod
    def get_styleSubCaption(legend: ShadowLegend) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    @staticmethod
    def get_styleText(legend: ShadowLegend) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def draw(self, context: ShadowContext) -> None:
        ...
    def get_caption(self) -> str:
        ...
    def get_items(self) -> ShadowLegendStyleItemList:
        ...
    def get_position(self) -> PySide2.QtCore.QPointF:
        ...
    def get_subCaption(self) -> str:
        ...
    def numberColumns(self) -> int:
        ...
    def refreshStyleItems(self) -> None:
        ...
    def setNumberColumns(self, value: int) -> None:
        ...
    def set_caption(self, v: str) -> None:
        ...
    def set_position(self, pos: PySide2.QtCore.QPointF) -> None:
        ...
    def set_styleCaption(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_styleSubCaption(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_styleText(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_subCaption(self, v: str) -> None:
        ...
class ShadowLegendReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def legend(ri: ShadowLegendReportItem) -> ShadowLegend:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def init_impl(self) -> None:
        ...
class ShadowLegendStyleItem(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def description(self) -> str:
        ...
    def get_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def isVisible(self) -> bool:
        ...
    def setDescription(self, d: str) -> None:
        ...
    def setVisible(self, v: bool) -> None:
        ...
class ShadowLegendStyleItemList(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_item(list: ShadowLegendStyleItemList, idx: int) -> ShadowLegendStyleItem:
        ...
    def count(self) -> int:
        ...
    def move(self, from_: int, to: int) -> None:
        ...
    def set_item(self, idx: int, item: ShadowLegendStyleItem) -> None:
        ...
class ShadowMap(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def cosmetic(map: ShadowMap) -> ShadowLayer:
        ...
    @staticmethod
    def custom_labels(map: ShadowMap) -> ShadowCustomLabels:
        ...
    @staticmethod
    def get_editableLayer(map: ShadowMap) -> ShadowLayer:
        ...
    @staticmethod
    def list_layers(map: ShadowMap) -> ShadowLayers:
        ...
    needRedraw: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def bestCS(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def bestRect(self, cs: axipy.cpp_cs.ShadowCoordSystem) -> PySide2.QtCore.QRectF:
        ...
    def cloneForPython(self) -> ShadowMap:
        ...
    def draw(self, context: ShadowContext) -> None:
        ...
    def draw_vector(self, context: ShadowContext) -> None:
        ...
    def get_area_unit(self) -> axipy.cpp_cs.ShadowAreaUnit:
        ...
    def get_distance_unit(self) -> axipy.cpp_cs.ShadowLinearUnit:
        ...
    def isEqual(self, other: ShadowMap) -> bool:
        ...
    def isValid(self) -> bool:
        ...
    def reset_editableLayer(self) -> None:
        ...
    def setParentMap(self, parent: PySide2.QtCore.QObject) -> None:
        ...
    def set_area_unit(self, areaUnit: axipy.cpp_cs.ShadowAreaUnit) -> None:
        ...
    def set_distance_unit(self, distanceUnit: axipy.cpp_cs.ShadowLinearUnit) -> None:
        ...
    def set_editableLayer(self, lay: ShadowLayer) -> None:
        ...
class ShadowMapReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_clip_geometry(item: ShadowMapReportItem) -> axipy.cpp_core_geometry.ShadowGeometry:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def coordsystem(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def get_center(self) -> PySide2.QtCore.QPointF:
        ...
    def get_clip_geometry_buffer(self) -> int:
        ...
    def get_clip_geometry_status(self) -> bool:
        ...
    def get_scale(self) -> float:
        ...
    def init_impl(self) -> None:
        ...
    def map(self) -> ShadowMap:
        ...
    def rectMap(self) -> PySide2.QtCore.QRectF:
        ...
    def setCoordSystem(self, cs: axipy.cpp_cs.ShadowCoordSystem) -> None:
        ...
    def set_center(self, c: PySide2.QtCore.QPointF) -> None:
        ...
    def set_clip_geometry(self, geometry: typing.Union[axipy.cpp_core_geometry.ShadowGeometry, None] = None) -> None:
        ...
    def set_clip_geometry_buffer(self, v: int) -> None:
        ...
    def set_clip_geometry_status(self, v: bool) -> None:
        ...
    def set_scale(self, v: float) -> None:
        ...
    def show_all(self) -> None:
        ...
class ShadowRasterLayer(ShadowLayer):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    internalDeleted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    needRedraw: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_brightness(self) -> int:
        ...
    def get_brightness_percent(self) -> int:
        ...
    def get_contrast(self) -> int:
        ...
    def get_contrast_percent(self) -> int:
        ...
    def get_grayscale(self) -> bool:
        ...
    def get_transparentColor(self) -> PySide2.QtGui.QColor:
        ...
    def set_brightness(self, v: int) -> None:
        ...
    def set_brightness_percent(self, v: int) -> None:
        ...
    def set_contrast(self, v: int) -> None:
        ...
    def set_contrast_percent(self, v: int) -> None:
        ...
    def set_grayscale(self, v: bool) -> None:
        ...
    def set_transparentColor(self, cl: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
class ShadowRasterReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_preserveAspectRatio(self) -> bool:
        ...
    def init_impl(self) -> None:
        ...
    def set_preserveAspectRatio(self, v: bool) -> None:
        ...
class ShadowRectangleItem(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_borderStyle(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def get_fillStyle(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def set_borderStyle(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_fillStyle(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowReport(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_items(report: ShadowReport) -> ShadowReportItemsBase:
        ...
    needRedraw: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def unit(report: ShadowReport) -> axipy.cpp_cs.ShadowLinearUnit:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def draw(self, context: ShadowContext) -> None:
        ...
    def fill_on_pages(self) -> None:
        ...
    def fit_pages(self) -> None:
        ...
    def get_horisontal_pages(self) -> int:
        ...
    def get_name(self) -> str:
        ...
    def get_vertical_pages(self) -> int:
        ...
    def page_size(self) -> PySide2.QtCore.QSizeF:
        ...
    def set_horisontal_pages(self, v: int) -> None:
        ...
    def set_name(self, name: str) -> None:
        ...
    def set_unit(self, unit: axipy.cpp_cs.ShadowLinearUnit) -> None:
        ...
    def set_vertical_pages(self, v: int) -> None:
        ...
class ShadowReportItem(ShadowRectangleItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def equals(self, other: ShadowReportItem) -> bool:
        ...
    def get_rect(self) -> PySide2.QtCore.QRectF:
        ...
    def id(self) -> int:
        ...
    def init_impl(self) -> None:
        ...
    def intersects(self, r: PySide2.QtCore.QRectF) -> bool:
        ...
    def parent_id(self) -> int:
        ...
    def redraw(self) -> None:
        ...
    def set_rect(self, r: PySide2.QtCore.QRectF) -> None:
        ...
    def title(self) -> str:
        ...
class ShadowReportItemsBase(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def at(items: ShadowReportItemsBase, idx: int) -> ShadowReportItem:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def add(self, item: ShadowReportItem) -> None:
        ...
    def count(self) -> int:
        ...
    def move(self, item: ShadowReportItem, idx: int) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
class ShadowScaleBarReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def init_impl(self) -> None:
        ...
class ShadowTableReportItem(ShadowReportItem):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_rowCount(self) -> int:
        ...
    def get_rowFrom(self) -> int:
        ...
    def get_selectedColumns(self) -> typing.List[str]:
        ...
    def get_showRowNumber(self) -> bool:
        ...
    def get_startNumber(self) -> int:
        ...
    def init_impl(self) -> None:
        ...
    def refreshValues(self) -> None:
        ...
    def set_rowCount(self, v: int) -> None:
        ...
    def set_rowFrom(self, v: int) -> None:
        ...
    def set_selectedColumns(self, sl: typing.Sequence[str]) -> None:
        ...
    def set_showRowNumber(self, v: bool) -> None:
        ...
    def set_startNumber(self, v: int) -> None:
        ...
    def table(self) -> axipy.cpp_core_dp.ShadowTable:
        ...
class ShadowThematic(ShadowLayer):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    internalDeleted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    needRedraw: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowThematicBar(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_style(bar: ShadowThematicBar, idx: int) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def expressions(self) -> typing.List[str]:
        ...
    def get_allocation_type(self) -> int:
        ...
    def get_is_stacked(self) -> bool:
        ...
    def get_orientation_type(self) -> int:
        ...
    def set_allocation_type(self, v: int) -> None:
        ...
    def set_is_stacked(self, v: bool) -> None:
        ...
    def set_orientation_type(self, t: int) -> None:
        ...
    def set_style(self, idx: int, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowThematicDensity(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def expression(self) -> str:
        ...
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_point_for_maximum(self) -> int:
        ...
    def get_size(self) -> float:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_point_for_maximum(self, cnt: int) -> None:
        ...
    def set_size(self, v: float) -> None:
        ...
class ShadowThematicIndividual(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_style(ind: ShadowThematicIndividual, idx: int) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def assign_gray(self, minv: int, maxv: int) -> None:
        ...
    def assign_monotone(self, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], minv: int, maxv: int) -> None:
        ...
    def assign_rainbow(self, sequential: bool, saturation: float, value: float) -> None:
        ...
    def assign_three_colors(self, minColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], maxColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], breakColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], br: int, useHSV: bool) -> None:
        ...
    def assign_two_colors(self, minColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], maxColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], useHSV: bool) -> None:
        ...
    def expression(self) -> str:
        ...
    def get_count(self) -> int:
        ...
    def get_default_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def get_geometry_class(self) -> int:
        ...
    def get_value(self, idx: int) -> typing.Any:
        ...
    def set_default_style(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_geometry_class(self, v: int) -> None:
        ...
    def set_style(self, idx: int, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowThematicList(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def add(self, thematic: ShadowThematic) -> None:
        ...
    def at(self, idx: int) -> ShadowThematic:
        ...
    def by_name(self, name: str) -> ShadowThematic:
        ...
    def count(self) -> int:
        ...
    def move(self, from_: int, to: int) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
class ShadowThematicPie(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_style(pie: ShadowThematicPie, idx: int) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def expressions(self) -> typing.List[str]:
        ...
    def get_allocation_type(self) -> int:
        ...
    def get_orientation_type(self) -> int:
        ...
    def get_start_angle(self) -> int:
        ...
    def set_allocation_type(self, v: int) -> None:
        ...
    def set_orientation_type(self, t: int) -> None:
        ...
    def set_start_angle(self, v: float) -> None:
        ...
    def set_style(self, idx: int, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowThematicRange(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_style(range: ShadowThematicRange, idxRange: int) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def assign_gray(self, minv: int, maxv: int) -> None:
        ...
    def assign_monotone(self, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], minv: int, maxv: int) -> None:
        ...
    def assign_rainbow(self, sequential: bool, saturation: float, value: float) -> None:
        ...
    def assign_three_colors(self, minColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], maxColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], breakColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], br: int, useHSV: bool) -> None:
        ...
    def assign_two_colors(self, minColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], maxColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], useHSV: bool) -> None:
        ...
    def expression(self) -> str:
        ...
    def get_default_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def get_geometry_class(self) -> int:
        ...
    def get_interval_values(self, idxRange: int) -> typing.Tuple[typing.Any, typing.Any]:
        ...
    def get_ranges(self) -> int:
        ...
    def get_split_type(self) -> int:
        ...
    def set_default_style(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_geometry_class(self, v: int) -> None:
        ...
    def set_interval_values(self, idxRange: int, v: typing.Tuple[typing.Any, typing.Any]) -> None:
        ...
    def set_ranges(self, ranges: int) -> None:
        ...
    def set_split_type(self, t: int) -> None:
        ...
    def set_style(self, idx: int, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowThematicSymbol(ShadowThematic):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def expression(self) -> str:
        ...
    def get_default_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def get_max_height(self) -> int:
        ...
    def get_min_height(self) -> int:
        ...
    def set_default_style(self, s: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def set_max_height(self, value: int) -> None:
        ...
    def set_min_height(self, value: int) -> None:
        ...
class ShadowVectorLayer(ShadowLayer):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_hotlink(self) -> str:
        ...
    def get_label(self) -> str:
        ...
    def get_label_areaInterior(self) -> int:
        ...
    def get_label_areaLayout(self) -> ShadowLabelLayout:
        ...
    def get_label_areaPosition(self) -> int:
        ...
    def get_label_backgroundColor(self) -> PySide2.QtGui.QColor:
        ...
    def get_label_backgroundSize(self) -> int:
        ...
    def get_label_backgroundType(self) -> int:
        ...
    def get_label_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_label_font(self) -> PySide2.QtGui.QFont:
        ...
    def get_label_horizontalAlign(self) -> int:
        ...
    def get_label_lineKeepDirection(self) -> bool:
        ...
    def get_label_lineLayout(self) -> ShadowLabelLayout:
        ...
    def get_label_linePosition(self) -> int:
        ...
    def get_label_opacity(self) -> int:
        ...
    def get_label_overhang(self) -> int:
        ...
    def get_label_placement_policy(self) -> int:
        ...
    def get_label_pointLayout(self) -> ShadowLabelLayout:
        ...
    def get_label_rangeEnabled(self) -> bool:
        ...
    def get_label_rangeMax(self) -> float:
        ...
    def get_label_rangeMin(self) -> float:
        ...
    def get_label_shadow(self) -> bool:
        ...
    def get_label_spacing(self) -> bool:
        ...
    def get_label_supressDuplicates(self) -> bool:
        ...
    def get_label_useClip(self) -> bool:
        ...
    def get_label_visible(self) -> bool:
        ...
    def get_linesDirectionVisibile(self) -> bool:
        ...
    def get_nodesVisible(self) -> bool:
        ...
    def get_override_style(self) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    def get_show_centroid(self) -> bool:
        ...
    def get_thematics(self) -> ShadowThematicList:
        ...
    def set_hotlink(self, v: str) -> None:
        ...
    def set_label(self, v: str) -> None:
        ...
    def set_label_areaInterior(self, v: int) -> None:
        ...
    def set_label_areaLayout(self, lay: ShadowLabelLayout) -> None:
        ...
    def set_label_areaPosition(self, v: int) -> None:
        ...
    def set_label_backgroundColor(self, v: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_label_backgroundSize(self, v: int) -> None:
        ...
    def set_label_backgroundType(self, v: int) -> None:
        ...
    def set_label_color(self, v: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_label_font(self, v: PySide2.QtGui.QFont) -> None:
        ...
    def set_label_horizontalAlign(self, v: int) -> None:
        ...
    def set_label_lineKeepDirection(self, v: bool) -> None:
        ...
    def set_label_lineLayout(self, lay: ShadowLabelLayout) -> None:
        ...
    def set_label_linePosition(self, v: int) -> None:
        ...
    def set_label_opacity(self, v: int) -> None:
        ...
    def set_label_overhang(self, v: int) -> None:
        ...
    def set_label_placement_policy(self, v: int) -> None:
        ...
    def set_label_pointLayout(self, lay: ShadowLabelLayout) -> None:
        ...
    def set_label_rangeEnabled(self, v: bool) -> None:
        ...
    def set_label_rangeMax(self, v: float) -> None:
        ...
    def set_label_rangeMin(self, v: float) -> None:
        ...
    def set_label_shadow(self, v: bool) -> None:
        ...
    def set_label_spacing(self, v: bool) -> None:
        ...
    def set_label_supressDuplicates(self, v: bool) -> None:
        ...
    def set_label_useClip(self, v: bool) -> None:
        ...
    def set_label_visible(self, v: bool) -> None:
        ...
    def set_linesDirectionVisibile(self, v: bool) -> None:
        ...
    def set_nodesVisible(self, v: bool) -> None:
        ...
    def set_override_style(self, s: typing.Union[axipy.cpp_core_geometry.ShadowStyle, None] = None) -> None:
        ...
    def set_show_centroid(self, v: bool) -> None:
        ...
def defaultFilePath(d: PySide2.QtCore.QDir, path: str) -> str:
    ...
def defaultInterfaceTheme() -> str:
    ...
def defaultPathLocation() -> str:
    ...
def defaultTypeInterface() -> str:
    ...
def detectDefaultPythonFont() -> str:
    ...
def isWaylandPlatform() -> bool:
    ...
def isX11Platform() -> bool:
    ...
def lengthUnitPrefix() -> str:
    ...
def loadCodecFromJson(value: QJsonValue) -> PySide2.QtCore.QTextCodec:
    ...
def loadPointFromJson(value: QJsonValue) -> PySide2.QtCore.QPointF:
    ...
def loadQRectFFromJson(value: QJsonValue) -> PySide2.QtCore.QRectF:
    ...
def loadQSizeFromJson(value: QJsonValue) -> PySide2.QtCore.QSize:
    ...
def loadQTransformFromJson(value: QJsonValue) -> PySide2.QtGui.QTransform:
    ...
def pixelString() -> str:
    ...
def prefixCacheDir() -> str:
    ...
def saveCodecToJson(codec: PySide2.QtCore.QTextCodec) -> QJsonValue:
    ...
def saveLineToJson(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def saveLineToJsonEmbedded(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def savePointToJson(point: PySide2.QtCore.QPointF) -> QJsonValue:
    ...
def savePolylineToJson(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def savePolylineToJsonEmbedded(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def saveQRectFToJson(rect: PySide2.QtCore.QRectF) -> QJsonValue:
    ...
def saveQSizeToJson(size: PySide2.QtCore.QSize) -> QJsonValue:
    ...
def saveQTransfomToJson(transform: PySide2.QtGui.QTransform) -> QJsonValue:
    ...
def titanInterfaceStyle() -> str:
    ...
def underWayland() -> bool:
    ...
