import typing
from typing import ForwardRef
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtPrintSupport
import PySide2.QtSql
import PySide2.QtWidgets
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_common
import axipy.cpp_core_core
import axipy.cpp_core_dp
import axipy.cpp_core_geometry
import axipy.cpp_cs
import axipy.cpp_render
import typing
QJsonValue = typing.Any

__all__ = ['AcceptableToolPanelHandler', 'Accepted', 'ActiveToolPanelExecCode', 'ActiveToolPanelHandlerBase', 'BoundingRectWidget', 'Cancelable', 'CoordinateLineEdit', 'CustomToolPanelHandler', 'Idle', 'InteractionType', 'NoDelay', 'PasswordWidget', 'RasterAddToSelection', 'RasterSelectInArea', 'RasterSelectNext', 'RasterSelectionMode', 'RasterSimpleSelection', 'ShadowActiveToolPanelMediator', 'ShadowAlignedView', 'ShadowButtonPositionIndex', 'ShadowChooseCoordSystemWidget', 'ShadowClipboardManager', 'ShadowCoordFormatter', 'ShadowDataCatalogWidget', 'ShadowDrawableView', 'ShadowFileOperationManager', 'ShadowGui', 'ShadowGuiUtils', 'ShadowLayerControlWidget', 'ShadowLegendView', 'ShadowListWindowWidget', 'ShadowMapTool', 'ShadowMapView', 'ShadowMenuBar', 'ShadowNotificationWidget', 'ShadowNotifications', 'ShadowProgressElementFactory', 'ShadowProgressSpecification', 'ShadowProgressSpecificationFlags', 'ShadowPythonConsoleWidget', 'ShadowReportView', 'ShadowSelectionManager', 'ShadowStyleButton', 'ShadowStyleEditWidget', 'ShadowTableView', 'ShadowToolFactory', 'ShadowView', 'ShadowViewPointsHelper', 'ShadowViewType', 'ShadowWidgetContainer', 'ShadowWidgetManager', 'ShadowWorkspace', 'ToolPanelHandlerType', 'defaultFilePath', 'defaultInterfaceTheme', 'defaultPathLocation', 'defaultTypeInterface', 'detectDefaultPythonFont', 'isWaylandPlatform', 'isX11Platform', 'loadCodecFromJson', 'loadPointFromJson', 'loadQRectFFromJson', 'loadQSizeFromJson', 'loadQTransformFromJson', 'prefixCacheDir', 'saveCodecToJson', 'saveLineToJson', 'saveLineToJsonEmbedded', 'savePointToJson', 'savePolylineToJson', 'savePolylineToJsonEmbedded', 'saveQRectFToJson', 'saveQSizeToJson', 'saveQTransfomToJson', 'setProgressDialogSettings', 'titanInterfaceStyle', 'underWayland', 'wrap', 'wrapWidget']
class AcceptableToolPanelHandler(ActiveToolPanelHandlerBase):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    accepted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def disable(self) -> None:
        ...
    def enable(self) -> None:
        ...
class ActiveToolPanelExecCode(shiboken2.Shiboken.Enum):
    Accepted: typing.ClassVar[ActiveToolPanelExecCode]  # value = axipy.cpp_gui.ActiveToolPanelExecCode.Accepted
    values: typing.ClassVar[dict]  # value = {'Accepted': axipy.cpp_gui.ActiveToolPanelExecCode.Accepted}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ActiveToolPanelHandlerBase(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    deactivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    panelClosed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def activate(self) -> None:
        ...
    def beginBeActive(self) -> None:
        ...
    def deactivate(self) -> None:
        ...
    def endBeActive(self) -> None:
        ...
    def flags(self) -> ToolPanelHandlerType:
        ...
    def observer(self) -> axipy.cpp_core_core.ValueObserver:
        ...
    def reset(self) -> None:
        ...
    def setFlags(self, flag: ToolPanelHandlerType) -> None:
        ...
    def setObserver(self, observer_id: str) -> None:
        ...
    def setPanelTitle(self, title: str) -> None:
        ...
    def setWidget(self, widget: PySide2.QtWidgets.QWidget) -> None:
        ...
    def title(self) -> str:
        ...
    def widget(self) -> PySide2.QtWidgets.QWidget:
        ...
class BoundingRectWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def isSquare(self) -> bool:
        ...
    def resultIsValidSquared(self) -> bool:
        ...
    def resultRect(self) -> PySide2.QtCore.QRectF:
        ...
    def setIsSquare(self, v: bool) -> None:
        ...
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None:
        ...
    def setUnitName(self, n: str) -> None:
        ...
    def unitName(self) -> str:
        ...
class CoordinateLineEdit(PySide2.QtWidgets.QLineEdit):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    valueChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def focusInEvent(self, event: PySide2.QtGui.QFocusEvent) -> None:
        ...
    def focusOutEvent(self, event: PySide2.QtGui.QFocusEvent) -> None:
        ...
    def isDegreeMode(self) -> bool:
        ...
    def maximum(self) -> float:
        ...
    def minimum(self) -> float:
        ...
    def setDegreeAsDDMMSS(self, value: bool) -> None:
        ...
    def setFloatPrecision(self, v: int) -> None:
        ...
    def setMaximum(self, maximum: float) -> None:
        ...
    def setMinimum(self, minimum: float) -> None:
        ...
    def setRange(self, minimum: float, maximum: float) -> None:
        ...
    def setValue(self, value: float) -> None:
        ...
    def updateText(self) -> None:
        ...
    def value(self) -> float:
        ...
class CustomToolPanelHandler(ActiveToolPanelHandlerBase):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    activated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    deactivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    panelClosed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class InteractionType(shiboken2.Shiboken.Enum):
    ActionClick: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.ActionClick
    ActionShortcut: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.ActionShortcut
    LayerClick: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.LayerClick
    ObjectClose: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.ObjectClose
    Unknown: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.Unknown
    WindowClose: typing.ClassVar[InteractionType]  # value = axipy.cpp_gui.InteractionType.WindowClose
    values: typing.ClassVar[dict]  # value = {'Unknown': axipy.cpp_gui.InteractionType.Unknown, 'ObjectClose': axipy.cpp_gui.InteractionType.ObjectClose, 'WindowClose': axipy.cpp_gui.InteractionType.WindowClose, 'ActionClick': axipy.cpp_gui.InteractionType.ActionClick, 'ActionShortcut': axipy.cpp_gui.InteractionType.ActionShortcut, 'LayerClick': axipy.cpp_gui.InteractionType.LayerClick}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class PasswordWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def addressName(self) -> str:
        ...
    def password(self) -> str:
        ...
    def setAddressName(self, address: str) -> None:
        ...
    def setPassword(self, pass_: str) -> None:
        ...
    def setUserName(self, user: str) -> None:
        ...
    def userName(self) -> str:
        ...
class RasterSelectionMode(shiboken2.Shiboken.Enum):
    RasterAddToSelection: typing.ClassVar[RasterSelectionMode]  # value = axipy.cpp_gui.RasterSelectionMode.RasterAddToSelection
    RasterSelectInArea: typing.ClassVar[RasterSelectionMode]  # value = axipy.cpp_gui.RasterSelectionMode.RasterSelectInArea
    RasterSelectNext: typing.ClassVar[RasterSelectionMode]  # value = axipy.cpp_gui.RasterSelectionMode.RasterSelectNext
    RasterSimpleSelection: typing.ClassVar[RasterSelectionMode]  # value = axipy.cpp_gui.RasterSelectionMode.RasterSimpleSelection
    values: typing.ClassVar[dict]  # value = {'RasterSimpleSelection': axipy.cpp_gui.RasterSelectionMode.RasterSimpleSelection, 'RasterSelectNext': axipy.cpp_gui.RasterSelectionMode.RasterSelectNext, 'RasterAddToSelection': axipy.cpp_gui.RasterSelectionMode.RasterAddToSelection, 'RasterSelectInArea': axipy.cpp_gui.RasterSelectionMode.RasterSelectInArea}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ShadowActiveToolPanelMediator(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def make_handler(self, type: ToolPanelHandlerType) -> ActiveToolPanelHandlerBase:
        ...
class ShadowAlignedView(ShadowDrawableView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    snapStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def addXGuideline(self, v: float) -> None:
        ...
    def addYGuideline(self, v: float) -> None:
        ...
    def clearGuidelines(self) -> None:
        ...
    def removeSelectedGuideline(self) -> bool:
        ...
    def setShowMesh(self, showLayoutMesh: bool) -> None:
        ...
    def setSnapToGuidelines(self, snap: bool) -> None:
        ...
    def setSnapToMesh(self, snap: bool) -> None:
        ...
    def setXGuideline(self, idx: int, v: float) -> None:
        ...
    def setYGuideline(self, idx: int, v: float) -> None:
        ...
    def showMesh(self) -> bool:
        ...
    def snapToGuidelines(self) -> bool:
        ...
    def snapToMesh(self) -> bool:
        ...
    def xGuidelines(self) -> typing.List[float]:
        ...
    def yGuidelines(self) -> typing.List[float]:
        ...
class ShadowButtonPositionIndex(shiboken2.Shiboken.Enum):
    COUNT: typing.ClassVar[ShadowButtonPositionIndex]  # value = axipy.cpp_gui.ShadowButtonPositionIndex.COUNT
    GroupId: typing.ClassVar[ShadowButtonPositionIndex]  # value = axipy.cpp_gui.ShadowButtonPositionIndex.GroupId
    GroupName: typing.ClassVar[ShadowButtonPositionIndex]  # value = axipy.cpp_gui.ShadowButtonPositionIndex.GroupName
    TabId: typing.ClassVar[ShadowButtonPositionIndex]  # value = axipy.cpp_gui.ShadowButtonPositionIndex.TabId
    TabName: typing.ClassVar[ShadowButtonPositionIndex]  # value = axipy.cpp_gui.ShadowButtonPositionIndex.TabName
    values: typing.ClassVar[dict]  # value = {'TabId': axipy.cpp_gui.ShadowButtonPositionIndex.TabId, 'TabName': axipy.cpp_gui.ShadowButtonPositionIndex.TabName, 'GroupId': axipy.cpp_gui.ShadowButtonPositionIndex.GroupId, 'GroupName': axipy.cpp_gui.ShadowButtonPositionIndex.GroupName, 'COUNT': axipy.cpp_gui.ShadowButtonPositionIndex.COUNT}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ShadowChooseCoordSystemWidget(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def chosenCoordSystem(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
class ShadowClipboardManager(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def cursor_from_clipboard(self) -> axipy.cpp_core_dp.ShadowFeatureIterator:
        ...
    def feature_to_clipboard(self, feature: axipy.cpp_core_dp.ShadowFeature) -> None:
        ...
    def features_to_clipboard(self, value: object, arg__2: typing.Dict[str, QJsonValue]) -> None:
        ...
class ShadowCoordFormatter(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def as_float(self, v: typing.Any) -> typing.Tuple[float, bool]:
        ...
    def as_string(self, v: float, precision: int = -1, suppress_trailing_zeros: bool = False) -> str:
        ...
    def as_string_with_delimeter(self, v: float, delim: str = '-', precision: int = -1, suppress_trailing_zeros: bool = False) -> str:
        ...
    def double_to_rumb(self, v: float, precision: int = -1, suppress_trailing_zeros: bool = False) -> str:
        ...
    def rumb_to_double(self, in_: str, ok: bool) -> float:
        ...
    def split_degree(self, v: float) -> typing.Tuple[typing.Tuple[int, int], float]:
        ...
class ShadowDataCatalogWidget(ShadowView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create(gui: ShadowGui) -> ShadowDataCatalogWidget:
        ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def dataObjectsSelected(self) -> typing.List[axipy.cpp_core_dp.ShadowDataObject]:
        ...
    def listWidget(self) -> PySide2.QtWidgets.QListView:
        ...
class ShadowDrawableView(ShadowView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sceneChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    snapStatusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def canRollBack(self) -> bool:
        ...
    def canRollForward(self) -> bool:
        ...
    def deviceToSceneTransform(self) -> PySide2.QtGui.QTransform:
        ...
    def getTextRect(self, pos: PySide2.QtCore.QPointF, text: str, s: axipy.cpp_core_geometry.ShadowStyle) -> PySide2.QtCore.QRectF:
        ...
    def hasModified(self) -> bool:
        ...
    def isSnapMode(self) -> bool:
        ...
    def offset(self, dx: float, dy: float) -> None:
        ...
    def rollBack(self) -> None:
        ...
    def rollForward(self) -> None:
        ...
    def scaleWithCenter(self, zoomCoef: float, center: PySide2.QtCore.QPointF) -> None:
        ...
    def sceneToDeviceTransform(self) -> PySide2.QtGui.QTransform:
        ...
    def setSnapMode(self, v: bool) -> None:
        ...
    def textPoints(self, t: axipy.cpp_core_geometry.ShadowText, s: axipy.cpp_core_geometry.ShadowStyle) -> float:
        ...
class ShadowFileOperationManager(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def workspaceOpen(*args, **kwargs):
        ...
    @staticmethod
    def workspaceSave(*args, **kwargs):
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowGui(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create() -> ShadowGui:
        ...
    @staticmethod
    def gdalDebug(*args, **kwargs):
        ...
    @staticmethod
    def gdalError(*args, **kwargs):
        ...
    @staticmethod
    def global_parent_static() -> PySide2.QtWidgets.QWidget:
        ...
    @staticmethod
    def serviceOperationMessage(*args, **kwargs):
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def all_actions(self) -> typing.List[PySide2.QtWidgets.QAction]:
        ...
    def all_icon_names(self) -> typing.List[str]:
        ...
    def catalog(self) -> axipy.cpp_core_dp.ShadowDataCatalog:
        ...
    def createLegendView(self, mapView: ShadowMapView) -> ShadowLegendView:
        ...
    def createMapView(self, map: axipy.cpp_render.ShadowMap, registerManager: bool = True) -> ShadowMapView:
        ...
    def createReportView(self, report: axipy.cpp_render.ShadowReport) -> ShadowReportView:
        ...
    def createReportViewDefault(self) -> ShadowReportView:
        ...
    def createTableView(self, table: axipy.cpp_core_dp.ShadowDataObject) -> ShadowTableView:
        ...
    def database(self) -> PySide2.QtSql.QSqlDatabase:
        ...
    def fileOperationManager(self) -> ShadowFileOperationManager:
        ...
    def find_action_by_id(self, id: str) -> PySide2.QtWidgets.QAction:
        ...
    def geometryName(self) -> str:
        ...
    def global_parent(self) -> PySide2.QtWidgets.QWidget:
        ...
    def initialize(self) -> None:
        ...
    def installedPluginsPath(self) -> str:
        ...
    def styleName(self) -> str:
        ...
    def systemEnvironment(self) -> typing.Dict[str, QJsonValue]:
        ...
    def system_resource_catalog(self) -> str:
        ...
    def user_resource_catalog(self) -> str:
        ...
class ShadowGuiUtils(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def getExistingDirectory(parent: typing.Union[PySide2.QtWidgets.QWidget, None] = None, caption: str = '', dir: str = '', options: PySide2.QtWidgets.QFileDialog.Options = ...) -> str:
        ...
    @staticmethod
    def getOpenFileName(parent: typing.Union[PySide2.QtWidgets.QWidget, None] = None, caption: str = '', dir: str = '', fileName: str = '', filter: str = '', selectedFilter: str = '', options: PySide2.QtWidgets.QFileDialog.Options = ..., icon: PySide2.QtGui.QIcon = ...) -> typing.List[str]:
        ...
    @staticmethod
    def getOpenFileNames(parent: typing.Union[PySide2.QtWidgets.QWidget, None] = None, caption: str = '', dir: str = '', filter: str = '', selectedFilter: str = '', options: PySide2.QtWidgets.QFileDialog.Options = ..., icon: PySide2.QtGui.QIcon = ...) -> typing.List[str]:
        ...
    @staticmethod
    def getSaveFileName(parent: typing.Union[PySide2.QtWidgets.QWidget, None] = None, caption: str = '', dir: str = '', fileName: str = '', filter: str = '', selectedFilter: str = '', options: PySide2.QtWidgets.QFileDialog.Options = ..., icon: PySide2.QtGui.QIcon = ...) -> typing.List[str]:
        ...
    def selectByMouseClick(self, itemView: ShadowView, event: PySide2.QtGui.QMouseEvent) -> None:
        ...
    def selectByRect(self, itemView: ShadowView, rect: PySide2.QtCore.QRectF, modifiers: PySide2.QtCore.Qt.KeyboardModifiers) -> None:
        ...
class ShadowLayerControlWidget(ShadowView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create(gui: ShadowGui) -> ShadowLayerControlWidget:
        ...
    mapViewActivated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def selected_layers(lc: ShadowLayerControlWidget) -> axipy.cpp_render.ShadowLayers:
        ...
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def active_map_view(self) -> ShadowMapView:
        ...
class ShadowLegendView(ShadowView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def at(lv: ShadowLegendView, idx: int) -> axipy.cpp_render.ShadowLegend:
        ...
    @staticmethod
    def mapview(lv: ShadowLegendView) -> ShadowMapView:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def append(self, item: axipy.cpp_render.ShadowLegend) -> None:
        ...
    def arrange(self) -> None:
        ...
    def count(self) -> int:
        ...
    def remove(self, idx: int) -> None:
        ...
    def replace(self, idx: int, item: axipy.cpp_render.ShadowLegend) -> None:
        ...
class ShadowListWindowWidget(PySide2.QtWidgets.QListView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowMapTool(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def activate(self) -> None:
        ...
    def canDeactivate(self, arg__1: InteractionType) -> bool:
        ...
    def deactivate(self) -> None:
        ...
    def handleEvent(self, arg__1: PySide2.QtCore.QEvent) -> bool:
        ...
    def isScrollMode(self) -> bool:
        ...
    def isSnapped(self) -> bool:
        ...
    def keyPressEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> bool:
        ...
    def keyReleaseEvent(self, arg__1: PySide2.QtGui.QKeyEvent) -> bool:
        ...
    def mouseDoubleClickEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> bool:
        ...
    def mouseMoveEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> bool:
        ...
    def mousePressEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> bool:
        ...
    def mouseReleaseEvent(self, arg__1: PySide2.QtGui.QMouseEvent) -> bool:
        ...
    def paintEvent(self, arg__1: PySide2.QtGui.QPaintEvent, arg__2: PySide2.QtGui.QPainter) -> None:
        ...
    def redraw(self) -> None:
        ...
    def setScrollMode(self, v: bool) -> None:
        ...
    def shadow_view(self) -> ShadowView:
        ...
    def snapPoint(self) -> PySide2.QtCore.QPointF:
        ...
    def wheelEvent(self, arg__1: PySide2.QtGui.QWheelEvent) -> bool:
        ...
class ShadowMapView(ShadowDrawableView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    coordSystemChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def editableLayer(mapview: ShadowMapView) -> axipy.cpp_render.ShadowVectorLayer:
        ...
    editableLayerChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def get_clip_geometry(mapview: ShadowMapView) -> axipy.cpp_core_geometry.ShadowGeometry:
        ...
    @staticmethod
    def map(mv: ShadowMapView) -> axipy.cpp_render.ShadowMap:
        ...
    mouseMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def selectionLayer(mapview: ShadowMapView) -> axipy.cpp_render.ShadowVectorLayer:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def calc_mode(self) -> axipy.cpp_common.ShadowCalcMode:
        ...
    def center(self) -> PySide2.QtCore.QPointF:
        ...
    def coordSystemVisual(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def coordsystem(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def deviceRect(self) -> PySide2.QtCore.QRectF:
        ...
    def get_clip_geometry_buffer(self) -> int:
        ...
    def get_clip_geometry_status(self) -> bool:
        ...
    def get_unit(self) -> axipy.cpp_cs.ShadowLinearUnit:
        ...
    def scale(self) -> float:
        ...
    def sceneRect(self) -> PySide2.QtCore.QRectF:
        ...
    def setCenter(self, c: PySide2.QtCore.QPointF) -> None:
        ...
    def setCoordSystem(self, cs: axipy.cpp_cs.ShadowCoordSystem) -> None:
        ...
    def setScale(self, v: float) -> None:
        ...
    def setSceneRect(self, r: PySide2.QtCore.QRectF) -> None:
        ...
    def setZoom(self, v: float, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> None:
        ...
    def setZoomAndCenter(self, v: float, c: PySide2.QtCore.QPointF, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> None:
        ...
    def set_calc_mode(self, v: axipy.cpp_common.ShadowCalcMode) -> None:
        ...
    def set_clip_geometry(self, geometry: typing.Union[axipy.cpp_core_geometry.ShadowGeometry, None] = None) -> None:
        ...
    def set_clip_geometry_buffer(self, v: int) -> None:
        ...
    def set_clip_geometry_status(self, v: bool) -> None:
        ...
    def set_unit(self, coordinateUnit: axipy.cpp_cs.ShadowLinearUnit) -> None:
        ...
    def showAll(self) -> None:
        ...
    def showSelection(self) -> None:
        ...
    def zoom(self, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> float:
        ...
class ShadowMenuBar(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def add_action_button(self, action: PySide2.QtWidgets.QAction, position: typing.Sequence[str], observerId: str, size: int = 1) -> None:
        ...
    def add_menu_button(self, action: PySide2.QtWidgets.QAction, text: str, before: bool, observerId: str) -> None:
        ...
    def add_toggle_button(self, action: PySide2.QtWidgets.QAction, position: typing.Sequence[str], observerId: str, size: int = 1, add_to_tool_group: bool = False) -> None:
        ...
    def add_tool_button(self, action: PySide2.QtWidgets.QAction, position: typing.Sequence[str], toolFactory: ShadowToolFactory, observerId: str, size: int = 1) -> None:
        ...
    def groups(self) -> typing.Dict[str, str]:
        ...
    def remove(self, action: PySide2.QtWidgets.QAction) -> None:
        ...
    def removeSystem(self, action: PySide2.QtWidgets.QAction) -> None:
        ...
    def tabs(self) -> typing.Dict[str, str]:
        ...
class ShadowNotificationWidget(PySide2.QtWidgets.QWidget):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def contextMenuEvent(self, arg__1: PySide2.QtGui.QContextMenuEvent) -> None:
        ...
    def event(self, event: PySide2.QtCore.QEvent) -> bool:
        ...
    def keyPressEvent(self, event: PySide2.QtGui.QKeyEvent) -> None:
        ...
class ShadowNotifications(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def push(title: str, text: str, role: int = 0, duration: int = 5000) -> None:
        ...
class ShadowProgressElementFactory(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def make_dialog_for_task(self, task: axipy.cpp_core_core.ShadowTask, spec: ShadowProgressSpecification) -> PySide2.QtWidgets.QDialog:
        ...
class ShadowProgressSpecification(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
class ShadowProgressSpecificationFlags(shiboken2.Shiboken.Enum):
    Cancelable: typing.ClassVar[ShadowProgressSpecificationFlags]  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.Cancelable
    Idle: typing.ClassVar[ShadowProgressSpecificationFlags]  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.Idle
    NoDelay: typing.ClassVar[ShadowProgressSpecificationFlags]  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.NoDelay
    values: typing.ClassVar[dict]  # value = {'Idle': axipy.cpp_gui.ShadowProgressSpecificationFlags.Idle, 'Cancelable': axipy.cpp_gui.ShadowProgressSpecificationFlags.Cancelable, 'NoDelay': axipy.cpp_gui.ShadowProgressSpecificationFlags.NoDelay}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ShadowPythonConsoleWidget(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create(gui: ShadowGui) -> ShadowPythonConsoleWidget:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def widget(self) -> PySide2.QtWidgets.QWidget:
        ...
class ShadowReportView(ShadowAlignedView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_selected_items(reportView: ShadowReportView) -> axipy.cpp_render.ShadowReportItemsBase:
        ...
    mouseMoved: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def report(mv: ShadowReportView) -> axipy.cpp_render.ShadowReport:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def fillOnPages(self) -> bool:
        ...
    def get_printer(self) -> PySide2.QtPrintSupport.QPrinter:
        ...
    def meshSize(self) -> float:
        ...
    def print(self) -> None:
        ...
    def print_preview(self) -> None:
        ...
    def saveToFile(self, fileName: str) -> None:
        ...
    def setMeshSize(self, v: float) -> None:
        ...
    def setShowElementsSize(self, v: bool) -> None:
        ...
    def setShowLayoutBorders(self, v: bool) -> None:
        ...
    def setShowLayoutRuler(self, v: bool) -> None:
        ...
    def setViewScale(self, v: float) -> None:
        ...
    def set_printer(self, p: PySide2.QtPrintSupport.QPrinter) -> None:
        ...
    def showElementsSize(self) -> bool:
        ...
    def showLayoutBorders(self) -> bool:
        ...
    def showLayoutRuler(self) -> bool:
        ...
    def viewScale(self) -> float:
        ...
class ShadowSelectionManager(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    selectionChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    targetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def add(self, table: axipy.cpp_core_dp.ShadowDataObject, ids: typing.List[int]) -> None:
        ...
    def as_table(self) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def clear(self) -> None:
        ...
    def clearTarget(self) -> None:
        ...
    def count(self) -> int:
        ...
    def ids(self) -> typing.List[int]:
        ...
    def remove(self, table: axipy.cpp_core_dp.ShadowDataObject, ids: typing.List[int]) -> None:
        ...
    def selectionToTarget(self) -> None:
        ...
    def set(self, table: axipy.cpp_core_dp.ShadowDataObject, ids: typing.List[int]) -> None:
        ...
    def set_all(self, table: axipy.cpp_core_dp.ShadowDataObject) -> None:
        ...
    def table(self) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
    def target_ids(self) -> typing.List[int]:
        ...
    def target_table(self) -> axipy.cpp_core_dp.ShadowDataObject:
        ...
class ShadowStyleButton(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_style(btn: ShadowStyleButton) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    styleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def pixmap(self) -> PySide2.QtGui.QPixmap:
        ...
    def reinitPixmap(self) -> None:
        ...
    def set_style(self, newStyle: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
class ShadowStyleEditWidget(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def forGeometry(geometry: axipy.cpp_core_geometry.ShadowGeometry, parentDialog: PySide2.QtWidgets.QDialog) -> ShadowStyleEditWidget:
        ...
    @staticmethod
    def forGeometryStyle(v: int, parentDialog: PySide2.QtWidgets.QDialog) -> ShadowStyleEditWidget:
        ...
    @staticmethod
    def forStyle(style: axipy.cpp_core_geometry.ShadowStyle, parentDialog: PySide2.QtWidgets.QDialog) -> ShadowStyleEditWidget:
        ...
    @staticmethod
    def resultStyle(w: ShadowStyleEditWidget) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
class ShadowTableView(ShadowView):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def dataobject(self) -> axipy.cpp_core_dp.ShadowTable:
        ...
    def table_view(self) -> PySide2.QtWidgets.QTableView:
        ...
class ShadowToolFactory(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def requestReset() -> None:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def create(self, view_type: ShadowViewType) -> PySide2.QtCore.QObject:
        ...
class ShadowView(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def id(self) -> int:
        ...
    def isEqual(self, other: ShadowView) -> bool:
        ...
    def redraw(self) -> None:
        ...
    def setWidget(self, w: PySide2.QtWidgets.QWidget) -> None:
        ...
    def widget(self) -> PySide2.QtWidgets.QWidget:
        ...
class ShadowViewPointsHelper(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def normalize(self, p: PySide2.QtCore.QPointF, polygonOriginal: PySide2.QtGui.QPolygonF) -> PySide2.QtCore.QPointF:
        ...
class ShadowViewType(shiboken2.Shiboken.Enum):
    MAP_VIEW: typing.ClassVar[ShadowViewType]  # value = axipy.cpp_gui.ShadowViewType.MAP_VIEW
    REPORT_VIEW: typing.ClassVar[ShadowViewType]  # value = axipy.cpp_gui.ShadowViewType.REPORT_VIEW
    values: typing.ClassVar[dict]  # value = {'MAP_VIEW': axipy.cpp_gui.ShadowViewType.MAP_VIEW, 'REPORT_VIEW': axipy.cpp_gui.ShadowViewType.REPORT_VIEW}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ShadowWidgetContainer(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
class ShadowWidgetManager(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def activate(*args, **kwargs):
        ...
    activeWidgetChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    activeWidgetIdChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @staticmethod
    def close(*args, **kwargs):
        ...
    countChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def active(self) -> ShadowView:
        ...
    def activeWidget(self) -> PySide2.QtWidgets.QWidget:
        ...
    def allWidgets(self) -> typing.List[PySide2.QtWidgets.QWidget]:
        ...
    def is_active(self, view: ShadowView) -> bool:
        ...
    def views(self) -> typing.List[axipy.cpp_gui.ShadowView]:
        ...
    def widgets(self) -> typing.List[axipy.cpp_gui.ShadowView]:
        ...
class ShadowWorkspace(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def load_file(self, fileName: str, suppressNonExists: bool) -> None:
        ...
    def load_string(self, data: str, suppressNonExists: bool) -> None:
        ...
    def save_file(self, fileName: str) -> None:
        ...
    def save_string(self) -> str:
        ...
class ToolPanelHandlerType(shiboken2.Shiboken.Enum):
    Custom: typing.ClassVar[ToolPanelHandlerType]  # value = axipy.cpp_gui.ToolPanelHandlerType.Custom
    WithAcceptButtonBox: typing.ClassVar[ToolPanelHandlerType]  # value = axipy.cpp_gui.ToolPanelHandlerType.WithAcceptButtonBox
    values: typing.ClassVar[dict]  # value = {'Custom': axipy.cpp_gui.ToolPanelHandlerType.Custom, 'WithAcceptButtonBox': axipy.cpp_gui.ToolPanelHandlerType.WithAcceptButtonBox}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
def defaultFilePath(d: PySide2.QtCore.QDir, path: str) -> str:
    ...
def defaultInterfaceTheme() -> str:
    ...
def defaultPathLocation() -> str:
    ...
def defaultTypeInterface() -> str:
    ...
def detectDefaultPythonFont() -> str:
    ...
def isWaylandPlatform() -> bool:
    ...
def isX11Platform() -> bool:
    ...
def loadCodecFromJson(value: QJsonValue) -> PySide2.QtCore.QTextCodec:
    ...
def loadPointFromJson(value: QJsonValue) -> PySide2.QtCore.QPointF:
    ...
def loadQRectFFromJson(value: QJsonValue) -> PySide2.QtCore.QRectF:
    ...
def loadQSizeFromJson(value: QJsonValue) -> PySide2.QtCore.QSize:
    ...
def loadQTransformFromJson(value: QJsonValue) -> PySide2.QtGui.QTransform:
    ...
def prefixCacheDir() -> str:
    ...
def saveCodecToJson(codec: PySide2.QtCore.QTextCodec) -> QJsonValue:
    ...
def saveLineToJson(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def saveLineToJsonEmbedded(line: PySide2.QtCore.QLineF) -> QJsonValue:
    ...
def savePointToJson(point: PySide2.QtCore.QPointF) -> QJsonValue:
    ...
def savePolylineToJson(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def savePolylineToJsonEmbedded(polyline: typing.List[PySide2.QtCore.QPointF]) -> QJsonValue:
    ...
def saveQRectFToJson(rect: PySide2.QtCore.QRectF) -> QJsonValue:
    ...
def saveQSizeToJson(size: PySide2.QtCore.QSize) -> QJsonValue:
    ...
def saveQTransfomToJson(transform: PySide2.QtGui.QTransform) -> QJsonValue:
    ...
def setProgressDialogSettings(dialog: PySide2.QtWidgets.QDialog) -> None:
    ...
def titanInterfaceStyle() -> str:
    ...
def underWayland() -> bool:
    ...
def wrap(view: PySide2.QtWidgets.QWidget) -> ShadowView:
    ...
def wrapWidget(view: PySide2.QtWidgets.QWidget) -> ShadowView:
    ...
Accepted: ActiveToolPanelExecCode  # value = axipy.cpp_gui.ActiveToolPanelExecCode.Accepted
Cancelable: ShadowProgressSpecificationFlags  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.Cancelable
Idle: ShadowProgressSpecificationFlags  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.Idle
NoDelay: ShadowProgressSpecificationFlags  # value = axipy.cpp_gui.ShadowProgressSpecificationFlags.NoDelay
RasterAddToSelection: RasterSelectionMode  # value = axipy.cpp_gui.RasterSelectionMode.RasterAddToSelection
RasterSelectInArea: RasterSelectionMode  # value = axipy.cpp_gui.RasterSelectionMode.RasterSelectInArea
RasterSelectNext: RasterSelectionMode  # value = axipy.cpp_gui.RasterSelectionMode.RasterSelectNext
RasterSimpleSelection: RasterSelectionMode  # value = axipy.cpp_gui.RasterSelectionMode.RasterSimpleSelection
