import typing
from typing import ForwardRef
import PySide2.QtCore
import shiboken2.Shiboken
from __future__ import annotations
import typing
QJsonValue = typing.Any

__all__ = ['Binary', 'CalcCartesian', 'CalcModeDefault', 'CalcOnEllipsoid', 'CalcOnSphere', 'CommonUtils', 'FileFormatType', 'HandlerAcceptor', 'Json', 'Serializable', 'ShadowCalcMode', 'ShadowMemory', 'ShadowNestedException', 'Text', 'Xml']
class CommonUtils(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def approx_compare_points(p1: PySide2.QtCore.QPointF, p2: PySide2.QtCore.QPointF, precision: float = 1000000000000.0) -> bool:
        ...
    @staticmethod
    def approx_compare_rects(r1: PySide2.QtCore.QRectF, r2: PySide2.QtCore.QRectF, precision: float = 1000000000000.0) -> bool:
        ...
class FileFormatType(shiboken2.Shiboken.Enum):
    Binary: typing.ClassVar[FileFormatType]  # value = axipy.cpp_common.FileFormatType.Binary
    Json: typing.ClassVar[FileFormatType]  # value = axipy.cpp_common.FileFormatType.Json
    Text: typing.ClassVar[FileFormatType]  # value = axipy.cpp_common.FileFormatType.Text
    Xml: typing.ClassVar[FileFormatType]  # value = axipy.cpp_common.FileFormatType.Xml
    values: typing.ClassVar[dict]  # value = {'Text': axipy.cpp_common.FileFormatType.Text, 'Binary': axipy.cpp_common.FileFormatType.Binary, 'Json': axipy.cpp_common.FileFormatType.Json, 'Xml': axipy.cpp_common.FileFormatType.Xml}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class HandlerAcceptor(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class Serializable(HandlerAcceptor):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create(type: str) -> Serializable:
        ...
    @staticmethod
    def version(type: str) -> int:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def class_id(self) -> str:
        ...
    def unmanaged_clone(self) -> Serializable:
        ...
class ShadowCalcMode(shiboken2.Shiboken.Enum):
    CalcCartesian: typing.ClassVar[ShadowCalcMode]  # value = axipy.cpp_common.ShadowCalcMode.CalcCartesian
    CalcModeDefault: typing.ClassVar[ShadowCalcMode]  # value = axipy.cpp_common.ShadowCalcMode.CalcModeDefault
    CalcOnEllipsoid: typing.ClassVar[ShadowCalcMode]  # value = axipy.cpp_common.ShadowCalcMode.CalcOnEllipsoid
    CalcOnSphere: typing.ClassVar[ShadowCalcMode]  # value = axipy.cpp_common.ShadowCalcMode.CalcOnSphere
    values: typing.ClassVar[dict]  # value = {'CalcCartesian': axipy.cpp_common.ShadowCalcMode.CalcCartesian, 'CalcOnSphere': axipy.cpp_common.ShadowCalcMode.CalcOnSphere, 'CalcOnEllipsoid': axipy.cpp_common.ShadowCalcMode.CalcOnEllipsoid, 'CalcModeDefault': axipy.cpp_common.ShadowCalcMode.CalcModeDefault}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class ShadowMemory(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def available(self) -> float:
        ...
    def free(self) -> float:
        ...
    def used(self) -> float:
        ...
class ShadowNestedException(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
Binary: FileFormatType  # value = axipy.cpp_common.FileFormatType.Binary
CalcCartesian: ShadowCalcMode  # value = axipy.cpp_common.ShadowCalcMode.CalcCartesian
CalcModeDefault: ShadowCalcMode  # value = axipy.cpp_common.ShadowCalcMode.CalcModeDefault
CalcOnEllipsoid: ShadowCalcMode  # value = axipy.cpp_common.ShadowCalcMode.CalcOnEllipsoid
CalcOnSphere: ShadowCalcMode  # value = axipy.cpp_common.ShadowCalcMode.CalcOnSphere
Json: FileFormatType  # value = axipy.cpp_common.FileFormatType.Json
Text: FileFormatType  # value = axipy.cpp_common.FileFormatType.Text
Xml: FileFormatType  # value = axipy.cpp_common.FileFormatType.Xml
