import axipy
from .observer import get_query_tables


class DialogTaskCustom(axipy.DialogTask):

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(self.run, *args, **kwargs)

    def run(self) -> None:
        self._close_tables()

    # noinspection PyBroadException
    def _close_tables(self) -> None:
        self.title = "Закрытие таблиц запросов"
        self.message = self.title

        n: int = len(tuple(get_query_tables()))
        self.max = n
        while any(get_query_tables()):
            if self.is_canceled:
                return None
            try:
                next(get_query_tables()).close()
            except Exception:
                continue
            finally:
                self.value += 1
                # Guard
                if self.value > n:
                    break
