import json
from pathlib import Path

from PySide2.QtCore import QObject
from osgeo import ogr, osr

from rosreestrXml.ui.tools.KPT.egrn_tool.add_helper.create_Materialized_Views import CreateMaterialized_Views
from rosreestrXml.ui.tools.KPT.egrn_tool.add_helper.json_db_obj import XmlDbStruct
from rosreestrXml.ui.tools.db_helper.dbRsc import DbRsc
from rosreestrXml.ui.tools.KPT.egrn_tool.extract_base_params_land import parse,parseString
def existLayer(ds,name_layer):
    layer=ds.GetLayerByName(name_layer)
    isExistLayer=False
    if layer is not None:
        isExistLayer=True
        layer=None
    return isExistLayer

def ExistTable(db,name_table):
    sql="select name from sqlite_master where type='table' and name='"+name_table+"'"
    rows=db.select(sql)
    if len(rows)==0:
        return False
    return True
def createTable(db,object_db,parent_table_name=None,dictionary_tables=None):
    print("Create Table:"+object_db['name'])

    sql_create="Create Table "+object_db['name']+" ("
    for field in object_db['fields']:
        #sql_create=sql_create+field['name']
        sql_field=field['name']
        if field['name']=='row_id':
            #sql_field=sql_field+" UNIQUEIDENTIFIER PRIMARY KEY "
            sql_field = sql_field + " INTEGER PRIMARY KEY "
            sql_create=sql_create+sql_field
            continue
        if parent_table_name is not None and field['name']=='parent_row_id':
            sql_field = sql_field + "  INTEGER REFERENCES "+parent_table_name+"([row_id]) "
            sql_create = sql_create +" , " +sql_field
            continue
        sql_field=","+field['name']+" "+field['type']
        sql_create = sql_create + sql_field
    if dictionary_tables is not None:
        for tab_dict in dictionary_tables:
            name_fk_key="fk_"+tab_dict['name'].lower()
            sql_field = name_fk_key + "  INTEGER REFERENCES " + tab_dict['name'] + "([row_id]) "
            sql_create = sql_create + " , " + sql_field
    sql_create=sql_create+")"
    isok=db.runSqlNoResult(sql_create)
    return

class EgrnImport(QObject):
    __name_base_tab='land_record'
    __name_process='основных характеристиках и зарегистрированных правах на объект недвижимости (земельный участок)'
    __name_contour_data='land_record_contour'
    __name_contour_points = 'land_record_contour_points'
    __base_tab = 'entity_spatial'
    __base_id = 'row_id'
    __children_table = 'ordinate'
    __name_parent_id = "parent_row_id"
    __name_view = 'view_land_record'
    __name_materirialzed_view = 'spatial_land_record'

    __name_geo = 'geom'

    def __init__(self,xml_source,property):
        super().__init__()
        self.__xml=xml_source
        self.__property=property
        self.__progress_counter=0
        self.__isCancel = False
    def setCancel(self):
        self.__isCancel=True
    def setPathOut(self,path_db):
        self.__path_db=path_db
    def setParentCls(self,parent_cls,curent_id):
        self.__parent_cls = parent_cls
        self.__curent_id_source=curent_id
    @property
    def NameTable(self):
        #if ExistTable(self.__db,self.__name_materirialzed_view):
        return self.__name_materirialzed_view
        #return None
    def run(self):
        self.__csl_struct=None
        self.__db_struct=None
        self.__db=DbRsc(self.__path_db)
        exist_table=ExistTable(self.__db,self.__name_base_tab)
        if not exist_table:
            isOk=self.__createStructDb()
        if self.__csl_struct is None:
            self.__csl_struct= XmlDbStruct(self.__db)
        if self.__db_struct is None:
            path_json = Path(__file__).parent.joinpath("teplate_db").joinpath(
                "struct_db_extract_base_params_land_v01.json")
            self.__db_struct = None
            with open(str(path_json), 'r', encoding='utf-8') as file:
                self.__db_struct = json.load(file)

        objEgrn = parseString(self.__xml, True)
        self.__csl_struct.loadToDb(self.__db_struct, objEgrn)
        self.__db.commit()
        self.__createSpatialData()
        if not ExistTable(self.__db,self.__name_view):
            slq_create_view='CREATE VIEW '+self.__name_view+' as select land_record.row_id as parent_row_id,land_record.special_notes,object_view.reg_date_by_doc,object_view.cad_number,object_view.quarter_cad_number,object_view.document_number,object_view.document_date,object_view.document_issuer,object_view.registration_date,object_view.number,object_view.right_number,object_view.reg_number,old_number.number as old_number_number,old_number.assignment_date,old_number.assigner,permitted_use_established.by_document,permittes_uses_grad_reg.reg_numb_border,permittes_uses_grad_reg.permitted_use_text,area.value,area.inaccuracy,address_view.note,address_view.readable_address,address_view.fias,address_view.okato,address_view.kladr,address_view.oktmo,address_view.postal_code,address_view.type_district,address_view.name_district,address_view.type_city,address_view.name_city,address_view.type_urban_district,address_view.name_urban_district,address_view.type_soviet_village,address_view.name__soviet_village,address_view.type_locality,address_view.name_locality,address_view.other,address_view.type_street,address_view.name_street,address_view.type_level1,address_view.name_level1,address_view.type_level2,address_view.name_level2,address_view.type_level3,address_view.name_level3,address_view.type_apartment,address_view.name_apartment,rel_position.in_boundaries_mark,rel_position.ref_point_name,rel_position.location_description,object_part_view.part_number,object_part_view.registration_date as object_part_registration_date,object_part_view.number as object_part_number,object_part_view.right_number as object_part_right_number,object_part_view.reg_number as object_part_reg_number,contour_view.number_pp,contour_view.cad_number as contour_cad_number,contour_view.sk_id,contour_view.geom,contour_view.mi_style from land_record LEFT JOIN (select object.row_id as parent_row_id,object.reg_date_by_doc,common_data.cad_number,common_data.quarter_cad_number,decision_attribute.document_number,decision_attribute.document_date,decision_attribute.document_issuer,data_registration.registration_date,restriction_encumbrance_number.number,restriction_encumbrance_number.right_number,reg_numb_border.reg_number from object LEFT JOIN common_data On object.row_id=common_data.parent_row_id LEFT JOIN decision_attribute On object.row_id=decision_attribute.parent_row_id LEFT JOIN data_registration On object.row_id=data_registration.parent_row_id LEFT JOIN restriction_encumbrance_number On object.row_id=restriction_encumbrance_number.parent_row_id LEFT JOIN reg_numb_border On object.row_id=reg_numb_border.parent_row_id) object_view On land_record.row_id=object_view.parent_row_id LEFT JOIN old_number On land_record.row_id=old_number.parent_row_id LEFT JOIN permitted_use_established On land_record.row_id=permitted_use_established.parent_row_id LEFT JOIN permittes_uses_grad_reg On land_record.row_id=permittes_uses_grad_reg.parent_row_id LEFT JOIN area On land_record.row_id=area.parent_row_id LEFT JOIN (select address.row_id as parent_row_id,address.note,address.readable_address,level_settlement.fias,level_settlement.okato,level_settlement.kladr,level_settlement.oktmo,level_settlement.postal_code,district.type_district,district.name_district,city.type_city,city.name_city,urban_district.type_urban_district,urban_district.name_urban_district,soviet_village.type_soviet_village,soviet_village.name__soviet_village,locality.type_locality,locality.name_locality,detailed_level.other,street.type_street,street.name_street,level1.type_level1,level1.name_level1,level2.type_level2,level2.name_level2,level3.type_level3,level3.name_level3,apartment.type_apartment,apartment.name_apartment from address LEFT JOIN level_settlement On address.row_id=level_settlement.parent_row_id LEFT JOIN district On address.row_id=district.parent_row_id LEFT JOIN city On address.row_id=city.parent_row_id LEFT JOIN urban_district On address.row_id=urban_district.parent_row_id LEFT JOIN soviet_village On address.row_id=soviet_village.parent_row_id LEFT JOIN locality On address.row_id=locality.parent_row_id LEFT JOIN detailed_level On address.row_id=detailed_level.parent_row_id LEFT JOIN street On address.row_id=street.parent_row_id LEFT JOIN level1 On address.row_id=level1.parent_row_id LEFT JOIN level2 On address.row_id=level2.parent_row_id LEFT JOIN level3 On address.row_id=level3.parent_row_id LEFT JOIN apartment On address.row_id=apartment.parent_row_id) address_view On land_record.row_id=address_view.parent_row_id LEFT JOIN rel_position On land_record.row_id=rel_position.parent_row_id LEFT JOIN (select object_part.row_id as parent_row_id,object_part.part_number,data_registration.registration_date,restriction_encumbrance_number.number,restriction_encumbrance_number.right_number,reg_numb_border.reg_number from object_part LEFT JOIN data_registration On object_part.row_id=data_registration.parent_row_id LEFT JOIN restriction_encumbrance_number On object_part.row_id=restriction_encumbrance_number.parent_row_id LEFT JOIN reg_numb_border On object_part.row_id=reg_numb_border.parent_row_id) object_part_view On land_record.row_id=object_part_view.parent_row_id LEFT JOIN (select contour.row_id as parent_row_id,contour.number_pp,contour.cad_number,entity_spatial_view.sk_id,entity_spatial_view.geom,entity_spatial_view.mi_style from contour LEFT JOIN (select entity_spatial.row_id as parent_row_id,entity_spatial.sk_id,land_record_contour.geom,land_record_contour.mi_style from entity_spatial LEFT JOIN land_record_contour On entity_spatial.row_id=land_record_contour.parent_row_id) entity_spatial_view On contour.row_id=entity_spatial_view.parent_row_id) contour_view On land_record.row_id=contour_view.parent_row_id'
            self.__db.runSqlNoResult(slq_create_view)
            self.__registerSpatialView()
            self.__db.commit()
        CreateMaterialized_Views(self.__db, self.__name_view, self.__name_materirialzed_view, self.__name_parent_id, self.__name_geo)
        #sql_setstyle="Update "+self.__name_materirialzed_view +" Set mi_style='"+self.__property['egrn']['contours']['style']+"'"
        #self.__db.runSqlNoResult(sql_setstyle)
        self.__db.close()
    def __createSpatialData(self):
        ds=ogr.Open(self.__path_db,1)
        srs=osr.SpatialReference()
        if self.__property['cs'].find("+proj")>=0:
            srs.ImportFromProj4(self.__property['cs'])
        else:
            srs.ImportFromWkt(self.__property['cs'])
        if not existLayer(ds,self.__name_contour_data):
            outLayer = ds.CreateLayer(self.__name_contour_data, srs, geom_type=ogr.wkbUnknown)
            idField = ogr.FieldDefn(self.__name_parent_id, ogr.OFTInteger)
            outLayer.CreateField(idField)
            miStyleField = ogr.FieldDefn("mi_style", ogr.OFTString)
            miStyleField.SetWidth(254)
            outLayer.CreateField(miStyleField)
        else:
            outLayer=ds.GetLayerByName(self.__name_contour_data)

        featureDefn = outLayer.GetLayerDefn()
        sql = 'select ' + self.__base_id + " from  " + self.__base_tab
        rows = self.__db.select(sql)
        for row in rows:
            self.updateProgressBar()
            id = row[0]
            sql_where = "where " + self.__name_parent_id + "=" + str(id)
            points = getArrayPoints(self.__db, self.__children_table, sql_where)
            type_geometry = ogr.wkbLineString
            if points[0]['x'] == points[-1]['x'] and points[0]['y'] == points[-1]['y']:
                type_geometry = ogr.wkbLinearRing
            geometry_out = ogr.Geometry(type_geometry)
            for point in points:
                if self.__property['reverseXY']:
                    geometry_out.AddPoint(point['y'], point['x'])
                else:
                    geometry_out.AddPoint(point['x'], point['y'])

            feature = ogr.Feature(featureDefn)
            feature.SetField(self.__name_parent_id, id)
            feature.SetField("mi_style",self.__property['egrn']['contours']['style'])
            if type_geometry == ogr.wkbLinearRing:
                geometry_polygon = ogr.Geometry(ogr.wkbPolygon)
                geometry_polygon.AddGeometry(geometry_out)
                feature.SetGeometry(geometry_polygon)
            else:
                feature.SetGeometry(geometry_out)
            outLayer.CreateFeature(feature)
            geometry_out = None
            geometry_polygon = None
            feature = None
        ds.FlushCache()
        ds.Destroy()
        ds = None

    @property
    def cs_in_xml(self):
        return None
    def __createStructDb(self):
        path_json=Path(__file__).parent.joinpath("teplate_db").joinpath("struct_db_extract_base_params_land_v01.json")
        self.__db_struct = None
        with open(str(path_json), 'r',encoding='utf-8') as file:
            self.__db_struct = json.load(file)
        if self.__db_struct is None:
            return False
        list_dictionary = ['Dict']
        self.__csl_struct = XmlDbStruct(self.__db,self.updateProgressBar)
        self.__csl_struct.dataFromXmlObj(self.__db_struct, None)
        return True
    def updateProgressBar(self):
        self.__progress_counter=self.__progress_counter+1
        if self.__progress_counter>=100:
            self.__progress_counter=0
        self.__parent_cls.updateProcess.emit(self.__curent_id_source/100,self.__progress_counter)
    def __registerSpatialView(self):
        sql="select table_name,data_type,identifier,description,min_x,min_y,max_x,max_y,srs_id from gpkg_contents where table_name='"+self.__name_contour_data+"'"
        rows=self.__db.select(sql)
        row=rows[0]
        lst_values=list(row)
        lst_values[0]='view_land_record'
        lst_values[2] = 'view_land_record'

        sql_insert="Insert Into gpkg_contents (table_name,data_type,identifier,description,min_x,min_y,max_x,max_y,srs_id) VALUES (?,?,?,?,?,?,?,?,?)"
        values=tuple(lst_values)
        self.__db.insert(sql_insert,values)
        sql="select * from gpkg_extensions"
        rows=self.__db.select(sql)
        lst_values=list(rows[0])
        lst_values[0]='view_land_record'
        sql_insert = "Insert Into gpkg_extensions (table_name,column_name,extension_name,definition,scope) VALUES (?,?,?,?,?)"
        values = tuple(lst_values)
        self.__db.insert(sql_insert, values)
        sql = "select * from gpkg_geometry_columns"
        rows = self.__db.select(sql)
        lst_values = list(rows[0])
        lst_values[0] = 'view_land_record'
        sql_insert = "Insert Into gpkg_geometry_columns (table_name,column_name,geometry_type_name,srs_id,z,m) VALUES (?,?,?,?,?,?)"
        values = tuple(lst_values)
        self.__db.insert(sql_insert, values)


def getArrayPoints(db,name_table,where_sql=None):
    sql="Select row_id,x,y from "+name_table
    if where_sql is not None:
        sql=sql+" "+where_sql
    rows=db.select(sql)
    values=[]
    for row in rows:
        values.append({'id':row[0],'x':row[1],'y':row[2]})
    return values
def FactoryEgrnNew(xml_source,propery):
    return EgrnImport(xml_source,propery)
