import os

import axipy
from axipy import menubar, tr

from createFromSelection.ui.tools.helper_observers.observersFactory import factoryObserverCreatePolyline, \
    factoryObserverCreatePolygon
from createFromSelection.ui.tools.map_tools import createObject


class CreatePolygon:
    __name = 'Создание полигона'
    __name_observer_base = 'DataForCreatePolyline'
    __name_observer = 'DataForCreatePolygon'
    def __init__(self,parent_class_plugin):
        self.__parent_cls_plugin=parent_class_plugin
        self.__observer_base=factoryObserverCreatePolyline(self.__name_observer_base)
        self.__observer = factoryObserverCreatePolygon(self.__name_observer,self.__observer_base)
        local_file_icon = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'icons', 'create_polygon_32_32.png')
        self.__action = self.__parent_cls_plugin.create_action('Создание полигона',
                                           icon=local_file_icon,
                                           on_click=self.run_tools, enable_on=self.__name_observer)
        self.__parent_cls_plugin.position = menubar.get_position(tr(self.__parent_cls_plugin.NameTab),tr(self.__parent_cls_plugin.NameGroup))
        self.__parent_cls_plugin.position.add(self.__action, size=2)
    def unload(self):
        axipy.ObserverManager.remove(self.__name_observer)
        self.__action.remove()
    def run_tools(self):
        createObject(axipy.GeometryType.Polygon)