import os
import site
import traceback

from ._get_app_data import (
    _get_axioma_python_dependencies_location,
    _get_plugins_python_dependencies_location,
)
from ._setup_utils import (
    _ensure_first_sys_path,
    _ensure_venv_site_packages,
    _is_running_from_venv,
)


# noinspection PyBroadException
def _add_dependencies_to_pythonpath() -> None:
    """
    Функция добавляет папку с зависимыми модулями в PYTHONPATH и регистрирует ее как site директорию.
    (В site директории, все файлы *.pth используются для расширения PYTHONPATH).
    """
    deps_folder = _get_axioma_python_dependencies_location()

    try:
        if not deps_folder.is_dir():  # also checks exists
            deps_folder.mkdir(parents=True, exist_ok=True)
    except PermissionError:
        pass
    except Exception:
        traceback.print_exc()

    deps_folder_str = str(deps_folder)

    _ensure_first_sys_path(deps_folder)
    site.addsitedir(deps_folder_str)

    site.addsitedir(str(_get_plugins_python_dependencies_location()))

    if not _is_running_from_venv():
        os.environ["PIP_TARGET"] = str(deps_folder)
    else:
        _ensure_venv_site_packages()
