import configparser
from pathlib import Path
import os


def _get_writable_app_data_location() -> Path:
    # импорт должен быть локальным
    from PySide2.QtCore import QStandardPaths, QDir
    app_data_location = QStandardPaths.writableLocation(QStandardPaths.AppDataLocation)
    if app_data_location == "":
        raise RuntimeError("app_data_location cannot be determined.")
    app_data_location = QDir(app_data_location).absolutePath()
    return Path(app_data_location)


def _get_axioma_version_from_config() -> str:
    config = configparser.ConfigParser()
    config.read(Path(__file__).parent / "sitecustomize.ini")
    axioma_major_version = config["DEFAULT"]["axioma_major_version"]
    return axioma_major_version


def _get_axioma_app_data_location() -> Path:
    app_data_location = _get_writable_app_data_location()
    if app_data_location.name != "Axioma.GIS":
        app_data_location = app_data_location / "ESTI" / "Axioma.GIS"
    axioma_version = _get_axioma_version_from_config()
    return app_data_location / f"v{axioma_version}"


def _get_axioma_python_dependencies_location() -> Path:
    axioma_app_data_location = _get_axioma_app_data_location()
    return axioma_app_data_location / "installed_modules" / "dependencies" / "site-packages"


def _get_plugins_python_dependencies_location() -> Path:
    return Path(os.environ["AXIOMA_HOME"]) / "python_plugins_deps" / "site-packages"
