from enum import Enum
from typing import List

from axipy.cpp_gui import ShadowNotifications

__all__: List[str] = [
    "Notifications",
]


class Notifications(int, Enum):
    """Отправление уведомлений в виде всплывающего окна с его последующей регистрацией в
    окне уведомлений."""

    Information = 0
    """
    Информационное сообщение.

    Устанавливается по умолчанию.
    """
    Warning = 1
    """Предупреждение."""
    Critical = 2
    """Критическая ошибка."""
    Success = 3
    """Успешное выполнение процесса."""

    @staticmethod
    def push(
        title: str,
        text: str,
        type_message: "Notifications" = Information,  # type: ignore
    ) -> None:
        """
        Отправляет уведомление.

        Args:
            title: Заголовок
            text: Текст сообщения.
            type_message: Тип сообщения. В зависимости от типа сообщения в окне уведомлений оно помечается соответствующим цветом.

        Пример::

            import axipy

            axipy.Notifications.push('Предупреждение', 'Сообщение', axipy.Notifications.Warning)
        """

        return ShadowNotifications.push(title, text, type_message)
