from typing import List, Optional

from axipy._internal._shadow_instance_factory import _shadow_manager
from axipy.cpp_core_dp import ShadowDataCatalog
from axipy.cpp_gui import ShadowGui
from PySide2.QtSql import QSqlDatabase

__all__: List[str] = [
    "gui_instance",
]


class GuiClass:

    def __init__(self) -> None:
        self.__shadow: Optional[ShadowGui] = None

    @property
    def _shadow(self) -> ShadowGui:
        if not self.__shadow:
            self.__shadow = _shadow_manager.gui
        return self.__shadow

    def _is_initialized(self) -> bool:
        return self.__shadow is not None

    def _initialize(self) -> None:
        self.__shadow = ShadowGui.create()
        self.__shadow.initialize()

    def database(self) -> QSqlDatabase:
        return self._shadow.database()

    def _cpp_catalog(self) -> ShadowDataCatalog:
        return self._shadow.catalog()


gui_instance = GuiClass()
