import warnings
from typing import Any, Final, List, Optional, Union

from axipy._internal._shadow_instance_factory import _shadow_manager
from axipy.cpp_core_core import DefaultKeys as DefaultKeys_
from axipy.cpp_core_core import (
    StateObserver,
    ValueObserver,
)

__all__: List[str] = []


class DefaultKeys(DefaultKeys_):
    """
    Warning:
    .. deprecated:: 5.0
        Используйте axipy.ObserverManager

    """

    # backwards compatibility
    Widget = DefaultKeys_.ActiveView
    MapView = DefaultKeys_.ActiveMapView
    TableView = DefaultKeys_.ActiveTableView


class StateManager(DefaultKeys):
    """
    Warning:
    .. deprecated:: 5.0
        Используйте axipy.ObserverManager

    """

    DEPRECATED_MESSAGE: Final[str] = "'axipy.state_manager' is deprecated, use class 'axipy.observer_manager' instead."

    @property
    def instance(self) -> StateObserver:
        """
        Warning:
        .. deprecated:: 5.0
            Используйте axipy.ObserverManager

        """
        warnings.warn(self.DEPRECATED_MESSAGE, DeprecationWarning, stacklevel=2)
        return _shadow_manager.state_observer

    def get(self, id: Union[str, DefaultKeys]) -> ValueObserver:
        """
        Warning:
        .. deprecated:: 5.0
            Используйте axipy.ObserverManager

        """
        warnings.warn(self.DEPRECATED_MESSAGE, DeprecationWarning, stacklevel=2)
        id = self._to_name(id)
        return self.instance.get(id)

    def find(self, id: Union[str, DefaultKeys]) -> Optional[ValueObserver]:
        """
        Warning:
        .. deprecated:: 5.0
            Используйте axipy.ObserverManager

        """
        warnings.warn(self.DEPRECATED_MESSAGE, DeprecationWarning, stacklevel=2)
        id = self._to_name(id)
        return self.instance.find(id)

    def create(self, id: str, init_value: Optional[Any] = None) -> ValueObserver:
        """
        Warning:
        .. deprecated:: 5.0
            Используйте axipy.ObserverManager

        """
        warnings.warn(self.DEPRECATED_MESSAGE, DeprecationWarning, stacklevel=2)
        return self.instance.create(id, init_value)

    def _to_name(self, key: Union[str, DefaultKeys, None]) -> str:
        if key is None or type(key) is str:
            return key
        return DefaultKeys.names()[key]


state_manager = StateManager()


def _apply_deprecated() -> None:
    # Using getattr to hide deprecated objects from axipy namespace on IDE inspections
    getattr(__all__, "extend")(
        (
            "DefaultKeys",
            "StateManager",
            "ValueObserver",
            "state_manager",
        )
    )


_apply_deprecated()
