from typing import List, NoReturn, Optional

from axipy.da.data_object import DataObject

from .data_provider import DataProvider
from .source import Source

__all__: List[str] = [
    "SvgSource",
    "SvgDataProvider",
]


class SvgSource(Source):
    pass


class SvgDataProvider(DataProvider):
    """
    Провайдер для SVG.

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.provider_manager.excel`.
    """

    @staticmethod
    def _identifier() -> str:
        return "SvgDataProvider"

    def get_source(self, data: str, alias: Optional[str] = None) -> Source:
        """
        Создает источник данных.

        Args:
          data: Имя файла или описание источника данных.
          alias: Псевдоним для открываемой таблицы.
        """
        return SvgSource(Source._provider(self.id), Source._alias(alias), {"src": data})

    def open(self, data: str, alias: Optional[str] = None) -> DataObject:
        """
        Открывает объект данных.

        Args:
          data: Имя файла или описание источника данных.
          alias: Псевдоним для открываемой таблицы.
        """
        return self.get_source(data, alias).open()

    def get_destination(self) -> NoReturn:
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError

    def create_open(self) -> NoReturn:
        """
        Attention:
            Не поддерживается.

        Raises:
            NotImplementedError
        """
        raise NotImplementedError
