from typing import List, Type

from .dbms_data_provider import DatabaseDataProvider
from .source import Destination, Source

__all__: List[str] = [
    "MsSqlSource",
    "MsSqlDestination",
    "MsSqlDataProvider",
]


class MsSqlSource(Source):
    pass


class MsSqlDestination(Destination):
    pass


class MsSqlDataProvider(DatabaseDataProvider):
    """
    Провайдер для Базы Данных MSSQLServer.

    Пример с указанием имени таблицы::

        definition = provider_manager.mssql.get_source('localhost', 'test', 'sa', 'sa', dataobject='world')
        table = provider_manager.open(definition)

    Пример с указанием текста запроса::

        definition = provider_manager.mssql.get_source('localhost', 'test', 'sa', 'sa', sql="select * from world where Страна like 'Р%'")
        table = provider_manager.open(definition)

    Note:
        Для работы с СУБД `Microsoft SQL Server` необходимо скачать и установить `Microsoft
        SQL Server Native Client`.

        См. Руководство по установке и активации.

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.provider_manager.mssql`.
    """

    @staticmethod
    def _identifier() -> str:
        return "MsSqlDataProvider"

    DEFAULT_PORT = 1433
    """Порт по умолчанию."""

    @property
    def _get_source_class(self) -> Type[MsSqlSource]:
        return MsSqlSource

    @property
    def _get_destination_class(self) -> Type[MsSqlDestination]:
        return MsSqlDestination
