import typing
from typing import ForwardRef
import PySide2.QtCore
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_common
QJsonValue = typing.Any

__all__ = ['ShadowAreaUnit', 'ShadowCoordSysFactory', 'ShadowCoordSystem', 'ShadowCoordinateTransformer', 'ShadowLinearUnit', 'ShadowUnit']
class ShadowAreaUnit(ShadowUnit):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def acre() -> ShadowAreaUnit:
        ...
    @staticmethod
    def hectare() -> ShadowAreaUnit:
        ...
    @staticmethod
    def perch() -> ShadowAreaUnit:
        ...
    @staticmethod
    def rood() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_centimeter() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_chain() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_foot() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_inch() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_kilometer() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_link() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_meter() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_mile() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_millimeter() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_nautical_mile() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_rod() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_usFoot() -> ShadowAreaUnit:
        ...
    @staticmethod
    def sq_yard() -> ShadowAreaUnit:
        ...
class ShadowCoordSysFactory(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def current_cs(self) -> ShadowCoordSystem:
        ...
    def fromEpsg(self, code: int) -> ShadowCoordSystem:
        ...
    def fromPrj(self, prj: str) -> ShadowCoordSystem:
        ...
    def fromProj(self, proj: str) -> ShadowCoordSystem:
        ...
    def fromSrid(self, code: int) -> ShadowCoordSystem:
        ...
    def fromString(self, csString: str) -> ShadowCoordSystem:
        ...
    def fromUnits(self, unit: ShadowLinearUnit, rect: PySide2.QtCore.QRectF = {}) -> ShadowCoordSystem:
        ...
    def fromWkt(self, wkt: str) -> ShadowCoordSystem:
        ...
    def set_current_cs(self, cs: ShadowCoordSystem) -> None:
        ...
    def toEpsg(self, crs: ShadowCoordSystem) -> int:
        ...
    def toPrj(self, crs: ShadowCoordSystem) -> str:
        ...
    def toProj(self, crs: ShadowCoordSystem) -> str:
        ...
    def toWgs84Params(self, crs: ShadowCoordSystem) -> typing.List[float]:
        ...
    def toWkt(self, crs: ShadowCoordSystem) -> str:
        ...
    def toWktEx(self, crs: ShadowCoordSystem, params: typing.Dict[str, QJsonValue]) -> str:
        ...
class ShadowCoordSystem(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def from_degree(*args, **kwargs):
        ...
    @staticmethod
    def to_degree(*args, **kwargs):
        ...
    def __copy__(self) -> ShadowCoordSystem:
        ...
    def __deepcopy__(self, memodict: typing.Dict[str, QJsonValue]) -> ShadowCoordSystem:
        ...
    def calc_mode(self) -> axipy.cpp_common.ShadowCalcMode:
        ...
    def calc_modes(self) -> typing.List[axipy.cpp_common.ShadowCalcMode]:
        ...
    def clone(self) -> ShadowCoordSystem:
        ...
    def default_rect(self) -> PySide2.QtCore.QRectF:
        ...
    def description(self) -> str:
        ...
    def get_str(self) -> str:
        ...
    def inv_flattening(self) -> float:
        ...
    def isEmpty(self) -> bool:
        ...
    def isEqual(self, other: ShadowCoordSystem, ignoreRect: bool) -> bool:
        ...
    def is_lat_lon(self) -> bool:
        ...
    def is_non_earth(self) -> bool:
        ...
    def name(self) -> str:
        ...
    def rect(self) -> PySide2.QtCore.QRectF:
        ...
    def semi_major(self) -> float:
        ...
    def semi_minor(self) -> float:
        ...
    def setRect(self, rect: PySide2.QtCore.QRectF) -> None:
        ...
    def to_mgrs(self, p: PySide2.QtCore.QPointF, precision: int) -> str:
        ...
    def unit(self) -> ShadowLinearUnit:
        ...
class ShadowCoordinateTransformer(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def proj_transform_definition(cs_from: str, cs_to: str) -> str:
        ...
    @staticmethod
    def transform(*args, **kwargs):
        ...
class ShadowLinearUnit(ShadowUnit):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def centimeter() -> ShadowLinearUnit:
        ...
    @staticmethod
    def chain() -> ShadowLinearUnit:
        ...
    @staticmethod
    def degree() -> ShadowLinearUnit:
        ...
    @staticmethod
    def foot() -> ShadowLinearUnit:
        ...
    @staticmethod
    def inch() -> ShadowLinearUnit:
        ...
    @staticmethod
    def kilometer() -> ShadowLinearUnit:
        ...
    @staticmethod
    def link() -> ShadowLinearUnit:
        ...
    @staticmethod
    def meter() -> ShadowLinearUnit:
        ...
    @staticmethod
    def mile() -> ShadowLinearUnit:
        ...
    @staticmethod
    def millimeter() -> ShadowLinearUnit:
        ...
    @staticmethod
    def nautical_mile() -> ShadowLinearUnit:
        ...
    @staticmethod
    def rod() -> ShadowLinearUnit:
        ...
    @staticmethod
    def usFoot() -> ShadowLinearUnit:
        ...
    @staticmethod
    def yard() -> ShadowLinearUnit:
        ...
class ShadowUnit(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def conversion(*args, **kwargs):
        ...
    def description(self) -> str:
        ...
    def localized_name(self) -> str:
        ...
    def name(self) -> str:
        ...
