import typing
from typing import ForwardRef
import PySide2.QtCore
import PySide2.QtGui
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_common
import axipy.cpp_cs
import typing
QJsonValue = typing.Any

__all__ = ['Linear', 'MultiGeometry', 'Point', 'Polygonal', 'ShadowArc', 'ShadowCollection', 'ShadowCollectionStyle', 'ShadowEllipse', 'ShadowFillStyle', 'ShadowGeometry', 'ShadowLine', 'ShadowLineString', 'ShadowLineStyle', 'ShadowLinearRing', 'ShadowMultiLineString', 'ShadowMultiPoint', 'ShadowMultiPolygon', 'ShadowPoint', 'ShadowPointCompatStyle', 'ShadowPointFontStyle', 'ShadowPointPictureStyle', 'ShadowPointStyle', 'ShadowPointsLS', 'ShadowPolygon', 'ShadowPolygonStyle', 'ShadowRectangle', 'ShadowRoundRectangle', 'ShadowStyle', 'ShadowText', 'ShadowTextStyle', 'ShadowTextStyleEffects', 'StyleGeometryType', 'Text', 'Type']
class ShadowArc(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def center(self) -> PySide2.QtCore.QPointF:
        ...
    def endAngle(self) -> float:
        ...
    def setCenter(self, point: PySide2.QtCore.QPointF) -> None:
        ...
    def setEndAngle(self, a: float) -> None:
        ...
    def setStartAngle(self, a: float) -> None:
        ...
    def setXRadius(self, r: float) -> None:
        ...
    def setYRadius(self, r: float) -> None:
        ...
    def startAngle(self) -> float:
        ...
    def xRadius(self) -> float:
        ...
    def yRadius(self) -> float:
        ...
class ShadowCollection(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def at(g: ShadowGeometry, idx: int) -> ShadowGeometry:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def append(self, g: ShadowGeometry) -> None:
        ...
    def count(self) -> int:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set(self, idx: int, g: ShadowGeometry) -> None:
        ...
class ShadowCollectionStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def for_line(self, s: ShadowLineStyle) -> None:
        ...
    def for_point(self, s: ShadowPointStyle) -> None:
        ...
    def for_polygon(self, s: ShadowPolygonStyle) -> None:
        ...
    def for_text(self, s: ShadowTextStyle) -> None:
        ...
    def line(self) -> ShadowStyle:
        ...
    def point(self) -> ShadowStyle:
        ...
    def polygon(self) -> ShadowStyle:
        ...
    def style(self, geom: ShadowGeometry) -> ShadowStyle:
        ...
    def text(self) -> ShadowStyle:
        ...
class ShadowEllipse(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def center(self) -> PySide2.QtCore.QPointF:
        ...
    def majorSemiAxis(self) -> float:
        ...
    def minorSemiAxis(self) -> float:
        ...
    def setCenter(self, point: PySide2.QtCore.QPointF) -> None:
        ...
    def setMajorSemiAxis(self, len: float) -> None:
        ...
    def setMinorSemiAxis(self, len: float) -> None:
        ...
class ShadowFillStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_bg_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_pattern(self) -> int:
        ...
    def set_bg_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_pattern(self, p: int) -> None:
        ...
class ShadowGeometry(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def affine_transform(obj: ShadowGeometry, trans: PySide2.QtGui.QTransform) -> ShadowGeometry:
        ...
    @staticmethod
    def boundary(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def buffer(obj: ShadowGeometry, distance: float, resolution: int = 16, capStyle: int = 1, joinStyle: int = 1, mitre_limit: float = 5.0) -> ShadowGeometry:
        ...
    @staticmethod
    def centroid(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def clone(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def convertFromLineStringsToPolygons(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def convertGeometryToJson(obj: ShadowGeometry) -> str:
        ...
    @staticmethod
    def convertToMultiLineString(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def convex_hull(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def difference(obj1: ShadowGeometry, obj2: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def distance_by_points(from_: PySide2.QtCore.QPointF, to: PySide2.QtCore.QPointF, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> typing.Tuple[float, float]:
        ...
    @staticmethod
    def envelope(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def from_wkb(wkb: bytes, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> ShadowGeometry:
        ...
    @staticmethod
    def from_wkt(wkt: str, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> ShadowGeometry:
        ...
    @staticmethod
    def geometryFromJson(json: str, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> ShadowGeometry:
        ...
    @staticmethod
    def geometryFromMif(mif: str) -> ShadowGeometry:
        ...
    @staticmethod
    def geometryToMif(obj: ShadowGeometry) -> str:
        ...
    @staticmethod
    def intersection(obj1: ShadowGeometry, obj2: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def normalize(obj: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def point_by_azimuth(start: PySide2.QtCore.QPointF, azimuth: float, distance: float, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> PySide2.QtCore.QPointF:
        ...
    @staticmethod
    def polyline_split(obj: ShadowGeometry, splitter: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def reproject(obj: ShadowGeometry, cs: axipy.cpp_cs.ShadowCoordSystem) -> ShadowGeometry:
        ...
    @staticmethod
    def rotate(obj: ShadowGeometry, center: PySide2.QtCore.QPointF, degrees: float) -> ShadowGeometry:
        ...
    @staticmethod
    def round(obj: ShadowGeometry, precision: int) -> ShadowGeometry:
        ...
    @staticmethod
    def snap(input: ShadowGeometry, target: ShadowGeometry, tolerance: float) -> ShadowGeometry:
        ...
    @staticmethod
    def symmetric_difference(obj1: ShadowGeometry, obj2: ShadowGeometry) -> ShadowGeometry:
        ...
    @staticmethod
    def union(obj1: ShadowGeometry, obj2: ShadowGeometry) -> ShadowGeometry:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def almost_equals(self, other: ShadowGeometry, tolerance: float) -> bool:
        ...
    def area(self, calcMode: axipy.cpp_common.ShadowCalcMode, unit: typing.Union[axipy.cpp_cs.ShadowAreaUnit, None] = None) -> float:
        ...
    def bounds(self) -> PySide2.QtCore.QRectF:
        ...
    def contains(self, other: ShadowGeometry) -> bool:
        ...
    def covers(self, other: ShadowGeometry) -> bool:
        ...
    def crosses(self, other: ShadowGeometry) -> bool:
        ...
    def cs(self) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def disjoint(self, other: ShadowGeometry) -> bool:
        ...
    def distance(self, other: ShadowGeometry, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> float:
        ...
    def equals(self, other: ShadowGeometry) -> bool:
        ...
    def id(self) -> str:
        ...
    def intersects(self, other: ShadowGeometry) -> bool:
        ...
    def is_valid(self) -> bool:
        ...
    def is_valid_reason(self) -> str:
        ...
    def length(self, calcMode: axipy.cpp_common.ShadowCalcMode, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> float:
        ...
    def name(self) -> str:
        ...
    def overlaps(self, other: ShadowGeometry) -> bool:
        ...
    def perimeter(self, calcMode: axipy.cpp_common.ShadowCalcMode, unit: typing.Union[axipy.cpp_cs.ShadowLinearUnit, None] = None) -> float:
        ...
    def relate(self, other: ShadowGeometry) -> str:
        ...
    def set_cs(self, cs: typing.Union[axipy.cpp_cs.ShadowCoordSystem, None] = None) -> None:
        ...
    def toVariant(self) -> typing.Any:
        ...
    def to_wkb(self) -> bytes:
        ...
    def to_wkt(self) -> str:
        ...
    def touches(self, other: ShadowGeometry) -> bool:
        ...
    def type(self) -> Type:
        ...
    def within(self, other: ShadowGeometry) -> bool:
        ...
class ShadowLine(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_begin(self) -> PySide2.QtCore.QPointF:
        ...
    def get_end(self) -> PySide2.QtCore.QPointF:
        ...
    def set_begin(self, p: PySide2.QtCore.QPointF) -> None:
        ...
    def set_end(self, p: PySide2.QtCore.QPointF) -> None:
        ...
class ShadowLineString(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_clockwise(self) -> bool:
        ...
    def is_closed(self) -> bool:
        ...
    def set_clockwise(self, v: bool) -> None:
        ...
class ShadowLineStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def convert_pattern_file(in_filename: str, in_format: axipy.cpp_common.FileFormatType, out_filename: str, out_format: axipy.cpp_common.FileFormatType) -> None:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_pattern(self) -> int:
        ...
    def get_width(self) -> int:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_pattern(self, p: int) -> None:
        ...
    def set_width(self, v: int) -> None:
        ...
    def to_file(self, filename: str, format: axipy.cpp_common.FileFormatType) -> None:
        ...
    def to_string(self, format: axipy.cpp_common.FileFormatType) -> str:
        ...
class ShadowLinearRing(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
class ShadowMultiLineString(ShadowCollection):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def append(self, g: ShadowGeometry) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set(self, idx: int, g: ShadowGeometry) -> None:
        ...
class ShadowMultiPoint(ShadowCollection):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def append(self, g: ShadowGeometry) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set(self, idx: int, g: ShadowGeometry) -> None:
        ...
class ShadowMultiPolygon(ShadowCollection):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def append(self, g: ShadowGeometry) -> None:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set(self, idx: int, g: ShadowGeometry) -> None:
        ...
class ShadowPoint(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_pos(self) -> PySide2.QtCore.QPointF:
        ...
    def set_pos(self, p: PySide2.QtCore.QPointF) -> None:
        ...
class ShadowPointCompatStyle(ShadowPointStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_point_size(self) -> int:
        ...
    def get_symbol(self) -> int:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_point_size(self, v: int) -> None:
        ...
    def set_symbol(self, v: int) -> None:
        ...
class ShadowPointFontStyle(ShadowPointStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_bold(self) -> bool:
        ...
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_font_name(self) -> str:
        ...
    def get_outline(self) -> int:
        ...
    def get_point_size(self) -> int:
        ...
    def get_shadow(self) -> bool:
        ...
    def get_symbol(self) -> int:
        ...
    def rotation(self) -> float:
        ...
    def set_bold(self, v: bool) -> None:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_font_name(self, n: str) -> None:
        ...
    def set_outline(self, v: int) -> None:
        ...
    def set_point_size(self, v: int) -> None:
        ...
    def set_rotation(self, v: float) -> None:
        ...
    def set_shadow(self, v: bool) -> None:
        ...
    def set_symbol(self, v: int) -> None:
        ...
class ShadowPointPictureStyle(ShadowPointStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_actual_size(self) -> bool:
        ...
    def get_apply_color(self) -> bool:
        ...
    def get_color(self) -> PySide2.QtGui.QColor:
        ...
    def get_filename(self) -> str:
        ...
    def get_point_size(self) -> int:
        ...
    def get_show_background(self) -> bool:
        ...
    def set_actual_size(self, v: bool) -> None:
        ...
    def set_apply_color(self, v: bool) -> None:
        ...
    def set_color(self, c: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_filename(self, f: str) -> None:
        ...
    def set_point_size(self, v: int) -> None:
        ...
    def set_show_background(self, b: bool) -> None:
        ...
class ShadowPointStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def create_mi_compat(symbol: int, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], pointSize: int) -> ShadowStyle:
        ...
    @staticmethod
    def create_mi_font(symbol: int, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], size: int, fontname: str, fontstyle: int, rotation: float) -> ShadowStyle:
        ...
    @staticmethod
    def create_mi_picture(filename: str, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor], size: int, customstyle: int) -> ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowPointsLS(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def append(self, p: PySide2.QtCore.QPointF) -> None:
        ...
    def at(self, idx: int) -> PySide2.QtCore.QPointF:
        ...
    def count(self) -> int:
        ...
    def get_clockwise(self) -> bool:
        ...
    def get_determinant(self) -> float:
        ...
    def insert(self, idx: int, p: PySide2.QtCore.QPointF) -> None:
        ...
    def pop(self, idx: int) -> PySide2.QtCore.QPointF:
        ...
    def remove(self, idx: int) -> None:
        ...
    def set(self, idx: int, p: PySide2.QtCore.QPointF) -> None:
        ...
    def set_clockwise(self, v: bool) -> None:
        ...
class ShadowPolygon(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def addInterior(self, points: typing.List[PySide2.QtCore.QPointF]) -> None:
        ...
    def exterior(self) -> ShadowLinearRing:
        ...
    def get_clockwise(self) -> bool:
        ...
    def interior(self, idx: int) -> ShadowLinearRing:
        ...
    def interiorCount(self) -> int:
        ...
    def removeInterior(self, idx: int) -> None:
        ...
    def set_clockwise(self, v: bool) -> None:
        ...
class ShadowPolygonStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_border(self) -> ShadowStyle:
        ...
    def get_fill(self) -> ShadowStyle:
        ...
    def set_brush(self, pattern: int = 1, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor] = ..., bgColor: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor] = ...) -> None:
        ...
    def set_pen(self, pattern: int = 2, color: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor] = ..., width: int = 1) -> None:
        ...
class ShadowRectangle(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def get_rect(self) -> PySide2.QtCore.QRectF:
        ...
    def set_rect(self, r: PySide2.QtCore.QRectF) -> None:
        ...
class ShadowRoundRectangle(ShadowRectangle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def setXRadius(self, r: float) -> None:
        ...
    def setYRadius(self, r: float) -> None:
        ...
    def xRadius(self) -> float:
        ...
    def yRadius(self) -> float:
        ...
class ShadowStyle(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def for_geometry(geom: ShadowGeometry) -> ShadowStyle:
        ...
    @staticmethod
    def for_geometry_current(geom: ShadowGeometry) -> ShadowStyle:
        ...
    @staticmethod
    def from_mapinfo(miString: str) -> ShadowStyle:
        ...
    @staticmethod
    def get_for_collection() -> ShadowStyle:
        ...
    @staticmethod
    def get_for_line() -> ShadowStyle:
        ...
    @staticmethod
    def get_for_point() -> ShadowStyle:
        ...
    @staticmethod
    def get_for_polygon() -> ShadowStyle:
        ...
    @staticmethod
    def get_for_text() -> ShadowStyle:
        ...
    @staticmethod
    def update_current_style(style: ShadowStyle) -> None:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def clone(self) -> ShadowStyle:
        ...
    def draw(self, geom: ShadowGeometry, painter: PySide2.QtGui.QPainter) -> None:
        ...
    def isEmpty(self) -> bool:
        ...
    def isEqual(self, other: ShadowStyle) -> bool:
        ...
    def toVariant(self) -> typing.Any:
        ...
    def to_mapinfo(self) -> str:
        ...
    def to_ogr(self) -> str:
        ...
class ShadowText(ShadowGeometry):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def angle(self) -> float:
        ...
    def as_polygon(self) -> PySide2.QtGui.QPolygonF:
        ...
    def endPoint(self) -> PySide2.QtCore.QPointF:
        ...
    def equals(self, other: ShadowGeometry) -> bool:
        ...
    def height(self) -> float:
        ...
    def setAngle(self, value: float) -> None:
        ...
    def setEndPoint(self, point: PySide2.QtCore.QPointF) -> None:
        ...
    def setRect(self, r: PySide2.QtCore.QRectF) -> None:
        ...
    def setStartPoint(self, point: PySide2.QtCore.QPointF) -> None:
        ...
    def setText(self, text: str) -> None:
        ...
    def startPoint(self) -> PySide2.QtCore.QPointF:
        ...
    def text(self) -> str:
        ...
    def width(self) -> float:
        ...
class ShadowTextStyle(ShadowStyle):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def get_lineStyle(s: ShadowTextStyle) -> ShadowStyle:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def alignment(self) -> PySide2.QtCore.Qt.AlignmentFlag:
        ...
    def bg_color(self) -> PySide2.QtGui.QColor:
        ...
    def bg_type(self) -> int:
        ...
    def bold(self) -> bool:
        ...
    def capital(self) -> bool:
        ...
    def color(self) -> PySide2.QtGui.QColor:
        ...
    def effects(self) -> ShadowTextStyleEffects:
        ...
    def font_family(self) -> str:
        ...
    def font_size(self) -> float:
        ...
    def get_callout(self) -> int:
        ...
    def italic(self) -> bool:
        ...
    def set_alignment(self, v: PySide2.QtCore.Qt.AlignmentFlag) -> None:
        ...
    def set_bg_color(self, v: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_bg_type(self, v: int) -> None:
        ...
    def set_bold(self, v: bool) -> None:
        ...
    def set_callout(self, v: int) -> None:
        ...
    def set_capital(self, v: bool) -> None:
        ...
    def set_color(self, v: typing.Union[PySide2.QtGui.QColor, PySide2.QtGui.Qt.GlobalColor]) -> None:
        ...
    def set_font_family(self, v: str) -> None:
        ...
    def set_font_size(self, v: float) -> None:
        ...
    def set_italic(self, v: bool) -> None:
        ...
    def set_lineStyle(self, v: ShadowLineStyle) -> None:
        ...
    def set_shadow(self, v: bool) -> None:
        ...
    def set_spacing(self, v: bool) -> None:
        ...
    def set_underline(self, v: bool) -> None:
        ...
    def shadow(self) -> bool:
        ...
    def spacing(self) -> bool:
        ...
    def underline(self) -> bool:
        ...
class ShadowTextStyleEffects(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
class StyleGeometryType(shiboken2.Shiboken.Enum):
    Linear: typing.ClassVar[StyleGeometryType]  # value = axipy.cpp_core_geometry.StyleGeometryType.Linear
    MultiGeometry: typing.ClassVar[StyleGeometryType]  # value = axipy.cpp_core_geometry.StyleGeometryType.MultiGeometry
    Point: typing.ClassVar[StyleGeometryType]  # value = axipy.cpp_core_geometry.StyleGeometryType.Point
    Polygonal: typing.ClassVar[StyleGeometryType]  # value = axipy.cpp_core_geometry.StyleGeometryType.Polygonal
    Text: typing.ClassVar[StyleGeometryType]  # value = axipy.cpp_core_geometry.StyleGeometryType.Text
    values: typing.ClassVar[dict]  # value = {'Point': axipy.cpp_core_geometry.StyleGeometryType.Point, 'Linear': axipy.cpp_core_geometry.StyleGeometryType.Linear, 'Polygonal': axipy.cpp_core_geometry.StyleGeometryType.Polygonal, 'MultiGeometry': axipy.cpp_core_geometry.StyleGeometryType.MultiGeometry, 'Text': axipy.cpp_core_geometry.StyleGeometryType.Text}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class Type(shiboken2.Shiboken.Enum):
    Arc: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Arc
    Ellipse: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Ellipse
    GeometryCollection: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.GeometryCollection
    Line: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Line
    LineString: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.LineString
    MultiLineString: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.MultiLineString
    MultiPoint: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.MultiPoint
    MultiPolygon: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.MultiPolygon
    Point: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Point
    Polygon: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Polygon
    Rectangle: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Rectangle
    RoundedRectangle: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.RoundedRectangle
    Text: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Text
    Unknown: typing.ClassVar[Type]  # value = axipy.cpp_core_geometry.Type.Unknown
    values: typing.ClassVar[dict]  # value = {'Unknown': axipy.cpp_core_geometry.Type.Unknown, 'Point': axipy.cpp_core_geometry.Type.Point, 'Line': axipy.cpp_core_geometry.Type.Line, 'LineString': axipy.cpp_core_geometry.Type.LineString, 'Polygon': axipy.cpp_core_geometry.Type.Polygon, 'MultiPoint': axipy.cpp_core_geometry.Type.MultiPoint, 'MultiLineString': axipy.cpp_core_geometry.Type.MultiLineString, 'MultiPolygon': axipy.cpp_core_geometry.Type.MultiPolygon, 'GeometryCollection': axipy.cpp_core_geometry.Type.GeometryCollection, 'Arc': axipy.cpp_core_geometry.Type.Arc, 'Ellipse': axipy.cpp_core_geometry.Type.Ellipse, 'Rectangle': axipy.cpp_core_geometry.Type.Rectangle, 'RoundedRectangle': axipy.cpp_core_geometry.Type.RoundedRectangle, 'Text': axipy.cpp_core_geometry.Type.Text}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
Linear: StyleGeometryType  # value = axipy.cpp_core_geometry.StyleGeometryType.Linear
MultiGeometry: StyleGeometryType  # value = axipy.cpp_core_geometry.StyleGeometryType.MultiGeometry
Point: StyleGeometryType  # value = axipy.cpp_core_geometry.StyleGeometryType.Point
Polygonal: StyleGeometryType  # value = axipy.cpp_core_geometry.StyleGeometryType.Polygonal
Text: StyleGeometryType  # value = axipy.cpp_core_geometry.StyleGeometryType.Text
