from typing import TYPE_CHECKING, List

from axipy._internal._shadow_instance_factory import _shadow_manager

if TYPE_CHECKING:
    from axipy import ActionButton

__all__: List[str] = []


class _MenuFilePosition:

    def append(self, button: "ActionButton") -> None:
        self._insert(button, "", True)

    def insert_before(self, button: "ActionButton", text: str) -> None:
        self._insert(button, text, True)

    def insert_after(self, button: "ActionButton", text: str) -> None:
        self._insert(button, text, False)

    @staticmethod
    def _insert(button: "ActionButton", text: str, before: bool) -> None:
        action = button.action
        _shadow_manager.menu_bar.add_menu_button(action, text, before, button.observer_id)
