from typing import Any, List, Protocol

import shiboken2

__all__: List[str] = [
    "_is_valid",
    "_shiboken2_is_valid",
]


class _IsValid(Protocol):
    # noinspection PyPep8Naming
    def isValid(self) -> bool: ...


def _is_valid(shadow: _IsValid) -> bool:
    if shadow is None:
        return False

    if not shiboken2.isValid(shadow):
        return False

    return shadow.isValid()


def _shiboken2_dump(shadow: Any) -> None:
    print(shiboken2.dump(shadow))


def _shiboken2_is_valid(shadow: Any) -> bool:
    return shiboken2.isValid(shadow)
