from typing import overload
import PySide2.QtCore
import shiboken2
import typing
T = typing.TypeVar('T')

class QSerialPort(PySide2.QtCore.QIODevice):
    class BaudRate:
        Baud115200: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud1200: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud19200: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud2400: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud38400: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud4800: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud57600: typing.ClassVar[QSerialPort.BaudRate] = ...
        Baud9600: typing.ClassVar[QSerialPort.BaudRate] = ...
        UnknownBaud: typing.ClassVar[QSerialPort.BaudRate] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.BaudRate: ...

    class DataBits:
        Data5: typing.ClassVar[QSerialPort.DataBits] = ...
        Data6: typing.ClassVar[QSerialPort.DataBits] = ...
        Data7: typing.ClassVar[QSerialPort.DataBits] = ...
        Data8: typing.ClassVar[QSerialPort.DataBits] = ...
        UnknownDataBits: typing.ClassVar[QSerialPort.DataBits] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.DataBits: ...

    class DataErrorPolicy:
        IgnorePolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
        PassZeroPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
        SkipPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
        StopReceivingPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
        UnknownPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.DataErrorPolicy: ...

    class Direction:
        AllDirections: typing.ClassVar[QSerialPort.Direction] = ...
        Input: typing.ClassVar[QSerialPort.Direction] = ...
        Output: typing.ClassVar[QSerialPort.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSerialPort.Directions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...

    class Directions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSerialPort.Directions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.Directions: ...

    class FlowControl:
        HardwareControl: typing.ClassVar[QSerialPort.FlowControl] = ...
        NoFlowControl: typing.ClassVar[QSerialPort.FlowControl] = ...
        SoftwareControl: typing.ClassVar[QSerialPort.FlowControl] = ...
        UnknownFlowControl: typing.ClassVar[QSerialPort.FlowControl] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.FlowControl: ...

    class Parity:
        EvenParity: typing.ClassVar[QSerialPort.Parity] = ...
        MarkParity: typing.ClassVar[QSerialPort.Parity] = ...
        NoParity: typing.ClassVar[QSerialPort.Parity] = ...
        OddParity: typing.ClassVar[QSerialPort.Parity] = ...
        SpaceParity: typing.ClassVar[QSerialPort.Parity] = ...
        UnknownParity: typing.ClassVar[QSerialPort.Parity] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.Parity: ...

    class PinoutSignal:
        ClearToSendSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        DataCarrierDetectSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        DataSetReadySignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        DataTerminalReadySignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        NoSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        ReceivedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        RequestToSendSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        RingIndicatorSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        SecondaryReceivedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        SecondaryTransmittedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        TransmittedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSerialPort.PinoutSignals: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...

    class PinoutSignals:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QSerialPort.PinoutSignals: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.PinoutSignals: ...

    class SerialPortError:
        BreakConditionError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        DeviceNotFoundError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        FramingError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        NoError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        NotOpenError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        OpenError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        ParityError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        PermissionError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        ReadError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        ResourceError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        TimeoutError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        UnknownError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        UnsupportedOperationError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        WriteError: typing.ClassVar[QSerialPort.SerialPortError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.SerialPortError: ...

    class StopBits:
        OneAndHalfStop: typing.ClassVar[QSerialPort.StopBits] = ...
        OneStop: typing.ClassVar[QSerialPort.StopBits] = ...
        TwoStop: typing.ClassVar[QSerialPort.StopBits] = ...
        UnknownStopBits: typing.ClassVar[QSerialPort.StopBits] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __and__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __rand__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __ror__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __sub__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
        def __xor__(self, other: typing.SupportsInt) -> QSerialPort.StopBits: ...
    AllDirections: typing.ClassVar[QSerialPort.Direction] = ...
    Baud115200: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud1200: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud19200: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud2400: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud38400: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud4800: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud57600: typing.ClassVar[QSerialPort.BaudRate] = ...
    Baud9600: typing.ClassVar[QSerialPort.BaudRate] = ...
    BreakConditionError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    ClearToSendSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    Data5: typing.ClassVar[QSerialPort.DataBits] = ...
    Data6: typing.ClassVar[QSerialPort.DataBits] = ...
    Data7: typing.ClassVar[QSerialPort.DataBits] = ...
    Data8: typing.ClassVar[QSerialPort.DataBits] = ...
    DataCarrierDetectSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    DataSetReadySignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    DataTerminalReadySignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    DeviceNotFoundError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    EvenParity: typing.ClassVar[QSerialPort.Parity] = ...
    FramingError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    HardwareControl: typing.ClassVar[QSerialPort.FlowControl] = ...
    IgnorePolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
    Input: typing.ClassVar[QSerialPort.Direction] = ...
    MarkParity: typing.ClassVar[QSerialPort.Parity] = ...
    NoError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    NoFlowControl: typing.ClassVar[QSerialPort.FlowControl] = ...
    NoParity: typing.ClassVar[QSerialPort.Parity] = ...
    NoSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    NotOpenError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    OddParity: typing.ClassVar[QSerialPort.Parity] = ...
    OneAndHalfStop: typing.ClassVar[QSerialPort.StopBits] = ...
    OneStop: typing.ClassVar[QSerialPort.StopBits] = ...
    OpenError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    Output: typing.ClassVar[QSerialPort.Direction] = ...
    ParityError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    PassZeroPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
    PermissionError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    ReadError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    ReceivedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    RequestToSendSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    ResourceError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    RingIndicatorSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    SecondaryReceivedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    SecondaryTransmittedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    SkipPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
    SoftwareControl: typing.ClassVar[QSerialPort.FlowControl] = ...
    SpaceParity: typing.ClassVar[QSerialPort.Parity] = ...
    StopReceivingPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
    TimeoutError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    TransmittedDataSignal: typing.ClassVar[QSerialPort.PinoutSignal] = ...
    TwoStop: typing.ClassVar[QSerialPort.StopBits] = ...
    UnknownBaud: typing.ClassVar[QSerialPort.BaudRate] = ...
    UnknownDataBits: typing.ClassVar[QSerialPort.DataBits] = ...
    UnknownError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    UnknownFlowControl: typing.ClassVar[QSerialPort.FlowControl] = ...
    UnknownParity: typing.ClassVar[QSerialPort.Parity] = ...
    UnknownPolicy: typing.ClassVar[QSerialPort.DataErrorPolicy] = ...
    UnknownStopBits: typing.ClassVar[QSerialPort.StopBits] = ...
    UnsupportedOperationError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    WriteError: typing.ClassVar[QSerialPort.SerialPortError] = ...
    baudRateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    breakEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataBitsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataErrorPolicyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataTerminalReadyChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    errorOccurred: typing.ClassVar[PySide2.QtCore.Signal] = ...
    flowControlChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    parityChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    requestToSendChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    settingsRestoredOnCloseChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    stopBitsChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    @overload
    def __init__(self, info: QSerialPortInfo, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aboutToClose: typing.Callable = ..., baudRate: int = ..., baudRateChanged: typing.Callable = ..., breakEnabled: bool = ..., breakEnabledChanged: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., dataBits: QSerialPort.DataBits = ..., dataBitsChanged: typing.Callable = ..., dataErrorPolicy: QSerialPort.DataErrorPolicy = ..., dataErrorPolicyChanged: typing.Callable = ..., dataTerminalReady: bool = ..., dataTerminalReadyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., flowControl: QSerialPort.FlowControl = ..., flowControlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parity: QSerialPort.Parity = ..., parityChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., requestToSend: bool = ..., requestToSendChanged: typing.Callable = ..., settingsRestoredOnClose: bool = ..., settingsRestoredOnCloseChanged: typing.Callable = ..., stopBits: QSerialPort.StopBits = ..., stopBitsChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, name: str, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aboutToClose: typing.Callable = ..., baudRate: int = ..., baudRateChanged: typing.Callable = ..., breakEnabled: bool = ..., breakEnabledChanged: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., dataBits: QSerialPort.DataBits = ..., dataBitsChanged: typing.Callable = ..., dataErrorPolicy: QSerialPort.DataErrorPolicy = ..., dataErrorPolicyChanged: typing.Callable = ..., dataTerminalReady: bool = ..., dataTerminalReadyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., flowControl: QSerialPort.FlowControl = ..., flowControlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parity: QSerialPort.Parity = ..., parityChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., requestToSend: bool = ..., requestToSendChanged: typing.Callable = ..., settingsRestoredOnClose: bool = ..., settingsRestoredOnCloseChanged: typing.Callable = ..., stopBits: QSerialPort.StopBits = ..., stopBitsChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aboutToClose: typing.Callable = ..., baudRate: int = ..., baudRateChanged: typing.Callable = ..., breakEnabled: bool = ..., breakEnabledChanged: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., dataBits: QSerialPort.DataBits = ..., dataBitsChanged: typing.Callable = ..., dataErrorPolicy: QSerialPort.DataErrorPolicy = ..., dataErrorPolicyChanged: typing.Callable = ..., dataTerminalReady: bool = ..., dataTerminalReadyChanged: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., flowControl: QSerialPort.FlowControl = ..., flowControlChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parity: QSerialPort.Parity = ..., parityChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., requestToSend: bool = ..., requestToSendChanged: typing.Callable = ..., settingsRestoredOnClose: bool = ..., settingsRestoredOnCloseChanged: typing.Callable = ..., stopBits: QSerialPort.StopBits = ..., stopBitsChanged: typing.Callable = ...) -> None: ...
    def atEnd(self) -> bool: ...
    def baudRate(self, directions: typing.Union[QSerialPort.Directions,QSerialPort.Direction] = ...) -> int: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def clear(self, directions: typing.Union[QSerialPort.Directions,QSerialPort.Direction] = ...) -> bool: ...
    def clearError(self) -> None: ...
    def close(self) -> None: ...
    def dataBits(self) -> QSerialPort.DataBits: ...
    def dataErrorPolicy(self) -> QSerialPort.DataErrorPolicy: ...
    def flowControl(self) -> QSerialPort.FlowControl: ...
    def flush(self) -> bool: ...
    def handle(self) -> int: ...
    def isBreakEnabled(self) -> bool: ...
    def isDataTerminalReady(self) -> bool: ...
    def isRequestToSend(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def open(self, mode: typing.Union[PySide2.QtCore.QIODevice.OpenMode,PySide2.QtCore.QIODevice.OpenModeFlag]) -> bool: ...
    def parity(self) -> QSerialPort.Parity: ...
    def pinoutSignals(self) -> typing.Union[QSerialPort.PinoutSignals,QSerialPort.PinoutSignal]: ...
    def portName(self) -> str: ...
    def readBufferSize(self) -> int: ...
    def readData(self, data: bytes, maxSize: int) -> int: ...
    def readLineData(self, data: bytes, maxSize: int) -> int: ...
    def sendBreak(self, duration: int = ...) -> bool: ...
    def setBaudRate(self, baudRate: int, directions: typing.Union[QSerialPort.Directions,QSerialPort.Direction] = ...) -> bool: ...
    def setBreakEnabled(self, set: bool = ...) -> bool: ...
    def setDataBits(self, dataBits: QSerialPort.DataBits) -> bool: ...
    def setDataErrorPolicy(self, policy: QSerialPort.DataErrorPolicy = ...) -> bool: ...
    def setDataTerminalReady(self, set: bool) -> bool: ...
    def setFlowControl(self, flowControl: QSerialPort.FlowControl) -> bool: ...
    def setParity(self, parity: QSerialPort.Parity) -> bool: ...
    def setPort(self, info: QSerialPortInfo) -> None: ...
    def setPortName(self, name: str) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def setRequestToSend(self, set: bool) -> bool: ...
    def setSettingsRestoredOnClose(self, restore: bool) -> None: ...
    def setStopBits(self, stopBits: QSerialPort.StopBits) -> bool: ...
    def settingsRestoredOnClose(self) -> bool: ...
    def stopBits(self) -> QSerialPort.StopBits: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def writeData(self, data: bytes, maxSize: int) -> int: ...

class QSerialPortInfo(shiboken2.Object):
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, other: QSerialPortInfo) -> None: ...
    @overload
    def __init__(self, port: QSerialPort) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def availablePorts(cls) -> typing.List[QSerialPortInfo]: ...
    def description(self) -> str: ...
    def hasProductIdentifier(self) -> bool: ...
    def hasVendorIdentifier(self) -> bool: ...
    def isBusy(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def manufacturer(self) -> str: ...
    def portName(self) -> str: ...
    def productIdentifier(self) -> int: ...
    def serialNumber(self) -> str: ...
    @classmethod
    def standardBaudRates(cls) -> typing.List[int]: ...
    def swap(self, other: QSerialPortInfo) -> None: ...
    def systemLocation(self) -> str: ...
    def vendorIdentifier(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
