from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import PySide2.QtWidgets
import shiboken2
import typing
T = typing.TypeVar('T')

class QAbstractPrintDialog(PySide2.QtWidgets.QDialog):
    class PrintDialogOption:
        DontUseSheet: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        None_: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintCollateCopies: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintCurrentPage: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintPageRange: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintSelection: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintShowPageSize: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        PrintToFile: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...

    class PrintDialogOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintDialogOptions: ...

    class PrintRange:
        AllPages: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
        CurrentPage: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
        PageRange: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
        Selection: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractPrintDialog.PrintRange: ...
    AllPages: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
    CurrentPage: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
    DontUseSheet: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    None_: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PageRange: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
    PrintCollateCopies: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PrintCurrentPage: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PrintPageRange: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PrintSelection: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PrintShowPageSize: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    PrintToFile: typing.ClassVar[QAbstractPrintDialog.PrintDialogOption] = ...
    Selection: typing.ClassVar[QAbstractPrintDialog.PrintRange] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, printer: QPrinter, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def addEnabledOption(self, option: QAbstractPrintDialog.PrintDialogOption) -> None: ...
    def enabledOptions(self) -> typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption]: ...
    def fromPage(self) -> int: ...
    def isOptionEnabled(self, option: QAbstractPrintDialog.PrintDialogOption) -> bool: ...
    def maxPage(self) -> int: ...
    def minPage(self) -> int: ...
    def printRange(self) -> QAbstractPrintDialog.PrintRange: ...
    def printer(self) -> QPrinter: ...
    def setEnabledOptions(self, options: typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption]) -> None: ...
    def setFromTo(self, fromPage: int, toPage: int) -> None: ...
    def setMinMax(self, min: int, max: int) -> None: ...
    def setOptionTabs(self, tabs: typing.Iterable[PySide2.QtWidgets.QWidget]) -> None: ...
    def setPrintRange(self, range: QAbstractPrintDialog.PrintRange) -> None: ...
    def toPage(self) -> int: ...

class QPageSetupDialog(PySide2.QtWidgets.QDialog):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, printer: QPrinter, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def done(self, result: int) -> None: ...
    def exec_(self) -> int: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def printer(self) -> QPrinter: ...
    def setVisible(self, visible: bool) -> None: ...

class QPrintDialog(QAbstractPrintDialog):
    accepted: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, printer: QPrinter, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., options: typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption] = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def done(self, result: int) -> None: ...
    def exec_(self) -> int: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def options(self) -> typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption]: ...
    def setOption(self, option: QAbstractPrintDialog.PrintDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: typing.Union[QAbstractPrintDialog.PrintDialogOptions,QAbstractPrintDialog.PrintDialogOption]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def testOption(self, option: QAbstractPrintDialog.PrintDialogOption) -> bool: ...

class QPrintEngine(shiboken2.Object):
    class PrintEnginePropertyKey:
        PPK_CollateCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_ColorMode: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_CopyCount: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_Creator: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_CustomBase: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_CustomPaperSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_DocumentName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_Duplex: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_FontEmbedding: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_FullPage: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_NumberOfCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_Orientation: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_OutputFileName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PageMargins: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PageOrder: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PageRect: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PaperName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PaperRect: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PaperSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PaperSource: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PaperSources: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PrinterName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_PrinterProgram: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_QPageLayout: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_QPageMargins: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_QPageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_Resolution: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_SelectionOption: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_SupportedResolutions: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_SupportsMultipleCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        PPK_WindowsPageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __and__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrintEngine.PrintEnginePropertyKey: ...
    PPK_CollateCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_ColorMode: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_CopyCount: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_Creator: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_CustomBase: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_CustomPaperSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_DocumentName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_Duplex: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_FontEmbedding: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_FullPage: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_NumberOfCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_Orientation: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_OutputFileName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PageMargins: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PageOrder: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PageRect: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PaperName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PaperRect: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PaperSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PaperSource: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PaperSources: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PrinterName: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_PrinterProgram: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_QPageLayout: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_QPageMargins: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_QPageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_Resolution: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_SelectionOption: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_SupportedResolutions: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_SupportsMultipleCopies: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    PPK_WindowsPageSize: typing.ClassVar[QPrintEngine.PrintEnginePropertyKey] = ...
    def __init__(self) -> None: ...
    def abort(self) -> bool: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def printerState(self) -> QPrinter.PrinterState: ...
    def property(self, key: QPrintEngine.PrintEnginePropertyKey) -> typing.Any: ...
    def setProperty(self, key: QPrintEngine.PrintEnginePropertyKey, value: typing.Any) -> None: ...

class QPrintPreviewDialog(PySide2.QtWidgets.QDialog):
    paintRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, printer: QPrinter, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., paintRequested: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accepted: typing.Callable = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., finished: typing.Callable = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., paintRequested: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., rect: PySide2.QtCore.QRect = ..., rejected: typing.Callable = ..., size: PySide2.QtCore.QSize = ..., sizeGripEnabled: bool = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def done(self, result: int) -> None: ...
    @overload
    def open(self, receiver: PySide2.QtCore.QObject, member: bytes) -> None: ...
    @overload
    def open(self) -> None: ...
    def printer(self) -> QPrinter: ...
    def setVisible(self, visible: bool) -> None: ...

class QPrintPreviewWidget(PySide2.QtWidgets.QWidget):
    class ViewMode:
        AllPagesView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
        FacingPagesView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
        SinglePageView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ViewMode: ...

    class ZoomMode:
        CustomZoom: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
        FitInView: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
        FitToWidth: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrintPreviewWidget.ZoomMode: ...
    AllPagesView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
    CustomZoom: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
    FacingPagesView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
    FitInView: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
    FitToWidth: typing.ClassVar[QPrintPreviewWidget.ZoomMode] = ...
    SinglePageView: typing.ClassVar[QPrintPreviewWidget.ViewMode] = ...
    paintRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    previewChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    @overload
    def __init__(self, printer: QPrinter, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., paintRequested: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., previewChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[PySide2.QtWidgets.QWidget,None] = ..., flags: typing.Union[PySide2.QtCore.Qt.WindowFlags,PySide2.QtCore.Qt.WindowType] = ..., acceptDrops: bool = ..., accessibleDescription: str = ..., accessibleName: str = ..., autoFillBackground: bool = ..., baseSize: PySide2.QtCore.QSize = ..., childrenRect: PySide2.QtCore.QRect = ..., childrenRegion: PySide2.QtGui.QRegion = ..., contextMenuPolicy: PySide2.QtCore.Qt.ContextMenuPolicy = ..., cursor: typing.Union[PySide2.QtGui.QCursor,PySide2.QtCore.Qt.CursorShape] = ..., customContextMenuRequested: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., focus: bool = ..., focusPolicy: PySide2.QtCore.Qt.FocusPolicy = ..., font: PySide2.QtGui.QFont = ..., frameGeometry: PySide2.QtCore.QRect = ..., frameSize: PySide2.QtCore.QSize = ..., fullScreen: bool = ..., geometry: PySide2.QtCore.QRect = ..., height: int = ..., inputMethodHints: typing.Union[PySide2.QtCore.Qt.InputMethodHints,PySide2.QtCore.Qt.InputMethodHint] = ..., isActiveWindow: bool = ..., layoutDirection: PySide2.QtCore.Qt.LayoutDirection = ..., locale: PySide2.QtCore.QLocale = ..., maximized: bool = ..., maximumHeight: int = ..., maximumSize: PySide2.QtCore.QSize = ..., maximumWidth: int = ..., minimized: bool = ..., minimumHeight: int = ..., minimumSize: PySide2.QtCore.QSize = ..., minimumSizeHint: PySide2.QtCore.QSize = ..., minimumWidth: int = ..., modal: bool = ..., mouseTracking: bool = ..., normalGeometry: PySide2.QtCore.QRect = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., paintRequested: typing.Callable = ..., palette: PySide2.QtGui.QPalette = ..., pos: PySide2.QtCore.QPoint = ..., previewChanged: typing.Callable = ..., rect: PySide2.QtCore.QRect = ..., size: PySide2.QtCore.QSize = ..., sizeHint: PySide2.QtCore.QSize = ..., sizeIncrement: PySide2.QtCore.QSize = ..., sizePolicy: PySide2.QtWidgets.QSizePolicy = ..., statusTip: str = ..., styleSheet: str = ..., tabletTracking: bool = ..., toolTip: str = ..., toolTipDuration: int = ..., updatesEnabled: bool = ..., visible: bool = ..., whatsThis: str = ..., width: int = ..., windowFilePath: str = ..., windowIcon: PySide2.QtGui.QIcon = ..., windowIconChanged: typing.Callable = ..., windowIconText: str = ..., windowIconTextChanged: typing.Callable = ..., windowModality: PySide2.QtCore.Qt.WindowModality = ..., windowModified: bool = ..., windowOpacity: float = ..., windowTitle: str = ..., windowTitleChanged: typing.Callable = ..., x: int = ..., y: int = ...) -> None: ...
    def currentPage(self) -> int: ...
    def fitInView(self) -> None: ...
    def fitToWidth(self) -> None: ...
    def orientation(self) -> QPrinter.Orientation: ...
    def pageCount(self) -> int: ...
    def print_(self) -> None: ...
    def setAllPagesViewMode(self) -> None: ...
    def setCurrentPage(self, pageNumber: int) -> None: ...
    def setFacingPagesViewMode(self) -> None: ...
    def setLandscapeOrientation(self) -> None: ...
    def setOrientation(self, orientation: QPrinter.Orientation) -> None: ...
    def setPortraitOrientation(self) -> None: ...
    def setSinglePageViewMode(self) -> None: ...
    def setViewMode(self, viewMode: QPrintPreviewWidget.ViewMode) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setZoomFactor(self, zoomFactor: float) -> None: ...
    def setZoomMode(self, zoomMode: QPrintPreviewWidget.ZoomMode) -> None: ...
    def updatePreview(self) -> None: ...
    def viewMode(self) -> QPrintPreviewWidget.ViewMode: ...
    def zoomFactor(self) -> float: ...
    def zoomIn(self, zoom: float = ...) -> None: ...
    def zoomMode(self) -> QPrintPreviewWidget.ZoomMode: ...
    def zoomOut(self, zoom: float = ...) -> None: ...

class QPrinter(PySide2.QtGui.QPagedPaintDevice):
    class ColorMode:
        Color: typing.ClassVar[QPrinter.ColorMode] = ...
        GrayScale: typing.ClassVar[QPrinter.ColorMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.ColorMode: ...

    class DuplexMode:
        DuplexAuto: typing.ClassVar[QPrinter.DuplexMode] = ...
        DuplexLongSide: typing.ClassVar[QPrinter.DuplexMode] = ...
        DuplexNone: typing.ClassVar[QPrinter.DuplexMode] = ...
        DuplexShortSide: typing.ClassVar[QPrinter.DuplexMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.DuplexMode: ...

    class Orientation:
        Landscape: typing.ClassVar[QPrinter.Orientation] = ...
        Portrait: typing.ClassVar[QPrinter.Orientation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.Orientation: ...

    class OutputFormat:
        NativeFormat: typing.ClassVar[QPrinter.OutputFormat] = ...
        PdfFormat: typing.ClassVar[QPrinter.OutputFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.OutputFormat: ...

    class PageOrder:
        FirstPageFirst: typing.ClassVar[QPrinter.PageOrder] = ...
        LastPageFirst: typing.ClassVar[QPrinter.PageOrder] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.PageOrder: ...

    class PaperSource:
        Auto: typing.ClassVar[QPrinter.PaperSource] = ...
        Cassette: typing.ClassVar[QPrinter.PaperSource] = ...
        CustomSource: typing.ClassVar[QPrinter.PaperSource] = ...
        Envelope: typing.ClassVar[QPrinter.PaperSource] = ...
        EnvelopeManual: typing.ClassVar[QPrinter.PaperSource] = ...
        FormSource: typing.ClassVar[QPrinter.PaperSource] = ...
        LargeCapacity: typing.ClassVar[QPrinter.PaperSource] = ...
        LargeFormat: typing.ClassVar[QPrinter.PaperSource] = ...
        LastPaperSource: typing.ClassVar[QPrinter.PaperSource] = ...
        Lower: typing.ClassVar[QPrinter.PaperSource] = ...
        Manual: typing.ClassVar[QPrinter.PaperSource] = ...
        MaxPageSource: typing.ClassVar[QPrinter.PaperSource] = ...
        Middle: typing.ClassVar[QPrinter.PaperSource] = ...
        OnlyOne: typing.ClassVar[QPrinter.PaperSource] = ...
        SmallFormat: typing.ClassVar[QPrinter.PaperSource] = ...
        Tractor: typing.ClassVar[QPrinter.PaperSource] = ...
        Upper: typing.ClassVar[QPrinter.PaperSource] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.PaperSource: ...

    class PrintRange:
        AllPages: typing.ClassVar[QPrinter.PrintRange] = ...
        CurrentPage: typing.ClassVar[QPrinter.PrintRange] = ...
        PageRange: typing.ClassVar[QPrinter.PrintRange] = ...
        Selection: typing.ClassVar[QPrinter.PrintRange] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.PrintRange: ...

    class PrinterMode:
        HighResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
        PrinterResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
        ScreenResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.PrinterMode: ...

    class PrinterState:
        Aborted: typing.ClassVar[QPrinter.PrinterState] = ...
        Active: typing.ClassVar[QPrinter.PrinterState] = ...
        Error: typing.ClassVar[QPrinter.PrinterState] = ...
        Idle: typing.ClassVar[QPrinter.PrinterState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.PrinterState: ...

    class Unit:
        Cicero: typing.ClassVar[QPrinter.Unit] = ...
        DevicePixel: typing.ClassVar[QPrinter.Unit] = ...
        Didot: typing.ClassVar[QPrinter.Unit] = ...
        Inch: typing.ClassVar[QPrinter.Unit] = ...
        Millimeter: typing.ClassVar[QPrinter.Unit] = ...
        Pica: typing.ClassVar[QPrinter.Unit] = ...
        Point: typing.ClassVar[QPrinter.Unit] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __and__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __rand__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __rmul__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __ror__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __rsub__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __rxor__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __sub__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
        def __xor__(self, other: typing.SupportsInt) -> QPrinter.Unit: ...
    Aborted: typing.ClassVar[QPrinter.PrinterState] = ...
    Active: typing.ClassVar[QPrinter.PrinterState] = ...
    AllPages: typing.ClassVar[QPrinter.PrintRange] = ...
    Auto: typing.ClassVar[QPrinter.PaperSource] = ...
    Cassette: typing.ClassVar[QPrinter.PaperSource] = ...
    Cicero: typing.ClassVar[QPrinter.Unit] = ...
    Color: typing.ClassVar[QPrinter.ColorMode] = ...
    CurrentPage: typing.ClassVar[QPrinter.PrintRange] = ...
    CustomSource: typing.ClassVar[QPrinter.PaperSource] = ...
    DevicePixel: typing.ClassVar[QPrinter.Unit] = ...
    Didot: typing.ClassVar[QPrinter.Unit] = ...
    DuplexAuto: typing.ClassVar[QPrinter.DuplexMode] = ...
    DuplexLongSide: typing.ClassVar[QPrinter.DuplexMode] = ...
    DuplexNone: typing.ClassVar[QPrinter.DuplexMode] = ...
    DuplexShortSide: typing.ClassVar[QPrinter.DuplexMode] = ...
    Envelope: typing.ClassVar[QPrinter.PaperSource] = ...
    EnvelopeManual: typing.ClassVar[QPrinter.PaperSource] = ...
    Error: typing.ClassVar[QPrinter.PrinterState] = ...
    FirstPageFirst: typing.ClassVar[QPrinter.PageOrder] = ...
    FormSource: typing.ClassVar[QPrinter.PaperSource] = ...
    GrayScale: typing.ClassVar[QPrinter.ColorMode] = ...
    HighResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
    Idle: typing.ClassVar[QPrinter.PrinterState] = ...
    Inch: typing.ClassVar[QPrinter.Unit] = ...
    Landscape: typing.ClassVar[QPrinter.Orientation] = ...
    LargeCapacity: typing.ClassVar[QPrinter.PaperSource] = ...
    LargeFormat: typing.ClassVar[QPrinter.PaperSource] = ...
    LastPageFirst: typing.ClassVar[QPrinter.PageOrder] = ...
    LastPaperSource: typing.ClassVar[QPrinter.PaperSource] = ...
    Lower: typing.ClassVar[QPrinter.PaperSource] = ...
    Manual: typing.ClassVar[QPrinter.PaperSource] = ...
    MaxPageSource: typing.ClassVar[QPrinter.PaperSource] = ...
    Middle: typing.ClassVar[QPrinter.PaperSource] = ...
    Millimeter: typing.ClassVar[QPrinter.Unit] = ...
    NativeFormat: typing.ClassVar[QPrinter.OutputFormat] = ...
    OnlyOne: typing.ClassVar[QPrinter.PaperSource] = ...
    PageRange: typing.ClassVar[QPrinter.PrintRange] = ...
    PdfFormat: typing.ClassVar[QPrinter.OutputFormat] = ...
    Pica: typing.ClassVar[QPrinter.Unit] = ...
    Point: typing.ClassVar[QPrinter.Unit] = ...
    Portrait: typing.ClassVar[QPrinter.Orientation] = ...
    PrinterResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
    ScreenResolution: typing.ClassVar[QPrinter.PrinterMode] = ...
    Selection: typing.ClassVar[QPrinter.PrintRange] = ...
    SmallFormat: typing.ClassVar[QPrinter.PaperSource] = ...
    Tractor: typing.ClassVar[QPrinter.PaperSource] = ...
    Upper: typing.ClassVar[QPrinter.PaperSource] = ...
    @overload
    def __init__(self, printer: QPrinterInfo, mode: QPrinter.PrinterMode = ...) -> None: ...
    @overload
    def __init__(self, mode: QPrinter.PrinterMode = ...) -> None: ...
    def abort(self) -> bool: ...
    def actualNumCopies(self) -> int: ...
    def collateCopies(self) -> bool: ...
    def colorMode(self) -> QPrinter.ColorMode: ...
    def copyCount(self) -> int: ...
    def creator(self) -> str: ...
    def devType(self) -> int: ...
    def docName(self) -> str: ...
    def doubleSidedPrinting(self) -> bool: ...
    def duplex(self) -> QPrinter.DuplexMode: ...
    def fontEmbeddingEnabled(self) -> bool: ...
    def fromPage(self) -> int: ...
    def fullPage(self) -> bool: ...
    def getPageMargins(self, unit: QPrinter.Unit) -> typing.Tuple[float,float,float,float]: ...
    def isValid(self) -> bool: ...
    def metric(self, arg__1: PySide2.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def newPage(self) -> bool: ...
    def numCopies(self) -> int: ...
    def orientation(self) -> QPrinter.Orientation: ...
    def outputFileName(self) -> str: ...
    def outputFormat(self) -> QPrinter.OutputFormat: ...
    def pageOrder(self) -> QPrinter.PageOrder: ...
    @overload
    def pageRect(self, arg__1: QPrinter.Unit) -> PySide2.QtCore.QRectF: ...
    @overload
    def pageRect(self) -> PySide2.QtCore.QRect: ...
    def pageSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def paintEngine(self) -> PySide2.QtGui.QPaintEngine: ...
    def paperName(self) -> str: ...
    @overload
    def paperRect(self, arg__1: QPrinter.Unit) -> PySide2.QtCore.QRectF: ...
    @overload
    def paperRect(self) -> PySide2.QtCore.QRect: ...
    @overload
    def paperSize(self, unit: QPrinter.Unit) -> PySide2.QtCore.QSizeF: ...
    @overload
    def paperSize(self) -> PySide2.QtGui.QPagedPaintDevice.PageSize: ...
    def paperSource(self) -> QPrinter.PaperSource: ...
    def pdfVersion(self) -> PySide2.QtGui.QPagedPaintDevice.PdfVersion: ...
    def printEngine(self) -> QPrintEngine: ...
    def printProgram(self) -> str: ...
    def printRange(self) -> QPrinter.PrintRange: ...
    def printerName(self) -> str: ...
    def printerState(self) -> QPrinter.PrinterState: ...
    def resolution(self) -> int: ...
    def setCollateCopies(self, collate: bool) -> None: ...
    def setColorMode(self, arg__1: QPrinter.ColorMode) -> None: ...
    def setCopyCount(self, arg__1: int) -> None: ...
    def setCreator(self, arg__1: str) -> None: ...
    def setDocName(self, arg__1: str) -> None: ...
    def setDoubleSidedPrinting(self, enable: bool) -> None: ...
    def setDuplex(self, duplex: QPrinter.DuplexMode) -> None: ...
    def setEngines(self, printEngine: QPrintEngine, paintEngine: PySide2.QtGui.QPaintEngine) -> None: ...
    def setFontEmbeddingEnabled(self, enable: bool) -> None: ...
    def setFromTo(self, fromPage: int, toPage: int) -> None: ...
    def setFullPage(self, arg__1: bool) -> None: ...
    def setMargins(self, m: PySide2.QtGui.QPagedPaintDevice.Margins) -> None: ...
    def setNumCopies(self, arg__1: int) -> None: ...
    def setOrientation(self, arg__1: QPrinter.Orientation) -> None: ...
    def setOutputFileName(self, arg__1: str) -> None: ...
    def setOutputFormat(self, format: QPrinter.OutputFormat) -> None: ...
    @overload
    def setPageMargins(self, left: float, top: float, right: float, bottom: float, unit: QPrinter.Unit) -> None: ...
    @overload
    def setPageMargins(self, margins: PySide2.QtCore.QMarginsF) -> bool: ...
    def setPageOrder(self, arg__1: QPrinter.PageOrder) -> None: ...
    @overload
    def setPageSize(self, arg__1: PySide2.QtGui.QPageSize) -> bool: ...
    @overload
    def setPageSize(self, arg__1: PySide2.QtGui.QPagedPaintDevice.PageSize) -> None: ...
    def setPageSizeMM(self, size: PySide2.QtCore.QSizeF) -> None: ...
    def setPaperName(self, paperName: str) -> None: ...
    @overload
    def setPaperSize(self, paperSize: PySide2.QtCore.QSizeF, unit: QPrinter.Unit) -> None: ...
    @overload
    def setPaperSize(self, arg__1: PySide2.QtGui.QPagedPaintDevice.PageSize) -> None: ...
    def setPaperSource(self, arg__1: QPrinter.PaperSource) -> None: ...
    def setPdfVersion(self, version: PySide2.QtGui.QPagedPaintDevice.PdfVersion) -> None: ...
    def setPrintProgram(self, arg__1: str) -> None: ...
    def setPrintRange(self, range: QPrinter.PrintRange) -> None: ...
    def setPrinterName(self, arg__1: str) -> None: ...
    def setResolution(self, arg__1: int) -> None: ...
    def setWinPageSize(self, winPageSize: int) -> None: ...
    def supportedResolutions(self) -> typing.List[int]: ...
    def supportsMultipleCopies(self) -> bool: ...
    def toPage(self) -> int: ...
    def winPageSize(self) -> int: ...

class QPrinterInfo(shiboken2.Object):
    @overload
    def __init__(self, other: QPrinterInfo) -> None: ...
    @overload
    def __init__(self, printer: QPrinter) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def availablePrinterNames(cls) -> typing.List[str]: ...
    @classmethod
    def availablePrinters(cls) -> typing.List[QPrinterInfo]: ...
    def defaultColorMode(self) -> QPrinter.ColorMode: ...
    def defaultDuplexMode(self) -> QPrinter.DuplexMode: ...
    def defaultPageSize(self) -> PySide2.QtGui.QPageSize: ...
    @classmethod
    def defaultPrinter(cls) -> QPrinterInfo: ...
    @classmethod
    def defaultPrinterName(cls) -> str: ...
    def description(self) -> str: ...
    def isDefault(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isRemote(self) -> bool: ...
    def location(self) -> str: ...
    def makeAndModel(self) -> str: ...
    def maximumPhysicalPageSize(self) -> PySide2.QtGui.QPageSize: ...
    def minimumPhysicalPageSize(self) -> PySide2.QtGui.QPageSize: ...
    @classmethod
    def printerInfo(cls, printerName: str) -> QPrinterInfo: ...
    def printerName(self) -> str: ...
    def state(self) -> QPrinter.PrinterState: ...
    def supportedColorModes(self) -> typing.List[QPrinter.ColorMode]: ...
    def supportedDuplexModes(self) -> typing.List[QPrinter.DuplexMode]: ...
    def supportedPageSizes(self) -> typing.List[PySide2.QtGui.QPageSize]: ...
    def supportedPaperSizes(self) -> typing.List[PySide2.QtGui.QPagedPaintDevice.PageSize]: ...
    def supportedResolutions(self) -> typing.List[int]: ...
    def supportedSizesWithNames(self) -> typing.List[typing.Tuple[str,PySide2.QtCore.QSizeF]]: ...
    def supportsCustomPageSizes(self) -> bool: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
