from typing import overload
import PySide2.QtCore
import PySide2.QtGui
import shiboken2
import typing
T = typing.TypeVar('T')

class Qt3DCore(shiboken2.Object):
    class ChangeFlag:
        AllChanges: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        CallbackTriggered: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        CommandRequested: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        ComponentAdded: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        ComponentRemoved: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        NodeCreated: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        NodeDeleted: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        PropertyUpdated: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        PropertyValueAdded: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        PropertyValueRemoved: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt3DCore.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...

    class ChangeFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt3DCore.ChangeFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.ChangeFlags: ...

    class QAbstractAspect(PySide2.QtCore.QObject):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def rootEntityId(self) -> Qt3DCore.QNodeId: ...
        def unregisterBackendType(self, arg__1: PySide2.QtCore.QMetaObject) -> None: ...

    class QAbstractSkeleton(Qt3DCore.QNode):
        jointCountChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def jointCount(self) -> int: ...

    class QArmature(Qt3DCore.QComponent):
        skeletonChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DCore.QArmature.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ..., skeleton: Qt3DCore.QAbstractSkeleton = ..., skeletonChanged: typing.Callable = ...) -> None: ...
        def setSkeleton(self, skeleton: Qt3DCore.QAbstractSkeleton) -> None: ...
        def skeleton(self) -> Qt3DCore.QAbstractSkeleton: ...

    class QAspectEngine(PySide2.QtCore.QObject):
        class RunMode:
            Automatic: typing.ClassVar[Qt3DCore.QAspectEngine.RunMode] = ...
            Manual: typing.ClassVar[Qt3DCore.QAspectEngine.RunMode] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QAspectEngine.RunMode: ...
        Automatic: typing.ClassVar[Qt3DCore.QAspectEngine.RunMode] = ...
        Manual: typing.ClassVar[Qt3DCore.QAspectEngine.RunMode] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
        def aspects(self) -> typing.List[Qt3DCore.QAbstractAspect]: ...
        def executeCommand(self, command: str) -> typing.Any: ...
        def processFrame(self) -> None: ...
        @overload
        def registerAspect(self, aspect: Qt3DCore.QAbstractAspect) -> None: ...
        @overload
        def registerAspect(self, name: str) -> None: ...
        def runMode(self) -> Qt3DCore.QAspectEngine.RunMode: ...
        def setRunMode(self, mode: Qt3DCore.QAspectEngine.RunMode) -> None: ...
        @overload
        def unregisterAspect(self, aspect: Qt3DCore.QAbstractAspect) -> None: ...
        @overload
        def unregisterAspect(self, name: str) -> None: ...

    class QAspectJob(shiboken2.Object):
        def __init__(self) -> None: ...
        def run(self) -> None: ...

    class QBackendNode(shiboken2.Object):
        class Mode:
            ReadOnly: typing.ClassVar[Qt3DCore.QBackendNode.Mode] = ...
            ReadWrite: typing.ClassVar[Qt3DCore.QBackendNode.Mode] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QBackendNode.Mode: ...
        ReadOnly: typing.ClassVar[Qt3DCore.QBackendNode.Mode] = ...
        ReadWrite: typing.ClassVar[Qt3DCore.QBackendNode.Mode] = ...
        def __init__(self, mode: Qt3DCore.QBackendNode.Mode = ...) -> None: ...
        def isEnabled(self) -> bool: ...
        def mode(self) -> Qt3DCore.QBackendNode.Mode: ...
        def peerId(self) -> Qt3DCore.QNodeId: ...
        def setEnabled(self, enabled: bool) -> None: ...

    class QComponent(Qt3DCore.QNode):
        addedToEntity: typing.ClassVar[PySide2.QtCore.Signal] = ...
        removedFromEntity: typing.ClassVar[PySide2.QtCore.Signal] = ...
        shareableChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DCore.QComponent.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., shareableChanged: typing.Callable = ...) -> None: ...
        def entities(self) -> typing.List[Qt3DCore.QEntity]: ...
        def isShareable(self) -> bool: ...
        def setShareable(self, isShareable: bool) -> None: ...

    class QComponentAddedChange(Qt3DCore.QSceneChange):
        @overload
        def __init__(self, component: Qt3DCore.QComponent, entity: Qt3DCore.QEntity) -> None: ...
        @overload
        def __init__(self, entity: Qt3DCore.QEntity, component: Qt3DCore.QComponent) -> None: ...
        def componentId(self) -> Qt3DCore.QNodeId: ...
        def componentMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
        def entityId(self) -> Qt3DCore.QNodeId: ...

    class QComponentRemovedChange(Qt3DCore.QSceneChange):
        @overload
        def __init__(self, component: Qt3DCore.QComponent, entity: Qt3DCore.QEntity) -> None: ...
        @overload
        def __init__(self, entity: Qt3DCore.QEntity, component: Qt3DCore.QComponent) -> None: ...
        def componentId(self) -> Qt3DCore.QNodeId: ...
        def componentMetaObject(self) -> PySide2.QtCore.QMetaObject: ...
        def entityId(self) -> Qt3DCore.QNodeId: ...

    class QDynamicPropertyUpdatedChange(Qt3DCore.QPropertyUpdatedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def propertyName(self) -> PySide2.QtCore.QByteArray: ...
        def setPropertyName(self, name: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> None: ...
        def setValue(self, value: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...

    class QEntity(Qt3DCore.QNode):
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DCore.QEntity.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def addComponent(self, comp: Qt3DCore.QComponent) -> None: ...
        def components(self) -> typing.List[Qt3DCore.QComponent]: ...
        def parentEntity(self) -> Qt3DCore.QEntity: ...
        def removeComponent(self, comp: Qt3DCore.QComponent) -> None: ...

    class QJoint(Qt3DCore.QNode):
        inverseBindMatrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        translationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DCore.QJoint.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., inverseBindMatrix: PySide2.QtGui.QMatrix4x4 = ..., inverseBindMatrixChanged: typing.Callable = ..., name: str = ..., nameChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., rotation: PySide2.QtGui.QQuaternion = ..., rotationChanged: typing.Callable = ..., rotationX: float = ..., rotationXChanged: typing.Callable = ..., rotationY: float = ..., rotationYChanged: typing.Callable = ..., rotationZ: float = ..., rotationZChanged: typing.Callable = ..., scale: PySide2.QtGui.QVector3D = ..., scaleChanged: typing.Callable = ..., translation: PySide2.QtGui.QVector3D = ..., translationChanged: typing.Callable = ...) -> None: ...
        def addChildJoint(self, joint: Qt3DCore.QJoint) -> None: ...
        def childJoints(self) -> typing.List[Qt3DCore.QJoint]: ...
        def inverseBindMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        def name(self) -> str: ...
        def removeChildJoint(self, joint: Qt3DCore.QJoint) -> None: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def rotationX(self) -> float: ...
        def rotationY(self) -> float: ...
        def rotationZ(self) -> float: ...
        def scale(self) -> PySide2.QtGui.QVector3D: ...
        def setInverseBindMatrix(self, inverseBindMatrix: PySide2.QtGui.QMatrix4x4) -> None: ...
        def setName(self, name: str) -> None: ...
        def setRotation(self, rotation: PySide2.QtGui.QQuaternion) -> None: ...
        def setRotationX(self, rotationX: float) -> None: ...
        def setRotationY(self, rotationY: float) -> None: ...
        def setRotationZ(self, rotationZ: float) -> None: ...
        def setScale(self, scale: PySide2.QtGui.QVector3D) -> None: ...
        def setToIdentity(self) -> None: ...
        def setTranslation(self, translation: PySide2.QtGui.QVector3D) -> None: ...
        def translation(self) -> PySide2.QtGui.QVector3D: ...

    class QNode(PySide2.QtCore.QObject):
        class PropertyTrackingMode:
            DontTrackValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
            TrackAllValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
            TrackFinalValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QNode.PropertyTrackingMode: ...
        DontTrackValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
        TrackAllValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
        TrackFinalValues: typing.ClassVar[Qt3DCore.QNode.PropertyTrackingMode] = ...
        defaultPropertyTrackingModeChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        enabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        nodeDestroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
        parentChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DCore.QNode.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ...) -> None: ...
        def blockNotifications(self, block: bool) -> bool: ...
        def childNodes(self) -> typing.List[Qt3DCore.QNode]: ...
        def clearPropertyTracking(self, propertyName: str) -> None: ...
        def clearPropertyTrackings(self) -> None: ...
        def defaultPropertyTrackingMode(self) -> Qt3DCore.QNode.PropertyTrackingMode: ...
        def id(self) -> Qt3DCore.QNodeId: ...
        def isEnabled(self) -> bool: ...
        def notificationsBlocked(self) -> bool: ...
        def parentNode(self) -> Qt3DCore.QNode: ...
        def propertyTracking(self, propertyName: str) -> Qt3DCore.QNode.PropertyTrackingMode: ...
        def setDefaultPropertyTrackingMode(self, mode: Qt3DCore.QNode.PropertyTrackingMode) -> None: ...
        def setEnabled(self, isEnabled: bool) -> None: ...
        @overload
        def setParent(self, parent: Qt3DCore.QNode) -> None: ...
        @overload
        def setParent(self, parent: typing.Union[PySide2.QtCore.QObject,None]) -> None: ...
        def setPropertyTracking(self, propertyName: str, trackMode: Qt3DCore.QNode.PropertyTrackingMode) -> None: ...

    class QNodeCommand(Qt3DCore.QSceneChange):
        def __init__(self, id: Qt3DCore.QNodeId) -> None: ...
        def commandId(self) -> int: ...
        def data(self) -> typing.Any: ...
        def inReplyTo(self) -> int: ...
        def name(self) -> str: ...
        def setData(self, data: typing.Any) -> None: ...
        def setName(self, name: str) -> None: ...
        def setReplyToCommandId(self, id: int) -> None: ...

    class QNodeCreatedChangeBase(Qt3DCore.QSceneChange):
        def __init__(self, node: Qt3DCore.QNode) -> None: ...
        def isNodeEnabled(self) -> bool: ...
        def parentId(self) -> Qt3DCore.QNodeId: ...

    class QNodeDestroyedChange(Qt3DCore.QSceneChange):
        def __init__(self, node: Qt3DCore.QNode, subtreeIdsAndTypes: typing.List[Qt3DCore.QNodeIdTypePair]) -> None: ...
        def subtreeIdsAndTypes(self) -> typing.List[Qt3DCore.QNodeIdTypePair]: ...

    class QNodeId(shiboken2.Object):
        @overload
        def __init__(self, QNodeId: Qt3DCore.QNodeId) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @classmethod
        def createId(cls) -> Qt3DCore.QNodeId: ...
        def id(self) -> int: ...
        def isNull(self) -> bool: ...
        def __bool__(self) -> bool: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...

    class QNodeIdTypePair(shiboken2.Object):
        id: typing.Any
        type: typing.Any
        @overload
        def __init__(self, _id: Qt3DCore.QNodeId, _type: PySide2.QtCore.QMetaObject) -> None: ...
        @overload
        def __init__(self, QNodeIdTypePair: Qt3DCore.QNodeIdTypePair) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...

    class QPropertyNodeAddedChange(Qt3DCore.QStaticPropertyValueAddedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId, node: Qt3DCore.QNode) -> None: ...
        def addedNodeId(self) -> Qt3DCore.QNodeId: ...

    class QPropertyNodeRemovedChange(Qt3DCore.QStaticPropertyValueRemovedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId, node: Qt3DCore.QNode) -> None: ...
        def removedNodeId(self) -> Qt3DCore.QNodeId: ...

    class QPropertyUpdatedChange(Qt3DCore.QStaticPropertyUpdatedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def setValue(self, value: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...

    class QPropertyUpdatedChangeBase(Qt3DCore.QSceneChange):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...

    class QPropertyValueAddedChange(Qt3DCore.QStaticPropertyValueAddedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def addedValue(self) -> typing.Any: ...
        def setAddedValue(self, value: typing.Any) -> None: ...

    class QPropertyValueAddedChangeBase(Qt3DCore.QSceneChange):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...

    class QPropertyValueRemovedChange(Qt3DCore.QStaticPropertyValueRemovedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def removedValue(self) -> typing.Any: ...
        def setRemovedValue(self, value: typing.Any) -> None: ...

    class QPropertyValueRemovedChangeBase(Qt3DCore.QSceneChange):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...

    class QSceneChange(shiboken2.Object):
        class DeliveryFlag:
            BackendNodes: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
            DeliverToAll: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
            Nodes: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
    
        class DeliveryFlags:
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __invert__(self) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QSceneChange.DeliveryFlags: ...
        BackendNodes: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
        DeliverToAll: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
        Nodes: typing.ClassVar[Qt3DCore.QSceneChange.DeliveryFlag] = ...
        def __init__(self, type: Qt3DCore.ChangeFlag, subjectId: Qt3DCore.QNodeId) -> None: ...
        def deliveryFlags(self) -> typing.Union[Qt3DCore.QSceneChange.DeliveryFlags,Qt3DCore.QSceneChange.DeliveryFlag]: ...
        def setDeliveryFlags(self, flags: typing.Union[Qt3DCore.QSceneChange.DeliveryFlags,Qt3DCore.QSceneChange.DeliveryFlag]) -> None: ...
        def subjectId(self) -> Qt3DCore.QNodeId: ...
        def type(self) -> Qt3DCore.ChangeFlag: ...

    class QSkeleton(Qt3DCore.QAbstractSkeleton):
        rootJointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., defaultPropertyTrackingMode: Qt3DCore.QSkeleton.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., jointCount: int = ..., jointCountChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., rootJoint: Qt3DCore.QJoint = ..., rootJointChanged: typing.Callable = ...) -> None: ...
        def rootJoint(self) -> Qt3DCore.QJoint: ...
        def setRootJoint(self, rootJoint: Qt3DCore.QJoint) -> None: ...

    class QSkeletonLoader(Qt3DCore.QAbstractSkeleton):
        class Status:
            Error: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
            NotReady: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
            Ready: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
            values: typing.ClassVar[dict] = ...
            name: typing.Any
            @classmethod
            def __init__(cls, *args, **kwargs) -> None: ...
            def __add__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __and__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __bool__(self) -> bool: ...
            def __eq__(self, other: object) -> bool: ...
            def __ge__(self, other: object) -> bool: ...
            def __gt__(self, other: object) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> typing.Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other: object) -> bool: ...
            def __lt__(self, other: object) -> bool: ...
            def __mul__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __ne__(self, other: object) -> bool: ...
            def __or__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __pos__(self) -> typing.Any: ...
            def __radd__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __rand__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __rmul__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __ror__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __rsub__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __rxor__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __sub__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
            def __xor__(self, other: typing.SupportsInt) -> Qt3DCore.QSkeletonLoader.Status: ...
        Error: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
        NotReady: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
        Ready: typing.ClassVar[Qt3DCore.QSkeletonLoader.Status] = ...
        createJointsEnabledChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rootJointChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        sourceChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        statusChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        @overload
        def __init__(self, source: PySide2.QtCore.QUrl, parent: typing.Union[Qt3DCore.QNode,None] = ..., createJointsEnabled: bool = ..., createJointsEnabledChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DCore.QSkeletonLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., jointCount: int = ..., jointCountChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., rootJoint: Qt3DCore.QJoint = ..., rootJointChanged: typing.Callable = ..., sourceChanged: typing.Callable = ..., status: Qt3DCore.QSkeletonLoader.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        @overload
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., createJointsEnabled: bool = ..., createJointsEnabledChanged: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DCore.QSkeletonLoader.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., jointCount: int = ..., jointCountChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., rootJoint: Qt3DCore.QJoint = ..., rootJointChanged: typing.Callable = ..., source: PySide2.QtCore.QUrl = ..., sourceChanged: typing.Callable = ..., status: Qt3DCore.QSkeletonLoader.Status = ..., statusChanged: typing.Callable = ...) -> None: ...
        def isCreateJointsEnabled(self) -> bool: ...
        def rootJoint(self) -> Qt3DCore.QJoint: ...
        def setCreateJointsEnabled(self, enabled: bool) -> None: ...
        def setSource(self, source: PySide2.QtCore.QUrl) -> None: ...
        def source(self) -> PySide2.QtCore.QUrl: ...
        def status(self) -> Qt3DCore.QSkeletonLoader.Status: ...

    class QStaticPropertyUpdatedChangeBase(Qt3DCore.QPropertyUpdatedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def propertyName(self) -> bytes: ...
        def setPropertyName(self, name: bytes) -> None: ...

    class QStaticPropertyValueAddedChangeBase(Qt3DCore.QPropertyValueAddedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def propertyName(self) -> bytes: ...
        def setPropertyName(self, name: bytes) -> None: ...

    class QStaticPropertyValueRemovedChangeBase(Qt3DCore.QPropertyValueRemovedChangeBase):
        def __init__(self, subjectId: Qt3DCore.QNodeId) -> None: ...
        def propertyName(self) -> bytes: ...
        def setPropertyName(self, name: bytes) -> None: ...

    class QTransform(Qt3DCore.QComponent):
        matrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationXChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationYChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        rotationZChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scale3DChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        scaleChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
        translationChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        worldMatrixChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
        def __init__(self, parent: typing.Union[Qt3DCore.QNode,None] = ..., addedToEntity: typing.Callable = ..., defaultPropertyTrackingMode: Qt3DCore.QTransform.PropertyTrackingMode = ..., defaultPropertyTrackingModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., enabled: bool = ..., enabledChanged: typing.Callable = ..., isShareable: bool = ..., matrix: PySide2.QtGui.QMatrix4x4 = ..., matrixChanged: typing.Callable = ..., nodeDestroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., parentChanged: typing.Callable = ..., removedFromEntity: typing.Callable = ..., rotation: PySide2.QtGui.QQuaternion = ..., rotationChanged: typing.Callable = ..., rotationX: float = ..., rotationXChanged: typing.Callable = ..., rotationY: float = ..., rotationYChanged: typing.Callable = ..., rotationZ: float = ..., rotationZChanged: typing.Callable = ..., scale: float = ..., scale3D: PySide2.QtGui.QVector3D = ..., scale3DChanged: typing.Callable = ..., scaleChanged: typing.Callable = ..., shareableChanged: typing.Callable = ..., translation: PySide2.QtGui.QVector3D = ..., translationChanged: typing.Callable = ..., worldMatrix: PySide2.QtGui.QMatrix4x4 = ..., worldMatrixChanged: typing.Callable = ...) -> None: ...
        @classmethod
        def fromAxes(cls, xAxis: PySide2.QtGui.QVector3D, yAxis: PySide2.QtGui.QVector3D, zAxis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromAxesAndAngles(cls, axis1: PySide2.QtGui.QVector3D, angle1: float, axis2: PySide2.QtGui.QVector3D, angle2: float, axis3: PySide2.QtGui.QVector3D, angle3: float) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromAxesAndAngles(cls, axis1: PySide2.QtGui.QVector3D, angle1: float, axis2: PySide2.QtGui.QVector3D, angle2: float) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromAxisAndAngle(cls, x: float, y: float, z: float, angle: float) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromAxisAndAngle(cls, axis: PySide2.QtGui.QVector3D, angle: float) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromEulerAngles(cls, pitch: float, yaw: float, roll: float) -> PySide2.QtGui.QQuaternion: ...
        @overload
        @classmethod
        def fromEulerAngles(cls, eulerAngles: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QQuaternion: ...
        def matrix(self) -> PySide2.QtGui.QMatrix4x4: ...
        @classmethod
        def rotateAround(cls, point: PySide2.QtGui.QVector3D, angle: float, axis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QMatrix4x4: ...
        @classmethod
        def rotateFromAxes(cls, xAxis: PySide2.QtGui.QVector3D, yAxis: PySide2.QtGui.QVector3D, zAxis: PySide2.QtGui.QVector3D) -> PySide2.QtGui.QMatrix4x4: ...
        def rotation(self) -> PySide2.QtGui.QQuaternion: ...
        def rotationX(self) -> float: ...
        def rotationY(self) -> float: ...
        def rotationZ(self) -> float: ...
        def scale(self) -> float: ...
        def scale3D(self) -> PySide2.QtGui.QVector3D: ...
        def setMatrix(self, matrix: PySide2.QtGui.QMatrix4x4) -> None: ...
        def setRotation(self, rotation: PySide2.QtGui.QQuaternion) -> None: ...
        def setRotationX(self, rotationX: float) -> None: ...
        def setRotationY(self, rotationY: float) -> None: ...
        def setRotationZ(self, rotationZ: float) -> None: ...
        def setScale(self, scale: float) -> None: ...
        def setScale3D(self, scale: PySide2.QtGui.QVector3D) -> None: ...
        def setTranslation(self, translation: PySide2.QtGui.QVector3D) -> None: ...
        def translation(self) -> PySide2.QtGui.QVector3D: ...
        def worldMatrix(self) -> PySide2.QtGui.QMatrix4x4: ...
    AllChanges: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    CallbackTriggered: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    CommandRequested: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    ComponentAdded: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    ComponentRemoved: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    NodeCreated: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    NodeDeleted: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    PropertyUpdated: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    PropertyValueAdded: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    PropertyValueRemoved: typing.ClassVar[Qt3DCore.ChangeFlag] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def qHash(cls, id: Qt3DCore.QNodeId, seed: int = ...) -> int: ...
    @classmethod
    def qIdForNode(cls, node: Qt3DCore.QNode) -> Qt3DCore.QNodeId: ...
