import os

import axipy
from PySide2.QtCore import QFile
from PySide2.QtGui import QDoubleValidator
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QDialog
from axipy import data_manager

from ru_rubtsov_axioma_topo_tools.toolprocessing.runnerSnapNodes import RunnerSnapNodes
from ru_rubtsov_axioma_topo_tools.ui.DlgFormTopoCorrect import getTolleranceTable


class DlgSnapNodes(QDialog):
    def __init__(self,parent=None):
        super().__init__(parent)
        self.__cls_runner=None
        self.__ui=self.load_ui("DlgSnapNodes.ui",parent)
        self.__ui.ln_tollerance.setValidator(QDoubleValidator(999999, 0, 8))
        self.__ui.cmb_tables.currentIndexChanged.connect(self.__change_tab)
        self.__initTableList()
        self.__ui.finished.connect(self.__cancel)
        self.__ui.pb_run.clicked.connect(self.__run)
        self.__ui.pb_cancel.clicked.connect(self.__cancel)
    def load_ui(self,name_resource,parent):
        loader = QUiLoader()
        path = os.path.join(os.path.dirname(__file__),name_resource)
        ui_file = QFile(path)
        ui_file.open(QFile.ReadOnly)
        ui  = loader.load(ui_file,parent)
        ui_file.close()
        return ui
    def __initTableList(self):
        for tab in data_manager.tables:
            if not tab.is_spatial:
                continue
            self.__ui.cmb_tables.addItem(tab.name)
        self.__ui.cmb_tables.setCurrentIndex(0)
    def __change_tab(self):
        name_cur_tab=self.__ui.cmb_tables.currentText()

        tollerance=getTolleranceTable(name_cur_tab)
        if tollerance is not None:
            self.__ui.ln_tollerance.setText(str(tollerance))
    def exec_(self):
        self.__ui.exec()
    def __cancel(self):
        if self.__cls_runner is None:
            self.__ui.close()
        else:
            pass
            #self.__cls_runner.setCancel()
    def __update_progress(self,value):
        self.__ui.progressBar.setValue(value)
    def __run(self):
        name_table=self.__ui.cmb_tables.currentText()
        tollerance=float(self.__ui.ln_tollerance.text())
        self.__cls_runner=RunnerSnapNodes(name_table,tollerance)
        self.__ui.pb_run.setEnabled(False)
        self.__ui.pb_cancel.setText("Прервать")
        self.__cls_runner.change_progress.connect(self.__update_progress)
        def run_process(t: axipy.Task):
            self.__cls_runner.run()

        #self.__run_task = axipy.Task(run_process)
        #self.__run_task.finished.connect(self.__finish_task)
        #self.__run_task.start()
        self.__cls_runner.run()
        self.__ui.pb_run.setEnabled(True)
        self.__ui.pb_cancel.setText("Закрыть")
        self.__cls_runner.change_progress.disconnect()
        self.__cls_runner = None
    def __cancel(self):
        if self.__cls_runner is None:
            self.__ui.close()
        else:
            self.__cls_runner.setCancel()
    def __finish_task(self):
        self.__ui.pb_run.setEnabled(True)
        self.__ui.pb_cancel.setText("Закрыть")
        self.__cls_runner.change_progress.disconnect()
        self.__cls_runner=None



