from pathlib import Path

import axipy
from PySide2.QtCore import QTemporaryDir
from axipy import Attribute, data_manager, Table


class TempTable:
    def __init__(self,post_refix='topoCheck'):
        self.__folder=Path(self.__create_folder())
        self.__postprefix=post_refix
        self.__default_att=self.__creatDefAttribute()
        #axipy.data_manager.removed.connect(self.__close_table)
        self.__temp_tables=[]
    def create(self,name_base_table,cs_base):
        name_table=name_base_table+"_"+self.__postprefix+".tab"
        if not self.__folder.exists():
            self.__folder=Path(self.__create_folder())

        path_table=self.__folder / name_table
        if path_table.exists():
            path_table=self.__findUnicalNameTab(name_base_table)
        schema=axipy.Schema(*self.__default_att,coordsystem=cs_base)
        table=axipy.provider_manager.tab.create_open(str(path_table),schema)
        if table is not None:
            self.__temp_tables.append(str(path_table))
            table.destroyed.connect(lambda:self.__destroyedTable(str(path_table)))
        return table
    def __creatDefAttribute(self):
        attrs = [Attribute.integer("id"),Attribute.integer("type"),Attribute.string("name", 15)]
        return attrs
    def __findUnicalNameTab(self,name_tab):
        index=1
        isFind=True
        while isFind:
            temp_name=name_tab+"_"+self.__postprefix+"_"+str(index)+".tab"
            path_table = self.__folder / temp_name
            if not path_table.exists():
                return path_table
            index=index+1
    def __create_folder(self):
        self.__qt_folder=QTemporaryDir()
        self.__qt_folder.setAutoRemove(True)
        return Path(self.__qt_folder.path())
    def __close_table(self,name_tab):
        tab=data_manager.find(name_tab)
        if not isinstance(tab,Table):
            return
        path_tab=None
        try:
            path_tab=tab.file_name
        except:
            pass
        if path_tab is not None:
            str_path=str(path_tab)
            if str_path in self.__temp_tables:
                def destroyedTable():
                    self.__temp_tables.remove(str_path)
                    axipy.provider_manager.tab.remove_table_files(path_tab)
                    if len(self.__temp_tables) == 0:
                        self.__qt_folder.remove()
                tab.destroyed.connect(self.__destroyedTable)
    def __destroyedTable(self,path_tab):
        self.__temp_tables.remove(path_tab)
        axipy.provider_manager.tab.remove_table_files(path_tab)
        if len(self.__temp_tables) == 0:
            self.__qt_folder.remove()

    def closeAll(self):
        tables=data_manager.tables
        for tab in tables:
            path_tab=None
            try:
                path_tab=tab.file_name
            except:
                pass
            if path_tab is not None:
                if str(path_tab) in self.__temp_tables:
                    #tab.commit()
                    tab.rollback()
                    tab.close()


manager_temp_folder=TempTable()