from axipy import Feature


class TableCacheUpdate:
    def __init__(self,tab,size=100):
        self.__tab=tab
        self.__cache_features=[]
        self.__size=size
    def add(self,ft):
        if isinstance(ft,list):
            if len(ft)==0:
                return
            for item_ft in ft:
                self.add(item_ft)
        else:
            if isinstance(ft,dict):
                self.__dictToFeature(ft,)
            else:
                self.__cache_features.append(ft)
        self.end()

    def __dictToFeature(self,obj):
        geo = obj['geometry']
        if geo is None:
            return
        obj.pop('geometry')
        ft = Feature(obj, geometry=geo)
        self.__cache_features.append(ft)
    def end(self,all_write=False):
        if all_write and len(self.__cache_features)>0:
            self.__tab.update(self.__cache_features)
            self.__cache_features.clear()
            return
        if len(self.__cache_features)>self.__size:
            self.__tab.update(self.__cache_features)
            self.__cache_features.clear()