import axipy as axp

from .settings_manager import SettingsManager
from .style_catalog_main import StyleCatalogMain
from .utils import try_except_silent


class StyleCatalogs(axp.Plugin):

    def __init__(self) -> None:
        self.icon_path = str(self.plugin_dir / "images" / "style_catalog.png")
        self._button = axp.ActionButton(
            title=self.tr("Наборы\nстилей"),  # todo
            on_click=self.on_click,
            icon=self.icon_path,
        )

        position = axp.Position(self.tr("Основные"), self.tr("Настройки"))
        position.add(self._button)

        self.title = self.tr("Наборы стилей")

        # self.settings.clear()

        self.settings_manager = SettingsManager(self)
        self.apply_settings_on_restart()

    @try_except_silent
    def apply_settings_on_restart(self) -> None:
        self.settings_manager.apply_style_catalogs_settings()

    def unload(self) -> None:
        self._button.remove()

    def on_click(self) -> None:
        w = StyleCatalogMain(self, parent=axp.view_manager.global_parent)  # WA_DeleteOnClose
        w.open()
