from typing import Final

import axipy
from PySide2.QtCore import Qt
from PySide2.QtGui import QIcon
from .dialog import Dialog
from .observer import PointsCatalogObserver

ICON_NAME: Final[str] = "points_catalogue"


class PointsCatalog(axipy.Plugin):

    def __init__(self) -> None:
        self.title = self.tr("Каталог точек")

        self._points_catalog_observer = PointsCatalogObserver()

        self._button = axipy.ActionButton(
            title=self.title,
            tooltip=self.tr("Построение каталога точек."),
            on_click=self.on_click,
            enable_on=self._points_catalog_observer,
            icon=QIcon.fromTheme(ICON_NAME),
        )

        position = axipy.Position(self.tr("Таблица"), self.tr("Создание"))
        position.add(self._button)

    def on_click(self) -> None:
        dialog_ = Dialog(self, axipy.view_manager.global_parent)
        dialog_.setAttribute(Qt.WA_DeleteOnClose, True)
        dialog_.setWindowIcon(QIcon.fromTheme(ICON_NAME))
        dialog_.open()

    def unload(self) -> None:
        self._points_catalog_observer.unload()
        self._button.remove()
