from typing import Union, Iterable, Generator, Any

import axipy
from PySide2.QtCore import Signal
from axipy._internal._observer_abc import _ObserverABC


def get_spatial_tables() -> Generator[axipy.Table, Any, None]:
    return (t for t in axipy.data_manager.tables if t.is_spatial)


class SpatialTablesObserver(_ObserverABC):
    @property
    def name(self) -> str:
        return "ru_axioma_gis_find_features_no_geom_SpatialTablesObserver"

    @property
    def signals(self) -> Union[Signal, Iterable[Signal]]:
        return axipy.data_manager.updated

    def test_value(self) -> bool:
        return len(tuple(get_spatial_tables())) > 0
