from __future__ import annotations

from pathlib import Path

import axipy
from PySide2.QtGui import QIcon
from .export_to_file_dialog import ExportToFileDialog


class ExportToFilePlugin(axipy.Plugin):

    def __init__(self) -> None:
        self.title = self.tr("Экспорт таблиц")
        self.tooltip = self.tr("Экспорт таблиц со сменой КС.")

        self.last_save_path: Path | None = None

        self.__button = axipy.ActionButton(
            title=self.title,
            on_click=self.on_click,
            icon=QIcon.fromTheme("table_save_copy_as"),
        )
        position = axipy.Position(self.tr("Основные"), self.tr("Команды"))
        position.add(self.__button)

    def unload(self) -> None:
        self.__button.remove()

    def on_click(self) -> None:
        dialog = ExportToFileDialog(self)
        dialog.setWindowIcon(self.__button.action.icon())
        dialog.open()
