from typing import Iterable, Union, cast

import axipy
from axipy._internal._observer_abc import _ObserverABC
from PySide2.QtCore import Signal

from .utils import _flat_geom_generator


def check_single_geom(g: axipy.Geometry) -> bool:
    if isinstance(g, axipy.Polygon):
        return True
    elif isinstance(g, axipy.LineString):
        return g._shadow.is_closed()

    return False


def check_geom(g: axipy.Geometry) -> bool:
    if isinstance(g, axipy.GeometryCollection):
        g = cast(Iterable, g)
        return any(map(lambda elem: check_single_geom(elem), g))

    return check_single_geom(g)


def _check_if_any_closed_contours_selected(task: axipy.DialogTask) -> bool:
    task.title = "Проверка наличия контуров"
    task.message = "Проверка наличия замкнутых контуров в выборке."

    selection_table = axipy.data_manager.selection
    if selection_table is None:
        return False

    return any(map(check_geom, _flat_geom_generator(selection_table.items(), selection_table.count(), task)))


def test_value() -> bool:
    selection_table = axipy.data_manager.selection
    if selection_table is None:
        return False
    count = selection_table.count()
    if count == 1:
        f = next(selection_table.items())
        g = f.geometry
        if g is None:
            return False
        return check_geom(g)

    elif count > 1:
        return True

    return False


class RedirectContoursObserver(_ObserverABC):
    @property
    def name(self) -> str:
        return "ru_axioma_gis_axipy_cadtools_RedirectContoursObserver"

    @property
    def signals(self) -> Union[Signal, Iterable[Signal]]:
        return axipy.selection_manager.changed, axipy.ObserverManager.SelectionEditableIsSame.changed

    def test_value(self) -> bool:
        return test_value() and axipy.ObserverManager.SelectionEditableIsSame.value
