from math import atan2, cos, pi, sin

from PySide2.QtCore import QLineF, QPointF, Qt
from PySide2.QtGui import QBrush, QPainter, QPen, QPolygonF


class ArrowLine:
    def __init__(self, line: QLineF) -> None:
        super().__init__()
        self._line = line
        self._arrow_size = 10.0
        self._p_angle = atan2(self._line.dy(), -self._line.dx())
        self._arrow_p1 = self._line.p2() + QPointF(
            sin(self._p_angle + pi / 3) * self._arrow_size, cos(self._p_angle + pi / 3) * self._arrow_size
        )
        self._arrow_p2 = self._line.p2() + QPointF(
            sin(self._p_angle + pi - pi / 3) * self._arrow_size, cos(self._p_angle + pi - pi / 3) * self._arrow_size
        )
        self._arrow_head = QPolygonF([line.p2(), self._arrow_p1, self._arrow_p2])
        self._arrow_p1_out = self._line.p2() + QPointF(
            sin(self._p_angle + pi / 3) * (self._arrow_size + 5.0),
            cos(self._p_angle + pi / 3) * (self._arrow_size + 5.0),
        )
        self._arrow_p2_out = self._line.p2() + QPointF(
            sin(self._p_angle + pi - pi / 3) * (self._arrow_size + 5.0),
            cos(self._p_angle + pi - pi / 3) * (self._arrow_size + 5.0),
        )
        self._arrow_head_out = QPolygonF([line.p2(), self._arrow_p1_out, self._arrow_p2_out])
        self._color = Qt.red

    def drawArrow(self, painter: QPainter):
        pen = QPen(Qt.darkGray, 3)
        brush = QBrush(Qt.darkGray)
        painter.setPen(pen)
        painter.setBrush(brush)
        painter.drawLine(self._line)
        painter.drawPolygon(self._arrow_head_out)
        pen.setWidth(1)
        pen.setColor(self._color)
        brush.setColor(self._color)
        painter.setPen(pen)
        painter.setBrush(brush)
        painter.drawLine(self._line)
        painter.drawPolygon(self._arrow_head_out)

    def set_arrow_size(self, size: float):
        self._arrow_size = size

    def set_color(self, color: Qt.GlobalColor):
        self._color = color
